/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import gnu.trove.iterator.TLongIterator;
import gnu.trove.iterator.TLongLongIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.handle.GuildSetupNode;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.JDALogger;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;
import org.slf4j.Logger;

public class GuildSetupController {
    protected static final int CHUNK_TIMEOUT = 10000;
    protected static final Logger log = JDALogger.getLog(GuildSetupController.class);
    private final UpstreamReference<JDAImpl> api;
    private final TLongObjectMap<GuildSetupNode> setupNodes = new TLongObjectHashMap();
    private final TLongSet chunkingGuilds = new TLongHashSet();
    private final TLongLongMap pendingChunks = new TLongLongHashMap();
    private final TLongSet syncingGuilds;
    private int incompleteCount = 0;
    private int syncingCount = 0;
    private Future<?> timeoutHandle;
    protected StatusListener listener = (id, oldStatus, newStatus) -> log.trace("[{}] Updated status {}->{}", new Object[]{id, oldStatus, newStatus});

    public GuildSetupController(JDAImpl api) {
        this.api = new UpstreamReference<JDAImpl>(api);
        this.syncingGuilds = this.isClient() ? new TLongHashSet() : null;
    }

    JDAImpl getJDA() {
        return this.api.get();
    }

    boolean isClient() {
        return this.getJDA().getAccountType() == AccountType.CLIENT;
    }

    void addGuildForChunking(long id, boolean join) {
        log.trace("Adding guild for chunking ID: {}", (Object)id);
        if (join || this.incompleteCount <= 0) {
            if (this.incompleteCount <= 0) {
                this.sendChunkRequest(id);
                return;
            }
            ++this.incompleteCount;
        }
        this.chunkingGuilds.add(id);
        this.tryChunking();
    }

    void addGuildForSyncing(long id, boolean join) {
        if (!this.isClient()) {
            return;
        }
        log.trace("Adding guild for syncing ID: {}", (Object)id);
        if (join || this.incompleteCount <= 0) {
            if (this.incompleteCount <= 0) {
                this.sendSyncRequest(DataArray.empty().add(id));
                return;
            }
            ++this.syncingCount;
        }
        this.syncingGuilds.add(id);
        this.trySyncing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(long id) {
        this.setupNodes.remove(id);
        this.chunkingGuilds.remove(id);
        TLongLongMap tLongLongMap = this.pendingChunks;
        synchronized (tLongLongMap) {
            this.pendingChunks.remove(id);
        }
        if (this.syncingGuilds != null) {
            this.syncingGuilds.remove(id);
        }
    }

    public void ready(long id) {
        this.remove(id);
        WebSocketClient client = this.getJDA().getClient();
        if (--this.incompleteCount < 1 && !client.isReady()) {
            client.ready();
        } else {
            this.tryChunking();
        }
    }

    public boolean setIncompleteCount(int count) {
        boolean ready;
        log.debug("Setting incomplete count to {}", (Object)count);
        this.incompleteCount = count;
        this.syncingCount = count;
        boolean bl = ready = count == 0;
        if (ready) {
            this.getJDA().getClient().ready();
        } else {
            this.startTimeout();
        }
        return !ready;
    }

    public void onReady(long id, DataObject obj) {
        log.trace("Adding id to setup cache {}", (Object)id);
        GuildSetupNode node = new GuildSetupNode(id, this, false);
        this.setupNodes.put(id, (Object)node);
        node.handleReady(obj);
        if (node.markedUnavailable) {
            if (node.sync) {
                --this.syncingCount;
                this.trySyncing();
            }
            --this.incompleteCount;
            this.tryChunking();
        }
    }

    public void onCreate(long id, DataObject obj) {
        boolean available = obj.isNull("unavailable") || !obj.getBoolean("unavailable");
        log.trace("Received guild create for id: {} available: {}", (Object)id, (Object)available);
        GuildSetupNode node = (GuildSetupNode)this.setupNodes.get(id);
        if (node == null) {
            node = new GuildSetupNode(id, this, true);
            this.setupNodes.put(id, (Object)node);
        } else if (node.markedUnavailable && available && this.incompleteCount > 0) {
            if (node.sync) {
                ++this.syncingCount;
            }
            ++this.incompleteCount;
        }
        node.handleCreate(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onDelete(long id, DataObject obj) {
        boolean available = obj.isNull("unavailable") || !obj.getBoolean("unavailable");
        GuildSetupNode node = (GuildSetupNode)this.setupNodes.get(id);
        if (node == null) {
            return false;
        }
        log.debug("Received guild delete for id: {} available: {}", (Object)id, (Object)available);
        if (!available) {
            if (!node.markedUnavailable) {
                node.markedUnavailable = true;
                if (node.sync && !node.requestedChunk) {
                    this.syncingGuilds.remove(id);
                    --this.syncingCount;
                    this.trySyncing();
                }
                if (this.incompleteCount > 0) {
                    this.chunkingGuilds.remove(id);
                    TLongLongMap tLongLongMap = this.pendingChunks;
                    synchronized (tLongLongMap) {
                        this.pendingChunks.remove(id);
                    }
                    --this.incompleteCount;
                    this.tryChunking();
                }
            }
            node.reset();
        } else {
            node.cleanup();
            if (node.join && !node.requestedChunk) {
                this.remove(id);
            } else {
                this.ready(id);
            }
        }
        log.debug("Updated incompleteCount to {} and syncCount to {}", (Object)this.incompleteCount, (Object)this.syncingCount);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMemberChunk(long id, DataArray chunk) {
        log.debug("Received member chunk for guild id: {} size: {}", (Object)id, (Object)chunk.length());
        TLongLongMap tLongLongMap = this.pendingChunks;
        synchronized (tLongLongMap) {
            this.pendingChunks.remove(id);
        }
        GuildSetupNode node = (GuildSetupNode)this.setupNodes.get(id);
        if (node != null) {
            node.handleMemberChunk(chunk);
        }
    }

    public boolean onAddMember(long id, DataObject member) {
        GuildSetupNode node = (GuildSetupNode)this.setupNodes.get(id);
        if (node == null) {
            return false;
        }
        log.debug("Received GUILD_MEMBER_ADD during setup, adding member to guild. GuildID: {}", (Object)id);
        node.handleAddMember(member);
        return true;
    }

    public boolean onRemoveMember(long id, DataObject member) {
        GuildSetupNode node = (GuildSetupNode)this.setupNodes.get(id);
        if (node == null) {
            return false;
        }
        log.debug("Received GUILD_MEMBER_REMOVE during setup, removing member from guild. GuildID: {}", (Object)id);
        node.handleRemoveMember(member);
        return true;
    }

    public void onSync(long id, DataObject obj) {
        GuildSetupNode node = (GuildSetupNode)this.setupNodes.get(id);
        if (node != null) {
            node.handleSync(obj);
        }
    }

    public boolean isLocked(long id) {
        return this.setupNodes.containsKey(id);
    }

    public void cacheEvent(long guildId, DataObject event) {
        GuildSetupNode node = (GuildSetupNode)this.setupNodes.get(guildId);
        if (node != null) {
            node.cacheEvent(event);
        } else {
            log.warn("Attempted to cache event for a guild that is not locked. {}", (Object)event, (Object)new IllegalStateException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.setupNodes.clear();
        this.chunkingGuilds.clear();
        this.incompleteCount = 0;
        this.close();
        TLongLongMap tLongLongMap = this.pendingChunks;
        synchronized (tLongLongMap) {
            this.pendingChunks.clear();
        }
    }

    public void close() {
        if (this.timeoutHandle != null) {
            this.timeoutHandle.cancel(false);
        }
    }

    public boolean containsMember(long userId, @Nullable GuildSetupNode excludedNode) {
        TLongObjectIterator it = this.setupNodes.iterator();
        while (it.hasNext()) {
            it.advance();
            GuildSetupNode node = (GuildSetupNode)it.value();
            if (node == excludedNode || !node.containsMember(userId)) continue;
            return true;
        }
        return false;
    }

    public Set<GuildSetupNode> getSetupNodes() {
        return new HashSet<GuildSetupNode>(this.setupNodes.valueCollection());
    }

    public Set<GuildSetupNode> getSetupNodes(Status status) {
        return this.getSetupNodes().stream().filter(node -> node.status == status).collect(Collectors.toSet());
    }

    public GuildSetupNode getSetupNodeById(long id) {
        return (GuildSetupNode)this.setupNodes.get(id);
    }

    public GuildSetupNode getSetupNodeById(String id) {
        return this.getSetupNodeById(MiscUtil.parseSnowflake(id));
    }

    public void setStatusListener(StatusListener listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    int getIncompleteCount() {
        return this.incompleteCount;
    }

    int getChunkingCount() {
        return this.chunkingGuilds.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChunkRequest(Object obj) {
        log.debug("Sending chunking requests for {} guilds", (Object)(obj instanceof DataArray ? ((DataArray)obj).length() : 1));
        long timeout = System.currentTimeMillis() + 10000L;
        TLongLongMap tLongLongMap = this.pendingChunks;
        synchronized (tLongLongMap) {
            if (obj instanceof DataArray) {
                DataArray arr = (DataArray)obj;
                for (Object o : arr) {
                    this.pendingChunks.put(((Long)o).longValue(), timeout);
                }
            } else {
                this.pendingChunks.put(((Long)obj).longValue(), timeout);
            }
        }
        this.getJDA().getClient().chunkOrSyncRequest(DataObject.empty().put("op", 8).put("d", DataObject.empty().put("guild_id", obj).put("query", "").put("limit", 0)));
    }

    private void tryChunking() {
        if (this.chunkingGuilds.size() >= 50) {
            DataArray subset = DataArray.empty();
            TLongIterator it = this.chunkingGuilds.iterator();
            while (subset.length() < 50) {
                subset.add(it.next());
                it.remove();
            }
            this.sendChunkRequest(subset);
        }
        if (this.incompleteCount > 0 && this.chunkingGuilds.size() >= this.incompleteCount) {
            DataArray array = DataArray.empty();
            this.chunkingGuilds.forEach(guild -> {
                array.add(guild);
                return true;
            });
            this.chunkingGuilds.clear();
            this.sendChunkRequest(array);
        }
    }

    private void startTimeout() {
        this.timeoutHandle = this.getJDA().getGatewayPool().scheduleAtFixedRate(new ChunkTimeout(), 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    private void sendSyncRequest(DataArray arr) {
        log.debug("Sending syncing requests for {} guilds", (Object)arr.length());
        this.getJDA().getClient().chunkOrSyncRequest(DataObject.empty().put("op", 12).put("d", arr));
    }

    private void trySyncing() {
        if (this.syncingGuilds.size() >= 50) {
            DataArray subset = DataArray.empty();
            TLongIterator it = this.syncingGuilds.iterator();
            while (subset.length() < 50) {
                subset.add(it.next());
                it.remove();
            }
            this.sendSyncRequest(subset);
            this.syncingCount -= subset.length();
        }
        if (this.syncingCount > 0 && this.syncingGuilds.size() >= this.syncingCount) {
            DataArray array = DataArray.empty();
            this.syncingGuilds.forEach(guild -> {
                array.add(guild);
                return true;
            });
            this.syncingGuilds.clear();
            this.sendSyncRequest(array);
            this.syncingCount = 0;
        }
    }

    private class ChunkTimeout
    implements Runnable {
        private ChunkTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (GuildSetupController.this.pendingChunks.isEmpty()) {
                return;
            }
            TLongLongMap tLongLongMap = GuildSetupController.this.pendingChunks;
            synchronized (tLongLongMap) {
                TLongLongIterator it = GuildSetupController.this.pendingChunks.iterator();
                LinkedList<DataArray> requests = new LinkedList<DataArray>();
                DataArray arr = DataArray.empty();
                while (it.hasNext()) {
                    it.advance();
                    if (System.currentTimeMillis() <= it.value()) continue;
                    arr.add(it.key());
                    if (arr.length() != 50) continue;
                    requests.add(arr);
                    arr = DataArray.empty();
                }
                if (arr.length() > 0) {
                    requests.add(arr);
                }
                requests.forEach(GuildSetupController.this::sendChunkRequest);
            }
        }
    }

    @FunctionalInterface
    public static interface StatusListener {
        public void onStatusChange(long var1, Status var3, Status var4);
    }

    public static enum Status {
        INIT,
        SYNCING,
        CHUNKING,
        BUILDING,
        READY,
        UNAVAILABLE,
        REMOVED;

    }
}

