/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.Formattable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageActivity;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.exceptions.HttpException;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.FunctionalCallback;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.collections4.Bag;

public interface Message
extends ISnowflake,
Formattable {
    public static final int MAX_FILE_SIZE = 0x800000;
    public static final int MAX_FILE_SIZE_NITRO = 0x3200000;
    public static final int MAX_FILE_AMOUNT = 10;
    public static final int MAX_CONTENT_LENGTH = 2000;
    public static final Pattern INVITE_PATTERN = Pattern.compile("(?:https?://)?discord(?:app\\.com/invite|\\.gg)/([a-z0-9-]+)", 2);

    @Nonnull
    public List<User> getMentionedUsers();

    @Nonnull
    public Bag<User> getMentionedUsersBag();

    @Nonnull
    public List<TextChannel> getMentionedChannels();

    @Nonnull
    public Bag<TextChannel> getMentionedChannelsBag();

    @Nonnull
    public List<Role> getMentionedRoles();

    @Nonnull
    public Bag<Role> getMentionedRolesBag();

    @Nonnull
    public List<Member> getMentionedMembers(@Nonnull Guild var1);

    @Nonnull
    public List<Member> getMentionedMembers();

    @Nonnull
    public List<IMentionable> getMentions(MentionType ... var1);

    public boolean isMentioned(@Nonnull IMentionable var1, MentionType ... var2);

    public boolean mentionsEveryone();

    public boolean isEdited();

    @Nullable
    public OffsetDateTime getTimeEdited();

    @Nonnull
    public User getAuthor();

    @Nullable
    public Member getMember();

    @Nonnull
    public String getJumpUrl();

    @Nonnull
    public String getContentDisplay();

    @Nonnull
    public String getContentRaw();

    @Nonnull
    public String getContentStripped();

    @Nonnull
    public List<String> getInvites();

    @Nullable
    public String getNonce();

    public boolean isFromType(@Nonnull ChannelType var1);

    default public boolean isFromGuild() {
        return this.getChannelType().isGuild();
    }

    @Nonnull
    public ChannelType getChannelType();

    public boolean isWebhookMessage();

    @Nonnull
    public MessageChannel getChannel();

    @Nonnull
    public PrivateChannel getPrivateChannel();

    @Nonnull
    public TextChannel getTextChannel();

    @Nullable
    public Category getCategory();

    @Nonnull
    public Guild getGuild();

    @Nonnull
    public List<Attachment> getAttachments();

    @Nonnull
    public List<MessageEmbed> getEmbeds();

    @Nonnull
    public List<Emote> getEmotes();

    @Nonnull
    public Bag<Emote> getEmotesBag();

    @Nonnull
    public List<MessageReaction> getReactions();

    public boolean isTTS();

    @Nullable
    public MessageActivity getActivity();

    @Nonnull
    @CheckReturnValue
    public MessageAction editMessage(@Nonnull CharSequence var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction editMessage(@Nonnull MessageEmbed var1);

    @Nonnull
    @CheckReturnValue
    public MessageAction editMessageFormat(@Nonnull String var1, Object ... var2);

    @Nonnull
    @CheckReturnValue
    public MessageAction editMessage(@Nonnull Message var1);

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    public JDA getJDA();

    public boolean isPinned();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> pin();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> unpin();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> addReaction(@Nonnull Emote var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> addReaction(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> clearReactions();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction(@Nonnull Emote var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction(@Nonnull Emote var1, @Nonnull User var2);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction(@Nonnull String var1, @Nonnull User var2);

    @Nonnull
    @CheckReturnValue
    public ReactionPaginationAction retrieveReactionUsers(@Nonnull Emote var1);

    @Nonnull
    @CheckReturnValue
    public ReactionPaginationAction retrieveReactionUsers(@Nonnull String var1);

    @Nullable
    @CheckReturnValue
    public MessageReaction.ReactionEmote getReactionByUnicode(@Nonnull String var1);

    @Nullable
    @CheckReturnValue
    public MessageReaction.ReactionEmote getReactionById(@Nonnull String var1);

    @Nullable
    @CheckReturnValue
    public MessageReaction.ReactionEmote getReactionById(long var1);

    @Nonnull
    public MessageType getType();

    public static class Attachment
    implements ISnowflake {
        private final long id;
        private final String url;
        private final String proxyUrl;
        private final String fileName;
        private final int size;
        private final int height;
        private final int width;
        private final JDAImpl jda;

        public Attachment(long id, String url, String proxyUrl, String fileName, int size, int height, int width, JDAImpl jda) {
            this.id = id;
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.fileName = fileName;
            this.size = size;
            this.height = height;
            this.width = width;
            this.jda = jda;
        }

        @Nonnull
        public JDA getJDA() {
            return this.jda;
        }

        @Override
        public long getIdLong() {
            return this.id;
        }

        @Nonnull
        public String getUrl() {
            return this.url;
        }

        @Nonnull
        public String getProxyUrl() {
            return this.proxyUrl;
        }

        @Nonnull
        public String getFileName() {
            return this.fileName;
        }

        @Nonnull
        public CompletableFuture<InputStream> retrieveInputStream() {
            CompletableFuture<InputStream> future = new CompletableFuture<InputStream>();
            Request req = this.getRequest();
            OkHttpClient httpClient = this.getJDA().getHttpClient();
            httpClient.newCall(req).enqueue((Callback)FunctionalCallback.onFailure((call, e) -> future.completeExceptionally(new UncheckedIOException((IOException)e))).onSuccess((call, response) -> {
                if (response.isSuccessful()) {
                    InputStream body = IOUtil.getBody(response);
                    if (!future.complete(body)) {
                        IOUtil.silentClose((Closeable)response);
                    }
                } else {
                    future.completeExceptionally(new HttpException(response.code() + ": " + response.message()));
                    IOUtil.silentClose((Closeable)response);
                }
            }).build());
            return future;
        }

        @Nonnull
        public CompletableFuture<File> downloadToFile() {
            return this.downloadToFile(this.getFileName());
        }

        @Nonnull
        public CompletableFuture<File> downloadToFile(String path) {
            Checks.notNull(path, "Path");
            return this.downloadToFile(new File(path));
        }

        @Nonnull
        public CompletableFuture<File> downloadToFile(File file) {
            Checks.notNull(file, "File");
            Checks.check(!file.exists() || file.canWrite(), "Cannot write to file %s", (Object)file.getName());
            return this.retrieveInputStream().thenApplyAsync(stream -> {
                try {
                    File file2;
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int count;
                        byte[] buf = new byte[1024];
                        while ((count = stream.read(buf)) > 0) {
                            out.write(buf, 0, count);
                        }
                        file2 = file;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    out.close();
                    return file2;
                }
                finally {
                    IOUtil.silentClose(stream);
                }
            }, (Executor)this.getJDA().getCallbackPool());
        }

        @Nonnull
        public CompletableFuture<Icon> retrieveAsIcon() {
            if (!this.isImage()) {
                throw new IllegalStateException("Cannot create an Icon out of this attachment. This is not an image.");
            }
            return this.retrieveInputStream().thenApplyAsync(stream -> {
                try {
                    Icon icon = Icon.from(stream);
                    return icon;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    IOUtil.silentClose(stream);
                }
            }, (Executor)this.getJDA().getCallbackPool());
        }

        protected Request getRequest() {
            return new Request.Builder().url(this.getUrl()).addHeader("user-agent", Requester.USER_AGENT).addHeader("accept-encoding", "gzip, deflate").build();
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isImage() {
            return this.height > 0 && this.width > 0;
        }
    }

    public static enum MentionType {
        USER("<@!?(\\d+)>"),
        ROLE("<@&(\\d+)>"),
        CHANNEL("<#(\\d+)>"),
        EMOTE("<a?:([a-zA-Z0-9_]+):([0-9]+)>"),
        HERE("@here"),
        EVERYONE("@everyone");

        private final Pattern pattern;

        private MentionType(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Nonnull
        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

