/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRoleAddEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRoleRemoveEvent;
import net.dv8tion.jda.api.events.guild.member.update.GuildMemberUpdateBoostTimeEvent;
import net.dv8tion.jda.api.events.guild.member.update.GuildMemberUpdateNicknameEvent;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.MemberImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;

public class GuildMemberUpdateHandler
extends SocketHandler {
    public GuildMemberUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        String newNick;
        String oldNick;
        long id = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(id)) {
            return id;
        }
        DataObject userJson = content.getObject("user");
        long userId = userJson.getLong("id");
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(id);
        if (guild == null) {
            EventCache.LOG.debug("Got GuildMember update but JDA currently does not have the Guild cached. Ignoring. {}", (Object)content);
            return null;
        }
        MemberImpl member = (MemberImpl)guild.getMembersView().get(userId);
        if (member == null) {
            long hashId = id ^ userId;
            this.getJDA().getEventCache().cache(EventCache.Type.MEMBER, hashId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Got GuildMember update but Member is not currently present in Guild. HASH_ID: {} JSON: {}", (Object)hashId, (Object)content);
            return null;
        }
        Set<Role> currentRoles = member.getRoleSet();
        List<Role> newRoles = this.toRolesList(guild, content.getArray("roles"));
        if (newRoles == null) {
            return null;
        }
        LinkedList<Role> removedRoles = new LinkedList<Role>();
        block0: for (Role role : currentRoles) {
            Iterator<Role> it = newRoles.iterator();
            while (it.hasNext()) {
                Role r = it.next();
                if (!role.equals(r)) continue;
                it.remove();
                continue block0;
            }
            removedRoles.add(role);
        }
        if (removedRoles.size() > 0) {
            currentRoles.removeAll(removedRoles);
        }
        if (newRoles.size() > 0) {
            currentRoles.addAll(newRoles);
        }
        if (removedRoles.size() > 0) {
            this.getJDA().getEventManager().handle(new GuildMemberRoleRemoveEvent(this.getJDA(), this.responseNumber, member, removedRoles));
        }
        if (newRoles.size() > 0) {
            this.getJDA().getEventManager().handle(new GuildMemberRoleAddEvent(this.getJDA(), this.responseNumber, member, newRoles));
        }
        if (content.hasKey("nick") && !Objects.equals(oldNick = member.getNickname(), newNick = content.getString("nick", null))) {
            member.setNickname(newNick);
            this.getJDA().getEventManager().handle(new GuildMemberUpdateNicknameEvent(this.getJDA(), this.responseNumber, member, oldNick));
        }
        if (content.hasKey("premium_since")) {
            long epoch = 0L;
            if (!content.isNull("premium_since")) {
                TemporalAccessor date = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(content.getString("premium_since"));
                epoch = Instant.from(date).toEpochMilli();
            }
            if (epoch != member.getBoostDateRaw()) {
                OffsetDateTime oldTime = member.getTimeBoosted();
                member.setBoostDate(epoch);
                this.getJDA().getEventManager().handle(new GuildMemberUpdateBoostTimeEvent(this.getJDA(), this.responseNumber, member, oldTime));
            }
        }
        return null;
    }

    private List<Role> toRolesList(GuildImpl guild, DataArray array) {
        LinkedList<Role> roles = new LinkedList<Role>();
        for (int i = 0; i < array.length(); ++i) {
            long id = array.getLong(i);
            Role r = (Role)guild.getRolesView().get(id);
            if (r == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.ROLE, id, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Got GuildMember update but one of the Roles for the Member is not yet cached.");
                return null;
            }
            roles.add(r);
        }
        return roles;
    }
}

