/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.ratelimit;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.api.events.ExceptionEvent;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.RateLimiter;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.ratelimit.IBucket;
import net.dv8tion.jda.internal.utils.UnlockHook;
import okhttp3.Headers;
import okhttp3.Response;

public class BotRateLimiter
extends RateLimiter {
    private static final String RESET_HEADER = "X-RateLimit-Reset";
    private static final String LIMIT_HEADER = "X-RateLimit-Limit";
    private static final String REMAINING_HEADER = "X-RateLimit-Remaining";
    protected volatile Long timeOffset = null;

    public BotRateLimiter(Requester requester) {
        super(requester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getRateLimit(Route.CompiledRoute route) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route);
        synchronized (bucket2) {
            return bucket.getRateLimit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueRequest(Request request) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(request.getRoute());
        synchronized (bucket2) {
            bucket.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long handleResponse(Route.CompiledRoute route, Response response) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route);
        synchronized (bucket2) {
            Headers headers = response.headers();
            int code = response.code();
            if (this.timeOffset == null) {
                this.setTimeOffset(headers);
            }
            if (code == 429) {
                String global = headers.get("X-RateLimit-Global");
                String retry = headers.get("Retry-After");
                if (retry == null || retry.isEmpty()) {
                    try (InputStream in = Requester.getBody(response);){
                        DataObject limitObj = DataObject.fromJson(in);
                        retry = limitObj.get("retry_after").toString();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                long retryAfter = Long.parseLong(retry);
                if (Boolean.parseBoolean(global)) {
                    log.warn("Encountered global rate-limit! Retry-After: {}", (Object)retryAfter);
                    this.requester.getJDA().getSessionController().setGlobalRatelimit(this.getNow() + retryAfter);
                } else {
                    log.warn("Encountered 429 on route /{}", (Object)bucket.getRoute());
                    this.updateBucket(bucket, headers, retryAfter);
                }
                return retryAfter;
            }
            this.updateBucket(bucket, headers, -1L);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getBucket(Route.CompiledRoute route) {
        String rateLimitRoute = route.getRatelimitRoute();
        Bucket bucket = (Bucket)this.buckets.get(rateLimitRoute);
        if (bucket == null) {
            ConcurrentHashMap concurrentHashMap = this.buckets;
            synchronized (concurrentHashMap) {
                bucket = (Bucket)this.buckets.get(rateLimitRoute);
                if (bucket == null) {
                    Route baseRoute = route.getBaseRoute();
                    bucket = new Bucket(rateLimitRoute, baseRoute.getRatelimit(), baseRoute.isMissingHeaders());
                    this.buckets.put(rateLimitRoute, bucket);
                }
            }
        }
        return bucket;
    }

    public long getNow() {
        return System.currentTimeMillis() + this.getTimeOffset();
    }

    public long getTimeOffset() {
        return this.timeOffset == null ? 0L : this.timeOffset;
    }

    private void setTimeOffset(Headers headers) {
        String date;
        long time = System.currentTimeMillis();
        if (this.timeOffset == null && (date = headers.get("Date")) != null) {
            OffsetDateTime tDate = OffsetDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
            long lDate = tDate.toInstant().toEpochMilli();
            this.timeOffset = lDate - time;
        }
    }

    private void updateBucket(Bucket bucket, Headers headers, long retryAfter) {
        int headerCount = 0;
        if (retryAfter > 0L) {
            bucket.resetTime = this.getNow() + retryAfter;
            bucket.routeUsageRemaining = 0;
        }
        if (bucket.hasRatelimit()) {
            bucket.resetTime = this.getNow() + (long)bucket.getRatelimit().getResetTime();
            headerCount += 2;
        } else {
            headerCount += this.parseLong(headers.get(RESET_HEADER), bucket, (time, b) -> {
                b.resetTime = time * 1000L;
            });
            headerCount += this.parseInt(headers.get(LIMIT_HEADER), bucket, (limit, b) -> {
                b.routeUsageLimit = limit;
            });
        }
        if (!bucket.missingHeaders && (headerCount += this.parseInt(headers.get(REMAINING_HEADER), bucket, (remaining, b) -> {
            b.routeUsageRemaining = remaining;
        })) < 3) {
            log.debug("Encountered issue with headers when updating a bucket\nRoute: {}\nHeaders: {}", (Object)bucket.getRoute(), (Object)headers);
        }
    }

    private int parseInt(String input, Bucket bucket, IntObjectConsumer<? super Bucket> consumer) {
        try {
            int parsed = Integer.parseInt(input);
            consumer.accept(parsed, bucket);
            return 1;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private int parseLong(String input, Bucket bucket, LongObjectConsumer<? super Bucket> consumer) {
        try {
            long parsed = Long.parseLong(input);
            consumer.accept(parsed, bucket);
            return 1;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static interface IntObjectConsumer<T> {
        public void accept(int var1, T var2);
    }

    private static interface LongObjectConsumer<T> {
        public void accept(long var1, T var3);
    }

    private class Bucket
    implements IBucket,
    Runnable {
        final String route;
        final boolean missingHeaders;
        final Route.RateLimit rateLimit;
        final ConcurrentLinkedQueue<Request> requests = new ConcurrentLinkedQueue();
        final ReentrantLock requestLock = new ReentrantLock();
        volatile boolean processing = false;
        volatile long resetTime = 0L;
        volatile int routeUsageRemaining = 1;
        volatile int routeUsageLimit = 1;

        public Bucket(String route, Route.RateLimit rateLimit, boolean missingHeaders) {
            this.route = route;
            this.rateLimit = rateLimit;
            this.missingHeaders = missingHeaders;
            if (rateLimit != null) {
                this.routeUsageRemaining = rateLimit.getUsageLimit();
                this.routeUsageLimit = rateLimit.getUsageLimit();
            }
        }

        void addToQueue(Request request) {
            this.requests.add(request);
            this.submitForProcessing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitForProcessing() {
            ConcurrentLinkedQueue concurrentLinkedQueue = BotRateLimiter.this.submittedBuckets;
            synchronized (concurrentLinkedQueue) {
                if (!BotRateLimiter.this.submittedBuckets.contains(this)) {
                    Long delay = this.getRateLimit();
                    if (delay == null) {
                        delay = 0L;
                    }
                    if (delay > 0L) {
                        log.debug("Backing off {} milliseconds on route /{}", (Object)delay, (Object)this.getRoute());
                        BotRateLimiter.this.requester.getJDA().getRateLimitPool().schedule(this, (long)delay, TimeUnit.MILLISECONDS);
                    } else {
                        BotRateLimiter.this.requester.getJDA().getRateLimitPool().execute(this);
                    }
                    BotRateLimiter.this.submittedBuckets.add(this);
                }
            }
        }

        Long getRateLimit() {
            long gCooldown = BotRateLimiter.this.requester.getJDA().getSessionController().getGlobalRatelimit();
            if (gCooldown > 0L) {
                long now = BotRateLimiter.this.getNow();
                if (now > gCooldown) {
                    BotRateLimiter.this.requester.getJDA().getSessionController().setGlobalRatelimit(Long.MIN_VALUE);
                } else {
                    return gCooldown - now;
                }
            }
            if (this.routeUsageRemaining <= 0 && BotRateLimiter.this.getNow() > this.resetTime) {
                this.routeUsageRemaining = this.routeUsageLimit;
                this.resetTime = 0L;
            }
            if (this.routeUsageRemaining > 0) {
                return null;
            }
            return this.resetTime - BotRateLimiter.this.getNow();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket oBucket = (Bucket)o;
            return this.route.equals(oBucket.route);
        }

        public int hashCode() {
            return this.route.hashCode();
        }

        private void handleResponse(Iterator<Request> it, Long retryAfter) {
            if (retryAfter == null) {
                it.remove();
                this.processIterator(it);
            } else {
                this.finishProcess();
            }
        }

        private void processIterator(Iterator<Request> it) {
            Request request = null;
            try {
                do {
                    if (it.hasNext()) continue;
                    this.finishProcess();
                    return;
                } while (BotRateLimiter.this.isSkipped(it, request = it.next()));
                CompletableFuture<Long> handle = BotRateLimiter.this.requester.execute(request);
                Request request0 = request;
                handle.whenComplete((retryAfter, error) -> {
                    BotRateLimiter.this.requester.setContext();
                    if (error != null) {
                        log.error("Requester system encountered internal error", error);
                        it.remove();
                        request0.onFailure((Throwable)error);
                        this.processIterator(it);
                    } else {
                        this.handleResponse(it, (Long)retryAfter);
                    }
                });
            }
            catch (Throwable t) {
                log.error("Requester system encountered an internal error", t);
                it.remove();
                if (request != null) {
                    request.onFailure(t);
                }
                this.finishProcess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishProcess() {
            this.requestLock.lock();
            try (UnlockHook hook = new UnlockHook(this.requestLock);){
                this.processing = false;
            }
            ConcurrentLinkedQueue concurrentLinkedQueue = BotRateLimiter.this.submittedBuckets;
            synchronized (concurrentLinkedQueue) {
                BotRateLimiter.this.submittedBuckets.remove(this);
                if (!this.requests.isEmpty()) {
                    try {
                        this.submitForProcessing();
                    }
                    catch (RejectedExecutionException e) {
                        log.debug("Caught RejectedExecutionException when re-queuing a ratelimited request. The requester is probably shutdown, thus, this can be ignored.");
                    }
                }
            }
        }

        @Override
        public void run() {
            block9: {
                BotRateLimiter.this.requester.setContext();
                this.requestLock.lock();
                try (UnlockHook hook = new UnlockHook(this.requestLock);){
                    if (this.processing) {
                        return;
                    }
                    this.processing = true;
                    Iterator<Request> it = this.requests.iterator();
                    this.processIterator(it);
                }
                catch (Throwable err) {
                    log.error("Requester system encountered an internal error from beyond the synchronized execution blocks. NOT GOOD!", err);
                    if (!(err instanceof Error)) break block9;
                    JDAImpl api = BotRateLimiter.this.requester.getJDA();
                    api.handleEvent(new ExceptionEvent(api, err, true));
                }
            }
        }

        @Override
        public Route.RateLimit getRatelimit() {
            return this.rateLimit;
        }

        @Override
        public String getRoute() {
            return this.route;
        }

        @Override
        public Queue<Request> getRequests() {
            return this.requests;
        }
    }
}

