/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import gnu.trove.TDecorators;
import gnu.trove.list.TLongList;
import gnu.trove.list.linked.TLongLinkedList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.set.TLongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.events.channel.category.update.CategoryUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.category.update.CategoryUpdatePermissionsEvent;
import net.dv8tion.jda.api.events.channel.category.update.CategoryUpdatePositionEvent;
import net.dv8tion.jda.api.events.channel.store.update.StoreChannelUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.store.update.StoreChannelUpdatePermissionsEvent;
import net.dv8tion.jda.api.events.channel.store.update.StoreChannelUpdatePositionEvent;
import net.dv8tion.jda.api.events.channel.text.update.TextChannelUpdateNSFWEvent;
import net.dv8tion.jda.api.events.channel.text.update.TextChannelUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.text.update.TextChannelUpdateParentEvent;
import net.dv8tion.jda.api.events.channel.text.update.TextChannelUpdatePermissionsEvent;
import net.dv8tion.jda.api.events.channel.text.update.TextChannelUpdatePositionEvent;
import net.dv8tion.jda.api.events.channel.text.update.TextChannelUpdateSlowmodeEvent;
import net.dv8tion.jda.api.events.channel.text.update.TextChannelUpdateTopicEvent;
import net.dv8tion.jda.api.events.channel.voice.update.VoiceChannelUpdateBitrateEvent;
import net.dv8tion.jda.api.events.channel.voice.update.VoiceChannelUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.voice.update.VoiceChannelUpdateParentEvent;
import net.dv8tion.jda.api.events.channel.voice.update.VoiceChannelUpdatePermissionsEvent;
import net.dv8tion.jda.api.events.channel.voice.update.VoiceChannelUpdatePositionEvent;
import net.dv8tion.jda.api.events.channel.voice.update.VoiceChannelUpdateUserLimitEvent;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.CategoryImpl;
import net.dv8tion.jda.internal.entities.PermissionOverrideImpl;
import net.dv8tion.jda.internal.entities.StoreChannelImpl;
import net.dv8tion.jda.internal.entities.TextChannelImpl;
import net.dv8tion.jda.internal.entities.VoiceChannelImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class ChannelUpdateHandler
extends SocketHandler {
    public ChannelUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if (type == ChannelType.GROUP) {
            WebSocketClient.LOG.warn("Ignoring CHANNEL_UPDATE for a group which we don't support");
            return null;
        }
        ArrayList<IPermissionHolder> changed = new ArrayList<IPermissionHolder>();
        ArrayList<IPermissionHolder> contained = new ArrayList<IPermissionHolder>();
        long channelId = content.getLong("id");
        Long parentId = content.isNull("parent_id") ? null : Long.valueOf(content.getLong("parent_id"));
        int position = content.getInt("position");
        String name = content.getString("name");
        boolean nsfw = content.getBoolean("nsfw");
        int slowmode = content.getInt("rate_limit_per_user", 0);
        DataArray permOverwrites = content.getArray("permission_overwrites");
        switch (type) {
            case STORE: {
                StoreChannelImpl storeChannel = (StoreChannelImpl)this.getJDA().getStoreChannelById(channelId);
                if (storeChannel == null) {
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a StoreChannel that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                String oldName = storeChannel.getName();
                int oldPositon = storeChannel.getPositionRaw();
                if (!Objects.equals(oldName, name)) {
                    storeChannel.setName(name);
                    this.getJDA().getEventManager().handle(new StoreChannelUpdateNameEvent(this.getJDA(), this.responseNumber, storeChannel, oldName));
                }
                if (!Objects.equals(oldPositon, position)) {
                    storeChannel.setPosition(position);
                    this.getJDA().getEventManager().handle(new StoreChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, storeChannel, oldPositon));
                }
                this.applyPermissions(storeChannel, content, permOverwrites, contained, changed);
                this.getJDA().getEventManager().handle(new StoreChannelUpdatePermissionsEvent(this.getJDA(), this.responseNumber, storeChannel, changed));
                break;
            }
            case TEXT: {
                String topic = content.getString("topic", null);
                TextChannelImpl textChannel = (TextChannelImpl)this.getJDA().getTextChannelsView().get(channelId);
                if (textChannel == null) {
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a TextChannel that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                Category parent = textChannel.getParent();
                Long oldParent = parent == null ? null : Long.valueOf(parent.getIdLong());
                String oldName = textChannel.getName();
                String oldTopic = textChannel.getTopic();
                int oldPosition = textChannel.getPositionRaw();
                boolean oldNsfw = textChannel.isNSFW();
                int oldSlowmode = textChannel.getSlowmode();
                if (!Objects.equals(oldName, name)) {
                    textChannel.setName(name);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateNameEvent(this.getJDA(), this.responseNumber, textChannel, oldName));
                }
                if (!Objects.equals(oldParent, parentId)) {
                    textChannel.setParent(parentId == null ? 0L : parentId);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateParentEvent(this.getJDA(), this.responseNumber, textChannel, parent));
                }
                if (!Objects.equals(oldTopic, topic)) {
                    textChannel.setTopic(topic);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateTopicEvent(this.getJDA(), this.responseNumber, textChannel, oldTopic));
                }
                if (oldPosition != position) {
                    textChannel.setPosition(position);
                    this.getJDA().getEventManager().handle(new TextChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, textChannel, oldPosition));
                }
                if (oldNsfw != nsfw) {
                    textChannel.setNSFW(nsfw);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateNSFWEvent(this.getJDA(), this.responseNumber, textChannel, oldNsfw));
                }
                if (oldSlowmode != slowmode) {
                    textChannel.setSlowmode(slowmode);
                    this.getJDA().getEventManager().handle(new TextChannelUpdateSlowmodeEvent(this.getJDA(), this.responseNumber, textChannel, oldSlowmode));
                }
                this.applyPermissions(textChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.getJDA().getEventManager().handle(new TextChannelUpdatePermissionsEvent(this.getJDA(), this.responseNumber, textChannel, changed));
                break;
            }
            case VOICE: {
                VoiceChannelImpl voiceChannel = (VoiceChannelImpl)this.getJDA().getVoiceChannelsView().get(channelId);
                int userLimit = content.getInt("user_limit");
                int bitrate = content.getInt("bitrate");
                if (voiceChannel == null) {
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a VoiceChannel that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                Category parent = voiceChannel.getParent();
                Long oldParent = parent == null ? null : Long.valueOf(parent.getIdLong());
                String oldName = voiceChannel.getName();
                int oldPosition = voiceChannel.getPositionRaw();
                int oldLimit = voiceChannel.getUserLimit();
                int oldBitrate = voiceChannel.getBitrate();
                if (!Objects.equals(oldName, name)) {
                    voiceChannel.setName(name);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateNameEvent(this.getJDA(), this.responseNumber, voiceChannel, oldName));
                }
                if (!Objects.equals(oldParent, parentId)) {
                    voiceChannel.setParent(parentId == null ? 0L : parentId);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateParentEvent(this.getJDA(), this.responseNumber, voiceChannel, parent));
                }
                if (oldPosition != position) {
                    voiceChannel.setPosition(position);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, voiceChannel, oldPosition));
                }
                if (oldLimit != userLimit) {
                    voiceChannel.setUserLimit(userLimit);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateUserLimitEvent(this.getJDA(), this.responseNumber, voiceChannel, oldLimit));
                }
                if (oldBitrate != bitrate) {
                    voiceChannel.setBitrate(bitrate);
                    this.getJDA().getEventManager().handle(new VoiceChannelUpdateBitrateEvent(this.getJDA(), this.responseNumber, voiceChannel, oldBitrate));
                }
                this.applyPermissions(voiceChannel, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.getJDA().getEventManager().handle(new VoiceChannelUpdatePermissionsEvent(this.getJDA(), this.responseNumber, voiceChannel, changed));
                break;
            }
            case CATEGORY: {
                CategoryImpl category = (CategoryImpl)this.getJDA().getCategoryById(channelId);
                if (category == null) {
                    this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a Category that does not exist. JSON: {}", (Object)content);
                    return null;
                }
                String oldName = category.getName();
                int oldPosition = category.getPositionRaw();
                if (!Objects.equals(oldName, name)) {
                    category.setName(name);
                    this.getJDA().getEventManager().handle(new CategoryUpdateNameEvent(this.getJDA(), this.responseNumber, category, oldName));
                }
                if (!Objects.equals(oldPosition, position)) {
                    category.setPosition(position);
                    this.getJDA().getEventManager().handle(new CategoryUpdatePositionEvent(this.getJDA(), this.responseNumber, category, oldPosition));
                }
                this.applyPermissions(category, content, permOverwrites, contained, changed);
                if (changed.isEmpty()) break;
                this.getJDA().getEventManager().handle(new CategoryUpdatePermissionsEvent(this.getJDA(), this.responseNumber, category, changed));
                break;
            }
            default: {
                WebSocketClient.LOG.debug("CHANNEL_UPDATE provided an unrecognized channel type JSON: {}", (Object)content);
            }
        }
        return null;
    }

    private void applyPermissions(AbstractChannelImpl<?, ?> channel, DataObject content, DataArray permOverwrites, List<IPermissionHolder> contained, List<IPermissionHolder> changed) {
        for (int i = 0; i < permOverwrites.length(); ++i) {
            this.handlePermissionOverride(permOverwrites.getObject(i), channel, content, changed, contained);
        }
        TLongLinkedList toRemove = new TLongLinkedList();
        TLongObjectMap<PermissionOverride> overridesMap = channel.getOverrideMap();
        TDecorators.wrap((TLongSet)overridesMap.keySet()).stream().map(id -> this.mapPermissionHolder((long)id, channel.getGuild())).filter(Objects::nonNull).filter(permHolder -> !contained.contains(permHolder)).forEach(arg_0 -> ChannelUpdateHandler.lambda$applyPermissions$2(changed, (TLongList)toRemove, arg_0));
        toRemove.forEach(id -> {
            overridesMap.remove(id);
            return true;
        });
    }

    private IPermissionHolder mapPermissionHolder(long id, Guild guild) {
        Role holder = guild.getRoleById(id);
        return holder == null ? guild.getMemberById(id) : holder;
    }

    private void handlePermissionOverride(DataObject override, AbstractChannelImpl<?, ?> channel, DataObject content, List<IPermissionHolder> changedPermHolders, List<IPermissionHolder> containedPermHolders) {
        PermissionOverrideImpl permOverride;
        IPermissionHolder permHolder;
        long id = override.getLong("id");
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        switch (override.getString("type")) {
            case "role": {
                permHolder = channel.getGuild().getRoleById(id);
                if (permHolder != null) break;
                this.getJDA().getEventCache().cache(EventCache.Type.ROLE, id, this.responseNumber, this.allContent, (a, b) -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for a Role that doesn't exist! RoleId: {} JSON: {}", (Object)id, (Object)content);
                return;
            }
            case "member": {
                permHolder = channel.getGuild().getMemberById(id);
                if (permHolder != null) break;
                this.getJDA().getEventCache().cache(EventCache.Type.USER, id, this.responseNumber, this.allContent, (a, b) -> this.handlePermissionOverride(override, channel, content, changedPermHolders, containedPermHolders));
                EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for Member that doesn't exist in this Guild! MemberId: {} JSON: {}", (Object)id, (Object)content);
                return;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized PermissionOverride type. JSON: " + content);
            }
        }
        if ((permOverride = (PermissionOverrideImpl)channel.getOverrideMap().get(id)) == null) {
            this.getJDA().getEntityBuilder().createPermissionOverride(override, channel);
            changedPermHolders.add(permHolder);
        } else if (permOverride.getAllowedRaw() != allow || permOverride.getDeniedRaw() != deny) {
            permOverride.setAllow(allow);
            permOverride.setDeny(deny);
            changedPermHolders.add(permHolder);
        }
        containedPermHolders.add(permHolder);
    }

    private static /* synthetic */ void lambda$applyPermissions$2(List changed, TLongList toRemove, IPermissionHolder permHolder) {
        changed.add(permHolder);
        toRemove.add(permHolder.getIdLong());
    }
}

