/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import javax.annotation.Nonnull;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.IOUtil;

public class Icon {
    protected final String encoding;

    protected Icon(@Nonnull String base64Encoding) {
        this.encoding = "data:image/jpeg;base64," + base64Encoding;
    }

    @Nonnull
    public String getEncoding() {
        return this.encoding;
    }

    @Nonnull
    public static Icon from(@Nonnull File file) throws IOException {
        Checks.notNull(file, "Provided File");
        Checks.check(file.exists(), "Provided file does not exist!");
        return Icon.from(IOUtil.readFully(file));
    }

    @Nonnull
    public static Icon from(@Nonnull InputStream stream) throws IOException {
        Checks.notNull(stream, "InputStream");
        return Icon.from(IOUtil.readFully(stream));
    }

    @Nonnull
    public static Icon from(@Nonnull byte[] data) {
        Checks.notNull(data, "Provided byte[]");
        try {
            return new Icon(new String(Base64.getEncoder().encode(data), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

