/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.internal.entities.DataMessage;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.MessageActionImpl;
import net.dv8tion.jda.internal.utils.Checks;

public class MessageBuilder
implements Appendable {
    protected final StringBuilder builder = new StringBuilder();
    protected boolean isTTS = false;
    protected String nonce;
    protected MessageEmbed embed;

    public MessageBuilder() {
    }

    public MessageBuilder(@Nullable CharSequence content) {
        if (content != null) {
            this.builder.append(content);
        }
    }

    public MessageBuilder(@Nullable Message message) {
        if (message != null) {
            this.isTTS = message.isTTS();
            this.builder.append(message.getContentRaw());
            List<MessageEmbed> embeds = message.getEmbeds();
            if (embeds != null && !embeds.isEmpty()) {
                this.embed = embeds.get(0);
            }
        }
    }

    public MessageBuilder(@Nullable MessageBuilder builder) {
        if (builder != null) {
            this.isTTS = builder.isTTS;
            this.builder.append((CharSequence)builder.builder);
            this.nonce = builder.nonce;
            this.embed = builder.embed;
        }
    }

    public MessageBuilder(@Nullable EmbedBuilder builder) {
        if (builder != null) {
            this.embed = builder.build();
        }
    }

    public MessageBuilder(@Nullable MessageEmbed embed) {
        this.embed = embed;
    }

    @Nonnull
    public MessageBuilder setTTS(boolean tts) {
        this.isTTS = tts;
        return this;
    }

    @Nonnull
    public MessageBuilder setEmbed(@Nullable MessageEmbed embed) {
        this.embed = embed;
        return this;
    }

    @Nonnull
    public MessageBuilder setNonce(@Nullable String nonce) {
        this.nonce = nonce;
        return this;
    }

    @Nonnull
    public MessageBuilder setContent(@Nullable String content) {
        if (content == null) {
            this.builder.setLength(0);
        } else {
            Checks.check(content.length() <= 2000, "Content length may not exceed %d!", (Object)2000);
            int newLength = Math.max(this.builder.length(), content.length());
            this.builder.replace(0, newLength, content);
        }
        return this;
    }

    @Override
    @Nonnull
    public MessageBuilder append(@Nullable CharSequence text) {
        this.builder.append(text);
        return this;
    }

    @Override
    @Nonnull
    public MessageBuilder append(@Nullable CharSequence text, int start, int end) {
        this.builder.append(text, start, end);
        return this;
    }

    @Override
    @Nonnull
    public MessageBuilder append(char c) {
        this.builder.append(c);
        return this;
    }

    @Nonnull
    public MessageBuilder append(@Nullable Object object) {
        return this.append(String.valueOf(object));
    }

    @Nonnull
    public MessageBuilder append(@Nonnull IMentionable mention) {
        Checks.notNull(mention, "Mentionable");
        this.builder.append(mention.getAsMention());
        return this;
    }

    @Nonnull
    public MessageBuilder append(@Nullable CharSequence text, Formatting ... format) {
        boolean blockPresent = false;
        for (Formatting formatting : format) {
            if (formatting == Formatting.BLOCK) {
                blockPresent = true;
                continue;
            }
            this.builder.append(formatting.getTag());
        }
        if (blockPresent) {
            this.builder.append(Formatting.BLOCK.getTag());
        }
        this.builder.append(text);
        if (blockPresent) {
            this.builder.append(Formatting.BLOCK.getTag());
        }
        for (int i = format.length - 1; i >= 0; --i) {
            if (format[i] == Formatting.BLOCK) continue;
            this.builder.append(format[i].getTag());
        }
        return this;
    }

    @Nonnull
    public MessageBuilder appendFormat(@Nonnull String format, Object ... args) {
        Checks.notEmpty(format, "Format String");
        this.append(String.format(format, args));
        return this;
    }

    @Nonnull
    public MessageBuilder appendCodeLine(@Nullable CharSequence text) {
        this.append(text, Formatting.BLOCK);
        return this;
    }

    @Nonnull
    public MessageBuilder appendCodeBlock(@Nullable CharSequence text, @Nullable CharSequence language) {
        this.builder.append("```").append(language).append('\n').append(text).append("\n```");
        return this;
    }

    public int length() {
        return this.builder.length();
    }

    public boolean isEmpty() {
        return this.builder.length() == 0 && this.embed == null;
    }

    @Nonnull
    public MessageBuilder replace(@Nonnull String target, @Nonnull String replacement) {
        int index = this.builder.indexOf(target);
        while (index != -1) {
            this.builder.replace(index, index + target.length(), replacement);
            index = this.builder.indexOf(target, index + replacement.length());
        }
        return this;
    }

    @Nonnull
    public MessageBuilder replaceFirst(@Nonnull String target, @Nonnull String replacement) {
        int index = this.builder.indexOf(target);
        if (index != -1) {
            this.builder.replace(index, index + target.length(), replacement);
        }
        return this;
    }

    @Nonnull
    public MessageBuilder replaceLast(@Nonnull String target, @Nonnull String replacement) {
        int index = this.builder.lastIndexOf(target);
        if (index != -1) {
            this.builder.replace(index, index + target.length(), replacement);
        }
        return this;
    }

    @Nonnull
    public MessageBuilder stripMentions(@Nonnull JDA jda) {
        return this.stripMentions(jda, (Guild)null, Message.MentionType.values());
    }

    @Nonnull
    public MessageBuilder stripMentions(@Nonnull Guild guild) {
        return this.stripMentions(guild.getJDA(), guild, Message.MentionType.values());
    }

    @Nonnull
    public MessageBuilder stripMentions(@Nonnull Guild guild, Message.MentionType ... types) {
        return this.stripMentions(guild.getJDA(), guild, types);
    }

    @Nonnull
    public MessageBuilder stripMentions(@Nonnull JDA jda, Message.MentionType ... types) {
        return this.stripMentions(jda, (Guild)null, types);
    }

    @Nonnull
    private MessageBuilder stripMentions(JDA jda, Guild guild, Message.MentionType ... types) {
        if (types == null) {
            return this;
        }
        String string = null;
        block7: for (Message.MentionType mention : types) {
            if (mention == null) continue;
            switch (mention) {
                case EVERYONE: {
                    this.replace("@everyone", "@\u0435veryone");
                    continue block7;
                }
                case HERE: {
                    this.replace("@here", "@h\u0435re");
                    continue block7;
                }
                case CHANNEL: {
                    if (string == null) {
                        string = this.builder.toString();
                    }
                    Matcher matcher = Message.MentionType.CHANNEL.getPattern().matcher(string);
                    while (matcher.find()) {
                        TextChannel channel = jda.getTextChannelById(matcher.group(1));
                        if (channel == null) continue;
                        this.replace(matcher.group(), "#" + channel.getName());
                    }
                    continue block7;
                }
                case ROLE: {
                    if (string == null) {
                        string = this.builder.toString();
                    }
                    Matcher matcher = Message.MentionType.ROLE.getPattern().matcher(string);
                    block9: while (matcher.find()) {
                        for (Guild g : jda.getGuilds()) {
                            Role role = g.getRoleById(matcher.group(1));
                            if (role == null) continue;
                            this.replace(matcher.group(), "@" + role.getName());
                            continue block9;
                        }
                    }
                    continue block7;
                }
                case USER: {
                    if (string == null) {
                        string = this.builder.toString();
                    }
                    Matcher matcher = Message.MentionType.USER.getPattern().matcher(string);
                    while (matcher.find()) {
                        Member member;
                        User user = jda.getUserById(matcher.group(1));
                        if (user == null) continue;
                        String replacement = guild != null && (member = guild.getMember(user)) != null ? member.getEffectiveName() : user.getName();
                        this.replace(matcher.group(), "@" + replacement);
                    }
                    continue block7;
                }
            }
        }
        return this;
    }

    @Nonnull
    public StringBuilder getStringBuilder() {
        return this.builder;
    }

    @Nonnull
    public MessageBuilder clear() {
        this.builder.setLength(0);
        this.embed = null;
        this.isTTS = false;
        return this;
    }

    public int indexOf(@Nonnull CharSequence target, int fromIndex, int endIndex) {
        int targetCount;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + fromIndex);
        }
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + endIndex);
        }
        if (fromIndex > this.length()) {
            throw new IndexOutOfBoundsException("fromIndex > length()");
        }
        if (fromIndex > endIndex) {
            throw new IndexOutOfBoundsException("fromIndex > endIndex");
        }
        if (endIndex >= this.builder.length()) {
            endIndex = this.builder.length() - 1;
        }
        if ((targetCount = target.length()) == 0) {
            return fromIndex;
        }
        char strFirstChar = target.charAt(0);
        int max = endIndex + targetCount - 1;
        block0: for (int i = fromIndex; i <= max; ++i) {
            if (this.builder.charAt(i) != strFirstChar) continue;
            for (int j = 1; j < targetCount; ++j) {
                if (this.builder.charAt(i + j) != target.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOf(@Nonnull CharSequence target, int fromIndex, int endIndex) {
        int targetCount;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + fromIndex);
        }
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + endIndex);
        }
        if (fromIndex > this.length()) {
            throw new IndexOutOfBoundsException("fromIndex > length()");
        }
        if (fromIndex > endIndex) {
            throw new IndexOutOfBoundsException("fromIndex > endIndex");
        }
        if (endIndex >= this.builder.length()) {
            endIndex = this.builder.length() - 1;
        }
        if ((targetCount = target.length()) == 0) {
            return endIndex;
        }
        int rightIndex = endIndex - targetCount;
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        int strLastIndex = targetCount - 1;
        char strLastChar = target.charAt(strLastIndex);
        int min = fromIndex + targetCount - 1;
        block0: for (int i = endIndex; i >= min; --i) {
            if (this.builder.charAt(i) != strLastChar) continue;
            int j = strLastIndex - 1;
            int k = 1;
            while (j >= 0) {
                if (this.builder.charAt(i - k) != target.charAt(j)) continue block0;
                --j;
                ++k;
            }
            return i - target.length() + 1;
        }
        return -1;
    }

    @Nonnull
    @CheckReturnValue
    public MessageAction sendTo(@Nonnull MessageChannel channel) {
        Checks.notNull(channel, "Target Channel");
        switch (channel.getType()) {
            case TEXT: {
                TextChannel text = (TextChannel)channel;
                Member self = text.getGuild().getSelfMember();
                if (!self.hasPermission((GuildChannel)text, Permission.MESSAGE_READ)) {
                    throw new InsufficientPermissionException(text, Permission.MESSAGE_READ);
                }
                if (self.hasPermission((GuildChannel)text, Permission.MESSAGE_WRITE)) break;
                throw new InsufficientPermissionException(text, Permission.MESSAGE_WRITE);
            }
            case PRIVATE: {
                PrivateChannel priv = (PrivateChannel)channel;
                if (!priv.getUser().isBot() || channel.getJDA().getAccountType() != AccountType.BOT) break;
                throw new UnsupportedOperationException("Cannot send a private message between bots.");
            }
        }
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(channel.getId());
        MessageActionImpl action = new MessageActionImpl(channel.getJDA(), route, channel, this.builder);
        return action.tts(this.isTTS).embed(this.embed).nonce(this.nonce);
    }

    @Nonnull
    public Message build() {
        String message = this.builder.toString();
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot build a Message with no content. (You never added any content to the message)");
        }
        if (message.length() > 2000) {
            throw new IllegalStateException("Cannot build a Message with more than 2000 characters. Please limit your input.");
        }
        return new DataMessage(this.isTTS, message, this.nonce, this.embed);
    }

    @Nonnull
    public Queue<Message> buildAll(SplitPolicy ... policy) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Cannot build a Message with no content. (You never added any content to the message)");
        }
        LinkedList<Message> messages = new LinkedList<Message>();
        if (this.builder.length() <= 2000) {
            messages.add(this.build());
            return messages;
        }
        if (policy == null || policy.length == 0) {
            policy = new SplitPolicy[]{SplitPolicy.ANYWHERE};
        }
        int currentBeginIndex = 0;
        block0: while (currentBeginIndex < this.builder.length() - 2001) {
            for (int i = 0; i < policy.length; ++i) {
                int currentEndIndex = policy[i].nextMessage(currentBeginIndex, this);
                if (currentEndIndex == -1) continue;
                messages.add(this.build(currentBeginIndex, currentEndIndex));
                currentBeginIndex = currentEndIndex;
                continue block0;
            }
            throw new IllegalStateException("Failed to split the messages");
        }
        if (currentBeginIndex < this.builder.length() - 1) {
            messages.add(this.build(currentBeginIndex, this.builder.length() - 1));
        }
        if (this.embed != null) {
            ((DataMessage)messages.get(messages.size() - 1)).setEmbed(this.embed);
        }
        return messages;
    }

    @Nonnull
    protected DataMessage build(int beginIndex, int endIndex) {
        return new DataMessage(this.isTTS, this.builder.substring(beginIndex, endIndex), null, null);
    }

    public static enum Formatting {
        ITALICS("*"),
        BOLD("**"),
        STRIKETHROUGH("~~"),
        UNDERLINE("__"),
        BLOCK("`");

        private final String tag;

        private Formatting(String tag) {
            this.tag = tag;
        }

        @Nonnull
        private String getTag() {
            return this.tag;
        }
    }

    public static interface SplitPolicy {
        public static final SplitPolicy NEWLINE = new CharSequenceSplitPolicy("\n", true);
        public static final SplitPolicy SPACE = new CharSequenceSplitPolicy(" ", true);
        public static final SplitPolicy ANYWHERE = (i, b) -> Math.min(i + 2000, b.length());

        @Nonnull
        public static SplitPolicy onChars(@Nonnull CharSequence chars, boolean remove) {
            return new CharSequenceSplitPolicy(chars, remove);
        }

        public int nextMessage(int var1, MessageBuilder var2);

        public static class CharSequenceSplitPolicy
        implements SplitPolicy {
            private final boolean remove;
            private final CharSequence chars;

            private CharSequenceSplitPolicy(@Nonnull CharSequence chars, boolean remove) {
                this.chars = chars;
                this.remove = remove;
            }

            @Override
            public int nextMessage(int currentBeginIndex, MessageBuilder builder) {
                int currentEndIndex = builder.lastIndexOf(this.chars, currentBeginIndex, currentBeginIndex + 2000 - (this.remove ? this.chars.length() : 0));
                if (currentEndIndex < 0) {
                    return -1;
                }
                return currentEndIndex + this.chars.length();
            }
        }
    }
}

