/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.requests.Method;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class MessageActionImpl
extends RestActionImpl<Message>
implements MessageAction {
    private static final String CONTENT_TOO_BIG = String.format("A message may not exceed %d characters. Please limit your input!", 2000);
    protected final Map<String, InputStream> files = new HashMap<String, InputStream>();
    protected final Set<InputStream> ownedResources = new HashSet<InputStream>();
    protected final StringBuilder content;
    protected final MessageChannel channel;
    protected MessageEmbed embed = null;
    protected String nonce = null;
    protected boolean tts = false;
    protected boolean override = false;

    public MessageActionImpl(JDA api, Route.CompiledRoute route, MessageChannel channel) {
        super(api, route);
        this.content = new StringBuilder();
        this.channel = channel;
    }

    public MessageActionImpl(JDA api, Route.CompiledRoute route, MessageChannel channel, StringBuilder contentBuilder) {
        super(api, route);
        Checks.check(contentBuilder.length() <= 2000, "Cannot build a Message with more than %d characters. Please limit your input.", (Object)2000);
        this.content = contentBuilder;
        this.channel = channel;
    }

    @Override
    @Nonnull
    public MessageAction setCheck(BooleanSupplier checks) {
        return (MessageAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public MessageAction timeout(long timeout, @Nonnull TimeUnit unit) {
        return (MessageAction)super.timeout(timeout, unit);
    }

    @Override
    @Nonnull
    public MessageAction deadline(long timestamp) {
        return (MessageAction)super.deadline(timestamp);
    }

    @Override
    @Nonnull
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public boolean isEmpty() {
        return Helpers.isBlank(this.content) && (this.embed == null || this.embed.isEmpty() || !this.hasPermission(Permission.MESSAGE_EMBED_LINKS));
    }

    @Override
    public boolean isEdit() {
        return this.finalizeRoute().getMethod() == Method.PATCH;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl apply(Message message) {
        if (message == null || message.getType() != MessageType.DEFAULT) {
            return this;
        }
        List<MessageEmbed> embeds = message.getEmbeds();
        if (embeds != null && !embeds.isEmpty()) {
            this.embed(embeds.get(0));
        }
        this.files.clear();
        return this.content(message.getContentRaw()).tts(message.isTTS());
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl tts(boolean isTTS) {
        this.tts = isTTS;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl reset() {
        return this.content(null).nonce(null).embed(null).tts(false).override(false).clearFiles();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl content(String content) {
        if (content == null || content.isEmpty()) {
            this.content.setLength(0);
        } else if (content.length() <= 2000) {
            this.content.replace(0, this.content.length(), content);
        } else {
            throw new IllegalArgumentException(CONTENT_TOO_BIG);
        }
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl embed(MessageEmbed embed) {
        if (embed != null) {
            Checks.check(embed.isSendable(), "Provided Message contains an empty embed or an embed with a length greater than %d characters, which is the max for bot accounts!", (Object)6000);
        }
        this.embed = embed;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl append(CharSequence csq, int start, int end) {
        if (this.content.length() + end - start > 2000) {
            throw new IllegalArgumentException("A message may not exceed 2000 characters. Please limit your input!");
        }
        this.content.append(csq, start, end);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl append(char c) {
        if (this.content.length() == 2000) {
            throw new IllegalArgumentException("A message may not exceed 2000 characters. Please limit your input!");
        }
        this.content.append(c);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl addFile(@Nonnull InputStream data, @Nonnull String name, AttachmentOption ... options) {
        this.checkEdit();
        Checks.notNull(data, "Data");
        Checks.notBlank(name, "Name");
        Checks.noneNull((Object[])options, "Options");
        this.checkFileAmount();
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        name = this.applyOptions(name, options);
        this.files.put(name, data);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl addFile(@Nonnull File file, @Nonnull String name, AttachmentOption ... options) {
        Checks.notNull(file, "File");
        Checks.noneNull((Object[])options, "Options");
        Checks.check(file.exists() && file.canRead(), "Provided file either does not exist or cannot be read from!");
        long maxSize = this.getMaxFileSize();
        Checks.check(file.length() <= maxSize, "File may not exceed the maximum file length of %d bytes!", (Object)maxSize);
        try {
            FileInputStream data = new FileInputStream(file);
            this.ownedResources.add(data);
            name = this.applyOptions(name, options);
            return this.addFile(data, name, new AttachmentOption[0]);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl clearFiles() {
        this.files.clear();
        this.clearResources();
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl clearFiles(@Nonnull BiConsumer<String, InputStream> finalizer) {
        Checks.notNull(finalizer, "Finalizer");
        Iterator<Map.Entry<String, InputStream>> it = this.files.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, InputStream> entry = it.next();
            finalizer.accept(entry.getKey(), entry.getValue());
            it.remove();
        }
        this.clearResources();
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl clearFiles(@Nonnull Consumer<InputStream> finalizer) {
        Checks.notNull(finalizer, "Finalizer");
        Iterator<InputStream> it = this.files.values().iterator();
        while (it.hasNext()) {
            finalizer.accept(it.next());
            it.remove();
        }
        this.clearResources();
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl override(boolean bool) {
        this.override = this.isEdit() && bool;
        return this;
    }

    private String applyOptions(String name, AttachmentOption[] options) {
        for (AttachmentOption opt : options) {
            if (opt != AttachmentOption.SPOILER) continue;
            name = "SPOILER_" + name;
            break;
        }
        return name;
    }

    private void clearResources() {
        for (InputStream ownedResource : this.ownedResources) {
            try {
                ownedResource.close();
            }
            catch (IOException ex) {
                if (ex.getMessage().toLowerCase().contains("closed")) continue;
                LOG.error("Encountered IOException trying to close owned resource", ex);
            }
        }
        this.ownedResources.clear();
    }

    private long getMaxFileSize() {
        if (this.channel.getType().isGuild()) {
            return ((GuildChannel)((Object)this.channel)).getGuild().getMaxFileSize();
        }
        return this.getJDA().getSelfUser().getAllowedFileSize();
    }

    protected RequestBody asMultipart() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        int index = 0;
        for (Map.Entry<String, InputStream> entry : this.files.entrySet()) {
            RequestBody body = IOUtil.createRequestBody(Requester.MEDIA_TYPE_OCTET, entry.getValue());
            builder.addFormDataPart("file" + index++, entry.getKey(), body);
        }
        if (!this.isEmpty()) {
            builder.addFormDataPart("payload_json", this.getJSON().toString());
        }
        this.files.clear();
        this.ownedResources.clear();
        return builder.build();
    }

    protected RequestBody asJSON() {
        return RequestBody.create(Requester.MEDIA_TYPE_JSON, this.getJSON().toJson());
    }

    protected DataObject getJSON() {
        DataObject obj = DataObject.empty();
        if (this.override) {
            if (this.embed == null) {
                obj.putNull("embed");
            } else {
                obj.put("embed", this.embed);
            }
            if (this.content.length() == 0) {
                obj.putNull("content");
            } else {
                obj.put("content", this.content.toString());
            }
            if (this.nonce == null) {
                obj.putNull("nonce");
            } else {
                obj.put("nonce", this.nonce);
            }
            obj.put("tts", this.tts);
        } else {
            if (this.embed != null) {
                obj.put("embed", this.embed);
            }
            if (this.content.length() > 0) {
                obj.put("content", this.content.toString());
            }
            if (this.nonce != null) {
                obj.put("nonce", this.nonce);
            }
            obj.put("tts", this.tts);
        }
        return obj;
    }

    protected void checkFileAmount() {
        if (this.files.size() >= 10) {
            throw new IllegalStateException("Cannot add more than 10 files!");
        }
    }

    protected void checkEdit() {
        if (this.isEdit()) {
            throw new IllegalStateException("Cannot add files to an existing message! Edit-Message does not support this operation!");
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.hasPermission(perm)) {
            TextChannel channel = (TextChannel)this.channel;
            throw new InsufficientPermissionException(channel, perm);
        }
    }

    protected boolean hasPermission(Permission perm) {
        if (this.channel.getType() != ChannelType.TEXT) {
            return true;
        }
        TextChannel text = (TextChannel)this.channel;
        Member self = text.getGuild().getSelfMember();
        return self.hasPermission((GuildChannel)text, perm);
    }

    @Override
    protected RequestBody finalizeData() {
        if (!this.files.isEmpty()) {
            return this.asMultipart();
        }
        if (!this.isEmpty()) {
            return this.asJSON();
        }
        throw new IllegalStateException("Cannot build a message without content!");
    }

    @Override
    protected void handleSuccess(Response response, Request<Message> request) {
        request.onSuccess(this.api.getEntityBuilder().createMessage(response.getObject(), this.channel, false));
    }

    protected void finalize() {
        if (this.ownedResources.isEmpty()) {
            return;
        }
        LOG.warn("Found unclosed resources in MessageAction instance, closing on finalization step!");
        this.clearResources();
    }
}

