/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class MemberChunkManager {
    private static final long MAX_CHUNK_AGE = 10000L;
    private final WebSocketClient client;
    private final ReentrantLock lock = new ReentrantLock();
    private final TLongObjectMap<ChunkRequest> requests = new TLongObjectHashMap();
    private Future<?> timeoutHandle;

    public MemberChunkManager(WebSocketClient client) {
        this.client = client;
    }

    public static boolean isLastChunk(DataObject chunk) {
        return chunk.getInt("chunk_index") + 1 == chunk.getInt("chunk_count");
    }

    public void clear() {
        MiscUtil.locked(this.lock, () -> this.requests.clear());
    }

    private void init() {
        MiscUtil.locked(this.lock, () -> {
            if (this.timeoutHandle == null) {
                this.timeoutHandle = this.client.getJDA().getGatewayPool().scheduleAtFixedRate(new TimeoutHandler(), 5L, 5L, TimeUnit.SECONDS);
            }
        });
    }

    public void shutdown() {
        if (this.timeoutHandle != null) {
            this.timeoutHandle.cancel(false);
        }
    }

    public CompletableFuture<DataObject> chunkGuild(long guildId, String query, int limit) {
        this.init();
        DataObject request = DataObject.empty().put("guild_id", guildId).put("limit", Math.min(100, Math.max(1, limit))).put("query", query);
        ChunkRequest chunkRequest = new ChunkRequest(request);
        this.makeRequest(chunkRequest);
        return chunkRequest;
    }

    public boolean handleChunk(long guildId, DataObject response) {
        return MiscUtil.locked(this.lock, () -> {
            String nonce = response.getString("nonce", null);
            if (nonce == null || nonce.isEmpty()) {
                return false;
            }
            ChunkRequest request = (ChunkRequest)this.requests.remove(Long.parseLong(nonce));
            if (request == null) {
                return false;
            }
            request.complete(response);
            return true;
        });
    }

    public void cancelRequest(ChunkRequest request) {
        MiscUtil.locked(this.lock, () -> this.requests.remove(request.nonce));
    }

    private void makeRequest(ChunkRequest request) {
        MiscUtil.locked(this.lock, () -> {
            this.requests.put(request.nonce, (Object)request);
            this.sendChunkRequest(request.getRequest());
        });
    }

    private void sendChunkRequest(DataObject request) {
        this.client.sendChunkRequest(request);
    }

    private class TimeoutHandler
    implements Runnable {
        private TimeoutHandler() {
        }

        @Override
        public void run() {
            MiscUtil.locked(MemberChunkManager.this.lock, () -> {
                MemberChunkManager.this.requests.forEachValue(request -> {
                    if (request.getAge() > 10000L) {
                        request.completeExceptionally(new TimeoutException());
                    }
                    return true;
                });
                MemberChunkManager.this.requests.valueCollection().removeIf(CompletableFuture::isDone);
            });
        }
    }

    private class ChunkRequest
    extends CompletableFuture<DataObject> {
        private final DataObject request;
        private final long nonce = System.nanoTime() & 0xFFFFFFFFFFFFFFFEL;
        private long startTime;

        public ChunkRequest(DataObject request) {
            this.request = request.put("nonce", this.getNonce());
        }

        public boolean isNonce(String nonce) {
            return this.nonce == Long.parseLong(nonce);
        }

        public String getNonce() {
            return String.valueOf(this.nonce);
        }

        public long getAge() {
            return this.startTime <= 0L ? 0L : System.currentTimeMillis() - this.startTime;
        }

        public DataObject getRequest() {
            this.startTime = System.currentTimeMillis();
            return this.request;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            MemberChunkManager.this.client.cancelChunkRequest(this.getNonce());
            MemberChunkManager.this.cancelRequest(this);
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

