/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils.concurrent.task;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.utils.concurrent.Task;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.Checks;

public class GatewayTask<T>
implements Task<T> {
    private final Runnable onCancel;
    private final CompletableFuture<T> future;
    private Consumer<? super T> success;
    private Consumer<? super Throwable> failure;

    public GatewayTask(CompletableFuture<T> future, Runnable onCancel) {
        this.future = future;
        this.onCancel = onCancel;
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public Task<T> onError(@Nonnull Consumer<? super Throwable> callback) {
        Checks.notNull(callback, "Callback");
        this.future.exceptionally(error -> {
            callback.accept((Throwable)error);
            return null;
        });
        return this;
    }

    @Override
    public Task<T> onSuccess(@Nonnull Consumer<? super T> callback) {
        Checks.notNull(callback, "Callback");
        this.future.thenAccept((Consumer)callback);
        return this;
    }

    @Override
    public T get() {
        if (WebSocketClient.WS_THREAD.get().booleanValue()) {
            throw new UnsupportedOperationException("Blocking operations are not permitted on the gateway thread");
        }
        return this.future.join();
    }

    @Override
    public void cancel() {
        this.onCancel.run();
    }
}

