/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class MemberChunkManager {
    private final WebSocketClient client;
    private final ReentrantLock lock = new ReentrantLock();
    private final TLongObjectMap<Queue<ChunkRequest>> requests = new TLongObjectHashMap();
    private final TLongSet requestedChunk = new TLongHashSet();

    public MemberChunkManager(WebSocketClient client) {
        this.client = client;
    }

    public void clear() {
        MiscUtil.locked(this.lock, () -> {
            this.requests.clear();
            this.requestedChunk.clear();
        });
    }

    public CompletableFuture<DataObject> chunkGuild(long guildId, String query, int limit) {
        DataObject request = DataObject.empty().put("guild_id", guildId).put("limit", Math.min(100, Math.max(1, limit))).put("query", query);
        ChunkRequest chunkRequest = new ChunkRequest(guildId, request);
        this.makeRequest(guildId, request, chunkRequest);
        return chunkRequest;
    }

    public boolean handleChunk(long guildId, DataObject response) {
        return MiscUtil.locked(this.lock, () -> {
            Queue queue = (Queue)this.requests.get(guildId);
            if (!this.requestedChunk.remove(guildId)) {
                this.processQueue(guildId, queue);
                return false;
            }
            ChunkRequest chunkRequest = (ChunkRequest)queue.remove();
            chunkRequest.complete(response);
            this.processQueue(guildId, queue);
            return true;
        });
    }

    public void cancelRequest(ChunkRequest request) {
        MiscUtil.locked(this.lock, () -> {
            Queue queue = (Queue)this.requests.get(request.guildId);
            if (queue == null || queue.isEmpty()) {
                return;
            }
            boolean removed = queue.removeIf(request::equals);
            if (removed && request.requestStarted) {
                this.requestedChunk.remove(request.guildId);
            }
        });
    }

    private void processQueue(long guildId, Queue<ChunkRequest> queue) {
        while (queue != null && !queue.isEmpty()) {
            ChunkRequest element = queue.peek();
            if (element.isCancelled()) {
                queue.remove();
                continue;
            }
            element.start();
            this.sendChunkRequest(element.request);
            this.requestedChunk.add(guildId);
            return;
        }
        this.requests.remove(guildId);
    }

    private void makeRequest(long guildId, DataObject request, ChunkRequest chunkRequest) {
        MiscUtil.locked(this.lock, () -> {
            LinkedList<ChunkRequest> queue = (LinkedList<ChunkRequest>)this.requests.get(guildId);
            if (queue == null) {
                queue = new LinkedList<ChunkRequest>();
                this.requests.put(guildId, queue);
            }
            queue.add(chunkRequest);
            if (this.requestedChunk.add(guildId)) {
                this.sendChunkRequest(request);
            }
        });
    }

    private void sendChunkRequest(DataObject request) {
        this.client.chunkOrSyncRequest(DataObject.empty().put("op", 8).put("d", request));
    }

    private class ChunkRequest
    extends CompletableFuture<DataObject> {
        private final long guildId;
        private final DataObject request;
        private volatile boolean requestStarted = false;

        public ChunkRequest(long guildId, DataObject request) {
            this.guildId = guildId;
            this.request = request;
        }

        public void start() {
            this.requestStarted = true;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            MemberChunkManager.this.cancelRequest(this);
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

