/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.api.entities.RichPresence;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.utils.Checks;

public interface Activity {
    public boolean isRich();

    @Nullable
    public RichPresence asRichPresence();

    @Nonnull
    public String getName();

    @Nullable
    public String getUrl();

    @Nonnull
    public ActivityType getType();

    @Nullable
    public Timestamps getTimestamps();

    @Nonnull
    public static Activity playing(@Nonnull String name) {
        Checks.notBlank(name, "Name");
        return EntityBuilder.createAcitvity(name, null, ActivityType.DEFAULT);
    }

    @Nonnull
    public static Activity streaming(@Nonnull String name, @Nullable String url) {
        Checks.notEmpty(name, "Provided game name");
        ActivityType type = Activity.isValidStreamingUrl(url) ? ActivityType.STREAMING : ActivityType.DEFAULT;
        return EntityBuilder.createAcitvity(name, url, type);
    }

    @Nonnull
    public static Activity listening(@Nonnull String name) {
        Checks.notBlank(name, "Name");
        return EntityBuilder.createAcitvity(name, null, ActivityType.LISTENING);
    }

    @Nonnull
    @Incubating
    public static Activity watching(@Nonnull String name) {
        Checks.notBlank(name, "Name");
        return EntityBuilder.createAcitvity(name, null, ActivityType.WATCHING);
    }

    @Nonnull
    public static Activity of(@Nonnull ActivityType type, @Nonnull String name) {
        return Activity.of(type, name, null);
    }

    @Nonnull
    public static Activity of(@Nonnull ActivityType type, @Nonnull String name, @Nullable String url) {
        Checks.notNull((Object)type, "Type");
        switch (type) {
            case DEFAULT: {
                return Activity.playing(name);
            }
            case STREAMING: {
                return Activity.streaming(name, url);
            }
            case LISTENING: {
                return Activity.listening(name);
            }
            case WATCHING: {
                return Activity.watching(name);
            }
        }
        throw new IllegalArgumentException("ActivityType " + (Object)((Object)type) + " is not supported!");
    }

    public static boolean isValidStreamingUrl(@Nullable String url) {
        return url != null && url.matches("https?://(www\\.)?twitch\\.tv/.+");
    }

    public static class Timestamps {
        protected final long start;
        protected final long end;

        public Timestamps(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        @Nullable
        public Instant getStartTime() {
            return this.start <= 0L ? null : Instant.ofEpochMilli(this.start);
        }

        public long getEnd() {
            return this.end;
        }

        @Nullable
        public Instant getEndTime() {
            return this.end <= 0L ? null : Instant.ofEpochMilli(this.end);
        }

        public long getRemainingTime(TemporalUnit unit) {
            Checks.notNull(unit, "TemporalUnit");
            Instant end = this.getEndTime();
            return end != null ? Instant.now().until(end, unit) : -1L;
        }

        public long getElapsedTime(TemporalUnit unit) {
            Checks.notNull(unit, "TemporalUnit");
            Instant start = this.getStartTime();
            return start != null ? start.until(Instant.now(), unit) : -1L;
        }

        public String toString() {
            return String.format("RichPresenceTimestamp(%d-%d)", this.start, this.end);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Timestamps)) {
                return false;
            }
            Timestamps t = (Timestamps)obj;
            return this.start == t.start && this.end == t.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }

    public static enum ActivityType {
        DEFAULT(0),
        STREAMING(1),
        LISTENING(2),
        WATCHING(3);

        private final int key;

        private ActivityType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        @Nonnull
        public static ActivityType fromKey(int key) {
            switch (key) {
                default: {
                    return DEFAULT;
                }
                case 1: {
                    return STREAMING;
                }
                case 2: {
                    return LISTENING;
                }
                case 3: 
            }
            return WATCHING;
        }
    }
}

