/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.ratelimit.IBucket;
import net.dv8tion.jda.internal.utils.JDALogger;
import okhttp3.Response;
import org.slf4j.Logger;

public abstract class RateLimiter {
    protected static final Logger log = JDALogger.getLog(RateLimiter.class);
    protected final Requester requester;
    protected volatile boolean isShutdown = false;
    protected volatile boolean isStopped = false;
    protected final ConcurrentHashMap<String, IBucket> buckets = new ConcurrentHashMap();
    protected final ConcurrentLinkedQueue<IBucket> submittedBuckets = new ConcurrentLinkedQueue();

    protected RateLimiter(Requester requester) {
        this.requester = requester;
    }

    protected boolean isSkipped(Iterator<Request> it, Request request) {
        try {
            if (request.isCanceled() || !request.runChecks()) {
                this.cancel(it, request, new CancellationException("RestAction has been cancelled"));
                return true;
            }
        }
        catch (Throwable exception) {
            this.cancel(it, request, exception);
            return true;
        }
        return false;
    }

    private void cancel(Iterator<Request> it, Request request, Throwable exception) {
        request.onFailure(exception);
        it.remove();
    }

    public abstract Long getRateLimit(Route.CompiledRoute var1);

    protected abstract void queueRequest(Request var1);

    protected abstract Long handleResponse(Route.CompiledRoute var1, Response var2);

    public boolean isRateLimited(Route.CompiledRoute route) {
        return this.getRateLimit(route) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getRouteBuckets() {
        ConcurrentHashMap<String, IBucket> concurrentHashMap = this.buckets;
        synchronized (concurrentHashMap) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.buckets.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getQueuedRouteBuckets() {
        ConcurrentLinkedQueue<IBucket> concurrentLinkedQueue = this.submittedBuckets;
        synchronized (concurrentLinkedQueue) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.submittedBuckets));
        }
    }

    public void init() {
    }

    protected void stop() {
        this.isStopped = true;
    }

    protected void shutdown() {
        this.stop();
        this.isShutdown = true;
    }
}

