/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.PermissionOverrideAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.PermissionOverrideActionImpl;
import net.dv8tion.jda.internal.utils.cache.SnowflakeReference;

public class PermissionOverrideImpl
implements PermissionOverride {
    private final long id;
    private final SnowflakeReference<GuildChannel> channel;
    private final ChannelType channelType;
    private final boolean role;
    private final JDAImpl api;
    protected final ReentrantLock mngLock = new ReentrantLock();
    protected volatile PermissionOverrideAction manager;
    private long allow;
    private long deny;

    public PermissionOverrideImpl(GuildChannel channel, IPermissionHolder permissionHolder) {
        this.role = permissionHolder instanceof Role;
        this.channelType = channel.getType();
        this.api = (JDAImpl)channel.getJDA();
        this.channel = new SnowflakeReference<GuildChannel>(channel, channelId -> this.api.getGuildChannelById(this.channelType, channelId));
        this.id = permissionHolder.getIdLong();
    }

    @Override
    public long getAllowedRaw() {
        return this.allow;
    }

    @Override
    public long getInheritRaw() {
        return (this.allow | this.deny) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getDeniedRaw() {
        return this.deny;
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getAllowed() {
        return Permission.getPermissions(this.allow);
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getInherit() {
        return Permission.getPermissions(this.getInheritRaw());
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getDenied() {
        return Permission.getPermissions(this.deny);
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public IPermissionHolder getPermissionHolder() {
        return this.role ? this.getRole() : this.getMember();
    }

    @Override
    public Member getMember() {
        return this.getGuild().getMemberById(this.id);
    }

    @Override
    public Role getRole() {
        return this.getGuild().getRoleById(this.id);
    }

    @Override
    @Nonnull
    public GuildChannel getChannel() {
        return this.channel.resolve();
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.getChannel().getGuild();
    }

    @Override
    public boolean isMemberOverride() {
        return !this.role;
    }

    @Override
    public boolean isRoleOverride() {
        return this.role;
    }

    @Override
    @Nonnull
    public PermissionOverrideAction getManager() {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(this.getChannel(), Permission.MANAGE_PERMISSIONS);
        }
        PermissionOverrideAction mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new PermissionOverrideActionImpl(this).setOverride(false);
                }
                return this.manager;
            });
        }
        return mng.reset();
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(this.getChannel(), Permission.MANAGE_PERMISSIONS);
        }
        Route.CompiledRoute route = Route.Channels.DELETE_PERM_OVERRIDE.compile(this.channel.getId(), this.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public PermissionOverrideImpl setAllow(long allow) {
        this.allow = allow;
        return this;
    }

    public PermissionOverrideImpl setDeny(long deny) {
        this.deny = deny;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PermissionOverrideImpl)) {
            return false;
        }
        PermissionOverrideImpl oPerm = (PermissionOverrideImpl)o;
        return this.id == oPerm.id && this.channel.getIdLong() == oPerm.channel.getIdLong();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.channel.getIdLong());
    }

    public String toString() {
        return "PermOver:(" + (this.isMemberOverride() ? "M" : "R") + ")(" + this.channel.getId() + " | " + this.getId() + ")";
    }
}

