/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.audit.ActionType;
import net.dv8tion.jda.api.audit.AuditLogChange;
import net.dv8tion.jda.api.audit.AuditLogEntry;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.ApplicationTeam;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.ClientType;
import net.dv8tion.jda.api.entities.EmbedType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageActivity;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.RichPresence;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.entities.StoreChannel;
import net.dv8tion.jda.api.entities.TeamMember;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.entities.WebhookType;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRoleAddEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRoleRemoveEvent;
import net.dv8tion.jda.api.events.guild.member.update.GuildMemberUpdateBoostTimeEvent;
import net.dv8tion.jda.api.events.guild.member.update.GuildMemberUpdateNicknameEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateAvatarEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateDiscriminatorEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateFlagsEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateNameEvent;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.ActivityImpl;
import net.dv8tion.jda.internal.entities.ApplicationInfoImpl;
import net.dv8tion.jda.internal.entities.ApplicationTeamImpl;
import net.dv8tion.jda.internal.entities.CategoryImpl;
import net.dv8tion.jda.internal.entities.EmoteImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.GuildVoiceStateImpl;
import net.dv8tion.jda.internal.entities.InviteImpl;
import net.dv8tion.jda.internal.entities.MemberImpl;
import net.dv8tion.jda.internal.entities.PermissionOverrideImpl;
import net.dv8tion.jda.internal.entities.PrivateChannelImpl;
import net.dv8tion.jda.internal.entities.ReceivedMessage;
import net.dv8tion.jda.internal.entities.RichPresenceImpl;
import net.dv8tion.jda.internal.entities.RoleImpl;
import net.dv8tion.jda.internal.entities.SelfUserImpl;
import net.dv8tion.jda.internal.entities.StoreChannelImpl;
import net.dv8tion.jda.internal.entities.SystemMessage;
import net.dv8tion.jda.internal.entities.TeamMemberImpl;
import net.dv8tion.jda.internal.entities.TextChannelImpl;
import net.dv8tion.jda.internal.entities.UserImpl;
import net.dv8tion.jda.internal.entities.VoiceChannelImpl;
import net.dv8tion.jda.internal.entities.WebhookImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.utils.JDALogger;
import net.dv8tion.jda.internal.utils.UnlockHook;
import net.dv8tion.jda.internal.utils.cache.MemberCacheViewImpl;
import net.dv8tion.jda.internal.utils.cache.SnowflakeCacheViewImpl;
import net.dv8tion.jda.internal.utils.cache.SortedSnowflakeCacheViewImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.slf4j.Logger;

public class EntityBuilder {
    public static final Logger LOG = JDALogger.getLog(EntityBuilder.class);
    public static final String MISSING_CHANNEL = "MISSING_CHANNEL";
    public static final String MISSING_USER = "MISSING_USER";
    public static final String UNKNOWN_MESSAGE_TYPE = "UNKNOWN_MESSAGE_TYPE";
    private static final Set<String> richGameFields;
    protected final JDAImpl api;

    public EntityBuilder(JDA api) {
        this.api = (JDAImpl)api;
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public SelfUser createSelfUser(DataObject self) {
        SelfUserImpl selfUser = (SelfUserImpl)(this.getJDA().hasSelfUser() ? this.getJDA().getSelfUser() : null);
        if (selfUser == null) {
            long id = self.getLong("id");
            selfUser = new SelfUserImpl(id, this.getJDA());
            this.getJDA().setSelfUser(selfUser);
        }
        SnowflakeCacheViewImpl<User> userView = this.getJDA().getUsersView();
        try (UnlockHook hook = userView.writeLock();){
            if (userView.getElementById(selfUser.getIdLong()) == null) {
                userView.getMap().put(selfUser.getIdLong(), selfUser);
            }
        }
        selfUser.setVerified(self.getBoolean("verified")).setMfaEnabled(self.getBoolean("mfa_enabled")).setName(self.getString("username")).setDiscriminator(self.getString("discriminator")).setAvatarId(self.getString("avatar", null)).setBot(self.getBoolean("bot"));
        return selfUser;
    }

    public static Activity createActivity(String name, String url, Activity.ActivityType type) {
        return new ActivityImpl(name, url, type);
    }

    private void createGuildEmotePass(GuildImpl guildObj, DataArray array) {
        if (!this.getJDA().isCacheFlagSet(CacheFlag.EMOTE)) {
            return;
        }
        SnowflakeCacheViewImpl<Emote> emoteView = guildObj.getEmotesView();
        try (UnlockHook hook = emoteView.writeLock();){
            TLongObjectMap emoteMap = emoteView.getMap();
            for (int i = 0; i < array.length(); ++i) {
                DataObject object = array.getObject(i);
                if (object.isNull("id")) {
                    LOG.error("Received GUILD_CREATE with an emoji with a null ID. JSON: {}", (Object)object);
                    continue;
                }
                long emoteId = object.getLong("id");
                emoteMap.put(emoteId, this.createEmote(guildObj, object, false));
            }
        }
    }

    public TLongObjectMap<DataObject> convertToUserMap(ToLongFunction<DataObject> getId, DataArray array) {
        TLongObjectHashMap<DataObject> map = new TLongObjectHashMap<DataObject>();
        for (int i = 0; i < array.length(); ++i) {
            DataObject obj = array.getObject(i);
            long userId = getId.applyAsLong(obj);
            map.put(userId, obj);
        }
        return map;
    }

    public GuildImpl createGuild(long guildId, DataObject guildJson, TLongObjectMap<DataObject> members, int memberCount) {
        GuildImpl guildObj = new GuildImpl(this.getJDA(), guildId);
        String name = guildJson.getString("name", "");
        String iconId = guildJson.getString("icon", null);
        String splashId = guildJson.getString("splash", null);
        String region = guildJson.getString("region", null);
        String description = guildJson.getString("description", null);
        String vanityCode = guildJson.getString("vanity_url_code", null);
        String bannerId = guildJson.getString("banner", null);
        DataArray roleArray = guildJson.getArray("roles");
        DataArray channelArray = guildJson.getArray("channels");
        DataArray emotesArray = guildJson.getArray("emojis");
        DataArray voiceStateArray = guildJson.getArray("voice_states");
        Optional<DataArray> featuresArray = guildJson.optArray("features");
        Optional<DataArray> presencesArray = guildJson.optArray("presences");
        long ownerId = guildJson.getUnsignedLong("owner_id", 0L);
        long afkChannelId = guildJson.getUnsignedLong("afk_channel_id", 0L);
        long systemChannelId = guildJson.getUnsignedLong("system_channel_id", 0L);
        int boostCount = guildJson.getInt("premium_subscription_count", 0);
        int boostTier = guildJson.getInt("premium_tier", 0);
        int maxMembers = guildJson.getInt("max_members", 0);
        int maxPresences = guildJson.getInt("max_presences", 5000);
        int mfaLevel = guildJson.getInt("mfa_level", 0);
        int afkTimeout = guildJson.getInt("afk_timeout", 0);
        int verificationLevel = guildJson.getInt("verification_level", 0);
        int notificationLevel = guildJson.getInt("default_message_notifications", 0);
        int explicitContentLevel = guildJson.getInt("explicit_content_filter", 0);
        guildObj.setAvailable(true).setName(name).setIconId(iconId).setSplashId(splashId).setRegion(region).setDescription(description).setBannerId(bannerId).setVanityCode(vanityCode).setMaxMembers(maxMembers).setMaxPresences(maxPresences).setOwnerId(ownerId).setAfkTimeout(Guild.Timeout.fromKey(afkTimeout)).setVerificationLevel(Guild.VerificationLevel.fromKey(verificationLevel)).setDefaultNotificationLevel(Guild.NotificationLevel.fromKey(notificationLevel)).setExplicitContentLevel(Guild.ExplicitContentLevel.fromKey(explicitContentLevel)).setRequiredMFALevel(Guild.MFALevel.fromKey(mfaLevel)).setBoostCount(boostCount).setBoostTier(boostTier).setMemberCount(memberCount);
        SnowflakeCacheViewImpl<Guild> guildView = this.getJDA().getGuildsView();
        try (UnlockHook hook = guildView.writeLock();){
            guildView.getMap().put(guildId, guildObj);
        }
        guildObj.setFeatures(featuresArray.map(it -> StreamSupport.stream(it.spliterator(), false).map(String::valueOf).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        SortedSnowflakeCacheViewImpl<Role> roleView = guildObj.getRolesView();
        try (UnlockHook hook = roleView.writeLock();){
            TLongObjectMap map = roleView.getMap();
            for (int i = 0; i < roleArray.length(); ++i) {
                DataObject obj = roleArray.getObject(i);
                Role role = this.createRole(guildObj, obj, guildId);
                map.put(role.getIdLong(), role);
                if (role.getIdLong() != guildObj.getIdLong()) continue;
                guildObj.setPublicRole(role);
            }
        }
        for (int i = 0; i < channelArray.length(); ++i) {
            DataObject channelJson = channelArray.getObject(i);
            this.createGuildChannel(guildObj, channelJson);
        }
        TLongObjectMap<DataObject> voiceStates = this.convertToUserMap(o -> o.getUnsignedLong("user_id", 0L), voiceStateArray);
        TLongObjectMap presences = presencesArray.map(o1 -> this.convertToUserMap(o2 -> o2.getObject("user").getUnsignedLong("id"), (DataArray)o1)).orElseGet(TLongObjectHashMap::new);
        try (UnlockHook h1 = guildObj.getMembersView().writeLock();
             UnlockHook h2 = this.getJDA().getUsersView().writeLock();){
            for (DataObject memberJson : members.valueCollection()) {
                long userId = memberJson.getObject("user").getUnsignedLong("id");
                DataObject voiceState = voiceStates.get(userId);
                DataObject presence = (DataObject)presences.get(userId);
                this.updateMemberCache(this.createMember(guildObj, memberJson, voiceState, presence));
            }
        }
        if (guildObj.getOwner() == null) {
            LOG.debug("Finished setup for guild with a null owner. GuildId: {} OwnerId: {}", (Object)guildId, (Object)guildJson.opt("owner_id").orElse(null));
        }
        this.createGuildEmotePass(guildObj, emotesArray);
        guildObj.setAfkChannel(guildObj.getVoiceChannelById(afkChannelId)).setSystemChannel(guildObj.getTextChannelById(systemChannelId));
        return guildObj;
    }

    private void createGuildChannel(GuildImpl guildObj, DataObject channelData) {
        ChannelType channelType = ChannelType.fromId(channelData.getInt("type"));
        switch (channelType) {
            case TEXT: {
                this.createTextChannel(guildObj, channelData, guildObj.getIdLong());
                break;
            }
            case VOICE: {
                this.createVoiceChannel(guildObj, channelData, guildObj.getIdLong());
                break;
            }
            case CATEGORY: {
                this.createCategory(guildObj, channelData, guildObj.getIdLong());
                break;
            }
            case STORE: {
                this.createStoreChannel(guildObj, channelData, guildObj.getIdLong());
                break;
            }
            default: {
                LOG.debug("Cannot create channel for type " + channelData.getInt("type"));
            }
        }
    }

    public UserImpl createFakeUser(DataObject user) {
        return this.createUser(user, true);
    }

    public UserImpl createUser(DataObject user) {
        return this.createUser(user, false);
    }

    private UserImpl createUser(DataObject user, boolean fake) {
        UserImpl userObj;
        boolean newUser = false;
        long id = user.getLong("id");
        SnowflakeCacheViewImpl<User> userView = this.getJDA().getUsersView();
        try (UnlockHook hook = userView.readLock();){
            userObj = (UserImpl)userView.getElementById(id);
            if (userObj == null && (userObj = (UserImpl)this.getJDA().getFakeUserMap().get(id)) == null) {
                userObj = new UserImpl(id, this.getJDA()).setFake(fake);
                newUser = true;
            }
        }
        if (newUser || userObj.isFake()) {
            userObj.setName(user.getString("username")).setDiscriminator(user.get("discriminator").toString()).setAvatarId(user.getString("avatar", null)).setBot(user.getBoolean("bot")).setFlags(user.getInt("public_flags", 0));
        } else if (!userObj.isFake()) {
            this.updateUser(userObj, user);
        }
        return userObj;
    }

    public void updateUser(UserImpl userObj, DataObject user) {
        String oldName = userObj.getName();
        String newName = user.getString("username");
        String oldDiscriminator = userObj.getDiscriminator();
        String newDiscriminator = user.get("discriminator").toString();
        String oldAvatar = userObj.getAvatarId();
        String newAvatar = user.getString("avatar", null);
        int oldFlags = userObj.getFlagsRaw();
        int newFlags = user.getInt("public_flags", 0);
        JDAImpl jda = this.getJDA();
        long responseNumber = jda.getResponseTotal();
        if (!oldName.equals(newName)) {
            userObj.setName(newName);
            jda.handleEvent(new UserUpdateNameEvent(jda, responseNumber, userObj, oldName));
        }
        if (!oldDiscriminator.equals(newDiscriminator)) {
            userObj.setDiscriminator(newDiscriminator);
            jda.handleEvent(new UserUpdateDiscriminatorEvent(jda, responseNumber, userObj, oldDiscriminator));
        }
        if (!Objects.equals(oldAvatar, newAvatar)) {
            userObj.setAvatarId(newAvatar);
            jda.handleEvent(new UserUpdateAvatarEvent(jda, responseNumber, userObj, oldAvatar));
        }
        if (oldFlags != newFlags) {
            userObj.setFlags(newFlags);
            jda.handleEvent(new UserUpdateFlagsEvent(jda, responseNumber, userObj, User.UserFlag.getFlags(oldFlags)));
        }
    }

    public boolean updateMemberCache(MemberImpl member) {
        return this.updateMemberCache(member, false);
    }

    public boolean updateMemberCache(MemberImpl member, boolean forceRemove) {
        GuildImpl guild = member.getGuild();
        UserImpl user = (UserImpl)member.getUser();
        MemberCacheViewImpl membersView = guild.getMembersView();
        if (forceRemove || !this.getJDA().cacheMember(member)) {
            GuildVoiceStateImpl voiceState;
            if (membersView.remove(member.getIdLong()) == null) {
                return false;
            }
            LOG.trace("Unloading member {}", (Object)member);
            if (!user.isFake() && user.getMutualGuilds().isEmpty()) {
                user.setFake(true);
                this.getJDA().getUsersView().remove(user.getIdLong());
                if (user.hasPrivateChannel()) {
                    PrivateChannel channel = user.getPrivateChannel();
                    this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
                    this.getJDA().getFakePrivateChannelMap().put(channel.getIdLong(), channel);
                    this.getJDA().getPrivateChannelsView().remove(channel.getIdLong());
                }
            }
            if ((voiceState = (GuildVoiceStateImpl)member.getVoiceState()) != null) {
                VoiceChannelImpl connectedChannel = (VoiceChannelImpl)voiceState.getChannel();
                if (connectedChannel != null) {
                    connectedChannel.getConnectedMembersMap().remove(member.getIdLong());
                }
                voiceState.setConnectedChannel(null);
            }
            return false;
        }
        if (guild.getMemberById(member.getIdLong()) != null) {
            return true;
        }
        LOG.trace("Loading member {}", (Object)member);
        if (this.getJDA().getUserById(user.getIdLong()) == null) {
            user.setFake(false);
            SnowflakeCacheViewImpl<User> usersView = this.getJDA().getUsersView();
            SnowflakeCacheViewImpl<PrivateChannel> privateChannels = this.getJDA().getPrivateChannelsView();
            try (UnlockHook hook1 = usersView.writeLock();
                 UnlockHook hook2 = privateChannels.writeLock();){
                usersView.getMap().put(user.getIdLong(), user);
                this.getJDA().getFakeUserMap().remove(user.getIdLong());
                if (user.hasPrivateChannel()) {
                    PrivateChannel channel = user.getPrivateChannel();
                    privateChannels.getMap().put(channel.getIdLong(), channel);
                    this.getJDA().getFakePrivateChannelMap().remove(channel.getIdLong());
                }
            }
        }
        try (UnlockHook hook = membersView.writeLock();){
            membersView.getMap().put(member.getIdLong(), member);
            if (member.isOwner()) {
                guild.setOwner(member);
            }
        }
        long hashId = guild.getIdLong() ^ user.getIdLong();
        this.getJDA().getEventCache().playbackCache(EventCache.Type.USER, member.getIdLong());
        this.getJDA().getEventCache().playbackCache(EventCache.Type.MEMBER, hashId);
        return true;
    }

    public MemberImpl createMember(GuildImpl guild, DataObject memberJson) {
        return this.createMember(guild, memberJson, null, null);
    }

    public MemberImpl createMember(GuildImpl guild, DataObject memberJson, DataObject voiceStateJson, DataObject presence) {
        boolean playbackCache = false;
        UserImpl user = this.createUser(memberJson.getObject("user"));
        DataArray roleArray = memberJson.getArray("roles");
        MemberImpl member = (MemberImpl)guild.getMember(user);
        if (member == null) {
            member = new MemberImpl(guild, user);
            member.setNickname(memberJson.getString("nick", null));
            long epoch = 0L;
            if (!memberJson.isNull("premium_since")) {
                TemporalAccessor date = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(memberJson.getString("premium_since"));
                epoch = Instant.from(date).toEpochMilli();
            }
            member.setBoostDate(epoch);
            Set<Role> roles = member.getRoleSet();
            for (int i = 0; i < roleArray.length(); ++i) {
                long roleId = roleArray.getUnsignedLong(i);
                Role role = guild.getRoleById(roleId);
                if (role == null) continue;
                roles.add(role);
            }
        } else {
            ArrayList<Role> roles = new ArrayList<Role>(roleArray.length());
            for (int i = 0; i < roleArray.length(); ++i) {
                long roleId = roleArray.getUnsignedLong(i);
                Role role = guild.getRoleById(roleId);
                if (role == null) continue;
                roles.add(role);
            }
            this.updateMember(guild, member, memberJson, roles);
        }
        if (!memberJson.isNull("joined_at") && !member.hasTimeJoined()) {
            String joinedAtRaw = memberJson.getString("joined_at");
            TemporalAccessor joinedAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(joinedAtRaw);
            long joinEpoch = Instant.from(joinedAt).toEpochMilli();
            member.setJoinDate(joinEpoch);
        }
        if (voiceStateJson != null && member.getVoiceState() != null) {
            this.createVoiceState(guild, voiceStateJson, user, member);
        }
        if (presence != null) {
            this.createPresence(member, presence);
        }
        return member;
    }

    private void createVoiceState(GuildImpl guild, DataObject voiceStateJson, User user, MemberImpl member) {
        GuildVoiceStateImpl voiceState = (GuildVoiceStateImpl)member.getVoiceState();
        long channelId = voiceStateJson.getLong("channel_id");
        VoiceChannelImpl voiceChannel = (VoiceChannelImpl)guild.getVoiceChannelsView().get(channelId);
        if (voiceChannel != null) {
            voiceChannel.getConnectedMembersMap().put(member.getIdLong(), member);
        } else {
            LOG.error("Received a GuildVoiceState with a channel ID for a non-existent channel! ChannelId: {} GuildId: {} UserId: {}", channelId, guild.getId(), user.getId());
        }
        voiceState.setSelfMuted(voiceStateJson.getBoolean("self_mute")).setSelfDeafened(voiceStateJson.getBoolean("self_deaf")).setGuildMuted(voiceStateJson.getBoolean("mute")).setGuildDeafened(voiceStateJson.getBoolean("deaf")).setSuppressed(voiceStateJson.getBoolean("suppress")).setSessionId(voiceStateJson.getString("session_id")).setStream(voiceStateJson.getBoolean("self_stream")).setConnectedChannel(voiceChannel);
    }

    public void updateMember(GuildImpl guild, MemberImpl member, DataObject content, List<Role> newRoles) {
        String newNick;
        String oldNick;
        long responseNumber = this.getJDA().getResponseTotal();
        if (newRoles != null) {
            this.updateMemberRoles(member, newRoles, responseNumber);
        }
        if (content.hasKey("nick") && !Objects.equals(oldNick = member.getNickname(), newNick = content.getString("nick", null))) {
            member.setNickname(newNick);
            this.getJDA().handleEvent(new GuildMemberUpdateNicknameEvent(this.getJDA(), responseNumber, member, oldNick));
        }
        if (content.hasKey("premium_since")) {
            long epoch = 0L;
            if (!content.isNull("premium_since")) {
                TemporalAccessor date = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(content.getString("premium_since"));
                epoch = Instant.from(date).toEpochMilli();
            }
            if (epoch != member.getBoostDateRaw()) {
                OffsetDateTime oldTime = member.getTimeBoosted();
                member.setBoostDate(epoch);
                this.getJDA().handleEvent(new GuildMemberUpdateBoostTimeEvent(this.getJDA(), responseNumber, member, oldTime));
            }
        }
        if (!content.isNull("joined_at") && !member.hasTimeJoined()) {
            String joinedAtRaw = content.getString("joined_at");
            TemporalAccessor joinedAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(joinedAtRaw);
            long joinEpoch = Instant.from(joinedAt).toEpochMilli();
            member.setJoinDate(joinEpoch);
        }
        if (!member.getUser().isFake()) {
            this.updateUser((UserImpl)member.getUser(), content.getObject("user"));
        }
    }

    private void updateMemberRoles(MemberImpl member, List<Role> newRoles, long responseNumber) {
        Set<Role> currentRoles = member.getRoleSet();
        LinkedList<Role> removedRoles = new LinkedList<Role>();
        block0: for (Role role : currentRoles) {
            Iterator<Role> it = newRoles.iterator();
            while (it.hasNext()) {
                Role r = it.next();
                if (!role.equals(r)) continue;
                it.remove();
                continue block0;
            }
            removedRoles.add(role);
        }
        if (removedRoles.size() > 0) {
            currentRoles.removeAll(removedRoles);
        }
        if (newRoles.size() > 0) {
            currentRoles.addAll(newRoles);
        }
        if (removedRoles.size() > 0) {
            this.getJDA().handleEvent(new GuildMemberRoleRemoveEvent(this.getJDA(), responseNumber, member, removedRoles));
        }
        if (newRoles.size() > 0) {
            this.getJDA().handleEvent(new GuildMemberRoleAddEvent(this.getJDA(), responseNumber, member, newRoles));
        }
    }

    public void createPresence(MemberImpl member, DataObject presenceJson) {
        if (member == null) {
            throw new NullPointerException("Provided member was null!");
        }
        boolean cacheGame = this.getJDA().isCacheFlagSet(CacheFlag.ACTIVITY);
        boolean cacheStatus = this.getJDA().isCacheFlagSet(CacheFlag.CLIENT_STATUS);
        DataArray activityArray = !cacheGame || presenceJson.isNull("activities") ? null : presenceJson.getArray("activities");
        DataObject clientStatusJson = !cacheStatus || presenceJson.isNull("client_status") ? null : presenceJson.getObject("client_status");
        OnlineStatus onlineStatus = OnlineStatus.fromKey(presenceJson.getString("status"));
        ArrayList<Activity> activities = new ArrayList<Activity>();
        boolean parsedActivity = false;
        if (cacheGame && activityArray != null) {
            for (int i = 0; i < activityArray.length(); ++i) {
                try {
                    activities.add(EntityBuilder.createActivity(activityArray.getObject(i)));
                    parsedActivity = true;
                    continue;
                }
                catch (Exception ex) {
                    String userId = member.getUser().getId();
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Encountered exception trying to parse a presence! UserId: {} JSON: {}", userId, activityArray, ex);
                        continue;
                    }
                    LOG.warn("Encountered exception trying to parse a presence! UserId: {} Message: {} Enable debug for details", (Object)userId, (Object)ex.getMessage());
                }
            }
        }
        if (cacheGame && parsedActivity) {
            member.setActivities(activities);
        }
        member.setOnlineStatus(onlineStatus);
        if (clientStatusJson != null) {
            for (String key : clientStatusJson.keys()) {
                ClientType type = ClientType.fromKey(key);
                OnlineStatus status = OnlineStatus.fromKey(clientStatusJson.getString(key));
                member.setOnlineStatus(type, status);
            }
        }
    }

    public static Activity createActivity(DataObject gameJson) {
        Activity.ActivityType type;
        String name = String.valueOf(gameJson.get("name"));
        String url = gameJson.isNull("url") ? null : String.valueOf(gameJson.get("url"));
        try {
            type = gameJson.isNull("type") ? Activity.ActivityType.DEFAULT : Activity.ActivityType.fromKey(Integer.parseInt(gameJson.get("type").toString()));
        }
        catch (NumberFormatException e) {
            type = Activity.ActivityType.DEFAULT;
        }
        Activity.Timestamps timestamps = null;
        if (!gameJson.isNull("timestamps")) {
            DataObject obj = gameJson.getObject("timestamps");
            long start = obj.getLong("start", 0L);
            long end = obj.getLong("end", 0L);
            timestamps = new Activity.Timestamps(start, end);
        }
        Activity.Emoji emoji = null;
        if (!gameJson.isNull("emoji")) {
            DataObject emojiJson = gameJson.getObject("emoji");
            String emojiName = emojiJson.getString("name");
            long emojiId = emojiJson.getUnsignedLong("id", 0L);
            boolean emojiAnimated = emojiJson.getBoolean("animated");
            emoji = new Activity.Emoji(emojiName, emojiId, emojiAnimated);
        }
        if (type == Activity.ActivityType.CUSTOM_STATUS && gameJson.hasKey("state") && name.equalsIgnoreCase("Custom Status")) {
            name = gameJson.getString("state", "");
            gameJson = gameJson.remove("state");
        }
        if (!CollectionUtils.containsAny(gameJson.keys(), richGameFields)) {
            return new ActivityImpl(name, url, type, timestamps, emoji);
        }
        long id = gameJson.getLong("application_id", 0L);
        String sessionId = gameJson.getString("session_id", null);
        String syncId = gameJson.getString("sync_id", null);
        int flags = gameJson.getInt("flags", 0);
        String details = gameJson.isNull("details") ? null : String.valueOf(gameJson.get("details"));
        String state = gameJson.isNull("state") ? null : String.valueOf(gameJson.get("state"));
        RichPresence.Party party = null;
        if (!gameJson.isNull("party")) {
            DataObject obj = gameJson.getObject("party");
            String partyId = obj.isNull("id") ? null : obj.getString("id");
            DataArray sizeArr = obj.isNull("size") ? null : obj.getArray("size");
            long size = 0L;
            long max = 0L;
            if (sizeArr != null && sizeArr.length() > 0) {
                size = sizeArr.getLong(0);
                max = sizeArr.length() < 2 ? 0L : sizeArr.getLong(1);
            }
            party = new RichPresence.Party(partyId, size, max);
        }
        String smallImageKey = null;
        String smallImageText = null;
        String largeImageKey = null;
        String largeImageText = null;
        if (!gameJson.isNull("assets")) {
            DataObject assets = gameJson.getObject("assets");
            if (!assets.isNull("small_image")) {
                smallImageKey = String.valueOf(assets.get("small_image"));
                String string = smallImageText = assets.isNull("small_text") ? null : String.valueOf(assets.get("small_text"));
            }
            if (!assets.isNull("large_image")) {
                largeImageKey = String.valueOf(assets.get("large_image"));
                largeImageText = assets.isNull("large_text") ? null : String.valueOf(assets.get("large_text"));
            }
        }
        return new RichPresenceImpl(type, name, url, id, emoji, party, details, state, timestamps, syncId, sessionId, flags, largeImageKey, largeImageText, smallImageKey, smallImageText);
    }

    public EmoteImpl createEmote(GuildImpl guildObj, DataObject json, boolean fake) {
        DataArray emoteRoles = json.optArray("roles").orElseGet(DataArray::empty);
        long emoteId = json.getLong("id");
        UserImpl user = json.isNull("user") ? null : this.createFakeUser(json.getObject("user"));
        EmoteImpl emoteObj = (EmoteImpl)guildObj.getEmoteById(emoteId);
        if (emoteObj == null) {
            emoteObj = new EmoteImpl(emoteId, guildObj, fake);
        }
        Set<Role> roleSet = emoteObj.getRoleSet();
        roleSet.clear();
        for (int j = 0; j < emoteRoles.length(); ++j) {
            Role role = guildObj.getRoleById(emoteRoles.getString(j));
            if (role == null) continue;
            roleSet.add(role);
        }
        if (user != null) {
            emoteObj.setUser(user);
        }
        return emoteObj.setName(json.getString("name", "")).setAnimated(json.getBoolean("animated")).setManaged(json.getBoolean("managed"));
    }

    public Category createCategory(DataObject json, long guildId) {
        return this.createCategory(null, json, guildId);
    }

    public Category createCategory(GuildImpl guild, DataObject json, long guildId) {
        boolean playbackCache = false;
        long id = json.getLong("id");
        CategoryImpl channel = (CategoryImpl)this.getJDA().getCategoriesView().get(id);
        if (channel == null) {
            if (guild == null) {
                guild = (GuildImpl)this.getJDA().getGuildsView().get(guildId);
            }
            SortedSnowflakeCacheViewImpl<Category> guildCategoryView = guild.getCategoriesView();
            SnowflakeCacheViewImpl<Category> categoryView = this.getJDA().getCategoriesView();
            try (UnlockHook glock = guildCategoryView.writeLock();
                 UnlockHook jlock = categoryView.writeLock();){
                channel = new CategoryImpl(id, guild);
                guildCategoryView.getMap().put(id, channel);
                playbackCache = categoryView.getMap().put(id, channel) == null;
            }
        }
        ((CategoryImpl)channel.setName(json.getString("name"))).setPosition(json.getInt("position"));
        this.createOverridesPass(channel, json.getArray("permission_overwrites"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, id);
        }
        return channel;
    }

    public StoreChannel createStoreChannel(DataObject json, long guildId) {
        return this.createStoreChannel(null, json, guildId);
    }

    public StoreChannel createStoreChannel(GuildImpl guild, DataObject json, long guildId) {
        boolean playbackCache = false;
        long id = json.getLong("id");
        StoreChannelImpl channel = (StoreChannelImpl)this.getJDA().getStoreChannelsView().get(id);
        if (channel == null) {
            if (guild == null) {
                guild = (GuildImpl)this.getJDA().getGuildById(guildId);
            }
            SortedSnowflakeCacheViewImpl<StoreChannel> guildStoreView = guild.getStoreChannelView();
            SnowflakeCacheViewImpl<StoreChannel> storeView = this.getJDA().getStoreChannelsView();
            try (UnlockHook glock = guildStoreView.writeLock();
                 UnlockHook jlock = storeView.writeLock();){
                channel = new StoreChannelImpl(id, guild);
                guildStoreView.getMap().put(id, channel);
                playbackCache = storeView.getMap().put(id, channel) == null;
            }
        }
        ((StoreChannelImpl)((StoreChannelImpl)channel.setParent(json.getLong("parent_id", 0L))).setName(json.getString("name"))).setPosition(json.getInt("position"));
        this.createOverridesPass(channel, json.getArray("permission_overwrites"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, id);
        }
        return channel;
    }

    public TextChannel createTextChannel(DataObject json, long guildId) {
        return this.createTextChannel(null, json, guildId);
    }

    public TextChannel createTextChannel(GuildImpl guildObj, DataObject json, long guildId) {
        boolean playbackCache = false;
        long id = json.getLong("id");
        TextChannelImpl channel = (TextChannelImpl)this.getJDA().getTextChannelsView().get(id);
        if (channel == null) {
            if (guildObj == null) {
                guildObj = (GuildImpl)this.getJDA().getGuildsView().get(guildId);
            }
            SortedSnowflakeCacheViewImpl<TextChannel> guildTextView = guildObj.getTextChannelsView();
            SnowflakeCacheViewImpl<TextChannel> textView = this.getJDA().getTextChannelsView();
            try (UnlockHook glock = guildTextView.writeLock();
                 UnlockHook jlock = textView.writeLock();){
                channel = new TextChannelImpl(id, guildObj);
                guildTextView.getMap().put(id, channel);
                playbackCache = textView.getMap().put(id, channel) == null;
            }
        }
        ((TextChannelImpl)((TextChannelImpl)channel.setParent(json.getLong("parent_id", 0L))).setLastMessageId(json.getLong("last_message_id", 0L)).setName(json.getString("name"))).setTopic(json.getString("topic", null)).setPosition(json.getInt("position")).setNSFW(json.getBoolean("nsfw")).setSlowmode(json.getInt("rate_limit_per_user", 0));
        this.createOverridesPass(channel, json.getArray("permission_overwrites"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, id);
        }
        return channel;
    }

    public VoiceChannel createVoiceChannel(DataObject json, long guildId) {
        return this.createVoiceChannel(null, json, guildId);
    }

    public VoiceChannel createVoiceChannel(GuildImpl guild, DataObject json, long guildId) {
        boolean playbackCache = false;
        long id = json.getLong("id");
        VoiceChannelImpl channel = (VoiceChannelImpl)this.getJDA().getVoiceChannelsView().get(id);
        if (channel == null) {
            if (guild == null) {
                guild = (GuildImpl)this.getJDA().getGuildsView().get(guildId);
            }
            SortedSnowflakeCacheViewImpl<VoiceChannel> guildVoiceView = guild.getVoiceChannelsView();
            SnowflakeCacheViewImpl<VoiceChannel> voiceView = this.getJDA().getVoiceChannelsView();
            try (UnlockHook vlock = guildVoiceView.writeLock();
                 UnlockHook jlock = voiceView.writeLock();){
                channel = new VoiceChannelImpl(id, guild);
                guildVoiceView.getMap().put(id, channel);
                playbackCache = voiceView.getMap().put(id, channel) == null;
            }
        }
        ((VoiceChannelImpl)((VoiceChannelImpl)channel.setParent(json.getLong("parent_id", 0L))).setName(json.getString("name"))).setPosition(json.getInt("position")).setUserLimit(json.getInt("user_limit")).setBitrate(json.getInt("bitrate"));
        this.createOverridesPass(channel, json.getArray("permission_overwrites"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, id);
        }
        return channel;
    }

    public PrivateChannel createPrivateChannel(DataObject json) {
        long channelId = json.getUnsignedLong("id");
        PrivateChannel channel = this.api.getPrivateChannelById(channelId);
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel != null) {
            return channel;
        }
        DataObject recipient = json.hasKey("recipients") ? json.getArray("recipients").getObject(0) : json.getObject("recipient");
        long userId = recipient.getLong("id");
        UserImpl user = (UserImpl)this.getJDA().getUserById(userId);
        if (user == null) {
            user = this.createFakeUser(recipient);
        }
        return this.createPrivateChannel(json, user);
    }

    public PrivateChannel createPrivateChannel(DataObject json, UserImpl user) {
        long channelId = json.getLong("id");
        PrivateChannelImpl priv = new PrivateChannelImpl(channelId, user).setLastMessageId(json.getLong("last_message_id", 0L));
        user.setPrivateChannel(priv);
        if (user.isFake()) {
            this.getJDA().getFakePrivateChannelMap().put(channelId, priv);
            this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
        } else {
            SnowflakeCacheViewImpl<PrivateChannel> privateView = this.getJDA().getPrivateChannelsView();
            try (UnlockHook hook = privateView.writeLock();){
                privateView.getMap().put(channelId, priv);
            }
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, channelId);
        }
        return priv;
    }

    public void createOverridesPass(AbstractChannelImpl<?, ?> channel, DataArray overrides) {
        for (int i = 0; i < overrides.length(); ++i) {
            try {
                this.createPermissionOverride(overrides.getObject(i), channel);
                continue;
            }
            catch (NoSuchElementException e) {
                LOG.debug("{}. Ignoring PermissionOverride.", (Object)e.getMessage());
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("{}. Ignoring PermissionOverride.", (Object)e.getMessage());
            }
        }
    }

    public Role createRole(GuildImpl guild, DataObject roleJson, long guildId) {
        RoleImpl role;
        boolean playbackCache = false;
        long id = roleJson.getLong("id");
        if (guild == null) {
            guild = (GuildImpl)this.getJDA().getGuildsView().get(guildId);
        }
        if ((role = (RoleImpl)guild.getRolesView().get(id)) == null) {
            SortedSnowflakeCacheViewImpl<Role> roleView = guild.getRolesView();
            try (UnlockHook hook = roleView.writeLock();){
                role = new RoleImpl(id, guild);
                playbackCache = roleView.getMap().put(id, role) == null;
            }
        }
        int color = roleJson.getInt("color");
        role.setName(roleJson.getString("name")).setRawPosition(roleJson.getInt("position")).setRawPermissions(roleJson.getLong("permissions")).setManaged(roleJson.getBoolean("managed")).setHoisted(roleJson.getBoolean("hoist")).setColor(color == 0 ? 0x1FFFFFFF : color).setMentionable(roleJson.getBoolean("mentionable"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.ROLE, id);
        }
        return role;
    }

    public Message createMessage(DataObject jsonObject) {
        return this.createMessage(jsonObject, false);
    }

    public Message createMessage(DataObject jsonObject, boolean modifyCache) {
        long channelId = jsonObject.getLong("channel_id");
        MessageChannel chan = this.getJDA().getTextChannelById(channelId);
        if (chan == null) {
            chan = this.getJDA().getPrivateChannelById(channelId);
        }
        if (chan == null) {
            chan = this.getJDA().getFakePrivateChannelMap().get(channelId);
        }
        if (chan == null) {
            throw new IllegalArgumentException(MISSING_CHANNEL);
        }
        return this.createMessage(jsonObject, chan, modifyCache);
    }

    public Message createMessage(DataObject jsonObject, MessageChannel chan, boolean modifyCache) {
        ReceivedMessage message;
        User user;
        long id = jsonObject.getLong("id");
        DataObject author = jsonObject.getObject("author");
        long authorId = author.getLong("id");
        MemberImpl member = null;
        if (chan.getType().isGuild() && !jsonObject.isNull("member")) {
            DataObject memberJson = jsonObject.getObject("member");
            memberJson.put("user", author);
            GuildChannel guildChannel = (GuildChannel)((Object)chan);
            Guild guild = guildChannel.getGuild();
            member = this.createMember((GuildImpl)guild, memberJson);
            if (modifyCache) {
                this.updateMemberCache(member);
            }
        }
        String content = jsonObject.getString("content", "");
        boolean fromWebhook = jsonObject.hasKey("webhook_id");
        boolean pinned = jsonObject.getBoolean("pinned");
        boolean tts = jsonObject.getBoolean("tts");
        boolean mentionsEveryone = jsonObject.getBoolean("mention_everyone");
        OffsetDateTime editTime = jsonObject.isNull("edited_timestamp") ? null : OffsetDateTime.parse(jsonObject.getString("edited_timestamp"));
        String nonce = jsonObject.isNull("nonce") ? null : jsonObject.get("nonce").toString();
        int flags = jsonObject.getInt("flags", 0);
        List<Message.Attachment> attachments = this.map(jsonObject, "attachments", this::createMessageAttachment);
        List<MessageEmbed> embeds = this.map(jsonObject, "embeds", this::createMessageEmbed);
        List<MessageReaction> reactions = this.map(jsonObject, "reactions", obj -> this.createMessageReaction(chan, id, (DataObject)obj));
        MessageActivity activity = null;
        if (!jsonObject.isNull("activity")) {
            activity = EntityBuilder.createMessageActivity(jsonObject);
        }
        switch (chan.getType()) {
            case PRIVATE: {
                if (authorId == this.getJDA().getSelfUser().getIdLong()) {
                    user = this.getJDA().getSelfUser();
                    break;
                }
                user = ((PrivateChannel)chan).getUser();
                break;
            }
            case GROUP: {
                throw new IllegalStateException("Cannot build a message for a group channel, how did this even get here?");
            }
            case TEXT: {
                Guild guild = ((TextChannel)chan).getGuild();
                if (member == null) {
                    member = (MemberImpl)guild.getMemberById(authorId);
                }
                User user2 = user = member != null ? member.getUser() : null;
                if (user != null) break;
                if (fromWebhook || !modifyCache) {
                    user = this.createFakeUser(author);
                    break;
                }
                throw new IllegalArgumentException(MISSING_USER);
            }
            default: {
                throw new IllegalArgumentException("Invalid Channel for creating a Message [" + (Object)((Object)chan.getType()) + ']');
            }
        }
        if (modifyCache && !fromWebhook) {
            this.updateUser((UserImpl)user, author);
        }
        TLongHashSet mentionedRoles = new TLongHashSet();
        TLongHashSet mentionedUsers = new TLongHashSet(this.map(jsonObject, "mentions", o -> o.getLong("id")));
        Optional<DataArray> roleMentionArr = jsonObject.optArray("mention_roles");
        roleMentionArr.ifPresent(arr -> {
            for (int i = 0; i < arr.length(); ++i) {
                mentionedRoles.add(arr.getLong(i));
            }
        });
        MessageType type = MessageType.fromId(jsonObject.getInt("type"));
        switch (type) {
            case DEFAULT: {
                message = new ReceivedMessage(id, chan, type, fromWebhook, mentionsEveryone, mentionedUsers, mentionedRoles, tts, pinned, content, nonce, user, member, activity, editTime, reactions, attachments, embeds, flags);
                break;
            }
            case UNKNOWN: {
                throw new IllegalArgumentException(UNKNOWN_MESSAGE_TYPE);
            }
            default: {
                message = new SystemMessage(id, chan, type, fromWebhook, mentionsEveryone, mentionedUsers, mentionedRoles, tts, pinned, content, nonce, user, member, activity, editTime, reactions, attachments, embeds, flags);
            }
        }
        if (!message.isFromGuild()) {
            return message;
        }
        GuildImpl guild = (GuildImpl)message.getGuild();
        if (guild.isLoaded()) {
            return message;
        }
        ArrayList<User> mentionedUsersList = new ArrayList<User>();
        ArrayList<Member> mentionedMembersList = new ArrayList<Member>();
        DataArray userMentions = jsonObject.getArray("mentions");
        for (int i = 0; i < userMentions.length(); ++i) {
            Member mentionedMember;
            DataObject mentionJson = userMentions.getObject(i);
            if (mentionJson.isNull("member")) {
                UserImpl mentionedUser = this.createFakeUser(mentionJson);
                mentionedUsersList.add(mentionedUser);
                mentionedMember = guild.getMember(mentionedUser);
                if (mentionedMember == null) continue;
                mentionedMembersList.add(mentionedMember);
                continue;
            }
            DataObject memberJson = mentionJson.getObject("member");
            mentionJson.remove("member");
            memberJson.put("user", mentionJson);
            mentionedMember = this.createMember(guild, memberJson);
            mentionedMembersList.add(mentionedMember);
            mentionedUsersList.add(mentionedMember.getUser());
        }
        if (!mentionedUsersList.isEmpty()) {
            message.setMentions(mentionedUsersList, mentionedMembersList);
        }
        return message;
    }

    private static MessageActivity createMessageActivity(DataObject jsonObject) {
        DataObject activityData = jsonObject.getObject("activity");
        MessageActivity.ActivityType activityType = MessageActivity.ActivityType.fromId(activityData.getInt("type"));
        String partyId = activityData.getString("party_id", null);
        MessageActivity.Application application = null;
        if (!jsonObject.isNull("application")) {
            DataObject applicationData = jsonObject.getObject("application");
            String name = applicationData.getString("name");
            String description = applicationData.getString("description", "");
            String iconId = applicationData.getString("icon", null);
            String coverId = applicationData.getString("cover_image", null);
            long applicationId = applicationData.getLong("id");
            application = new MessageActivity.Application(name, description, iconId, coverId, applicationId);
        }
        if (activityType == MessageActivity.ActivityType.UNKNOWN) {
            LOG.debug("Received an unknown ActivityType, Activity: {}", (Object)activityData);
        }
        return new MessageActivity(activityType, partyId, application);
    }

    public MessageReaction createMessageReaction(MessageChannel chan, long id, DataObject obj) {
        MessageReaction.ReactionEmote reactionEmote;
        DataObject emoji = obj.getObject("emoji");
        Long emojiID = emoji.isNull("id") ? null : Long.valueOf(emoji.getLong("id"));
        String name = emoji.getString("name", "");
        boolean animated = emoji.getBoolean("animated");
        int count = obj.getInt("count", -1);
        boolean me = obj.getBoolean("me");
        if (emojiID != null) {
            Emote emote = this.getJDA().getEmoteById(emojiID);
            if (emote == null) {
                emote = new EmoteImpl((long)emojiID, this.getJDA()).setAnimated(animated).setName(name);
            }
            reactionEmote = MessageReaction.ReactionEmote.fromCustom(emote);
        } else {
            reactionEmote = MessageReaction.ReactionEmote.fromUnicode(name, this.getJDA());
        }
        return new MessageReaction(chan, reactionEmote, id, me, count);
    }

    public Message.Attachment createMessageAttachment(DataObject jsonObject) {
        int width = jsonObject.getInt("width", -1);
        int height = jsonObject.getInt("height", -1);
        int size = jsonObject.getInt("size");
        String url = jsonObject.getString("url");
        String proxyUrl = jsonObject.getString("proxy_url");
        String filename = jsonObject.getString("filename");
        long id = jsonObject.getLong("id");
        return new Message.Attachment(id, url, proxyUrl, filename, size, height, width, this.getJDA());
    }

    public MessageEmbed createMessageEmbed(DataObject content) {
        MessageEmbed.ImageInfo image;
        MessageEmbed.Footer footer;
        MessageEmbed.VideoInfo video;
        MessageEmbed.AuthorInfo author;
        MessageEmbed.Provider provider;
        MessageEmbed.Thumbnail thumbnail;
        int color;
        if (content.isNull("type")) {
            throw new IllegalStateException("Encountered embed object with missing/null type field for Json: " + content);
        }
        EmbedType type = EmbedType.fromKey(content.getString("type"));
        String url = content.getString("url", null);
        String title = content.getString("title", null);
        String description = content.getString("description", null);
        OffsetDateTime timestamp = content.isNull("timestamp") ? null : OffsetDateTime.parse(content.getString("timestamp"));
        int n = color = content.isNull("color") ? 0x1FFFFFFF : content.getInt("color");
        if (content.isNull("thumbnail")) {
            thumbnail = null;
        } else {
            DataObject obj2 = content.getObject("thumbnail");
            thumbnail = new MessageEmbed.Thumbnail(obj2.getString("url", null), obj2.getString("proxy_url", null), obj2.getInt("width", -1), obj2.getInt("height", -1));
        }
        if (content.isNull("provider")) {
            provider = null;
        } else {
            DataObject obj3 = content.getObject("provider");
            provider = new MessageEmbed.Provider(obj3.getString("name", null), obj3.getString("url", null));
        }
        if (content.isNull("author")) {
            author = null;
        } else {
            DataObject obj4 = content.getObject("author");
            author = new MessageEmbed.AuthorInfo(obj4.getString("name", null), obj4.getString("url", null), obj4.getString("icon_url", null), obj4.getString("proxy_icon_url", null));
        }
        if (content.isNull("video")) {
            video = null;
        } else {
            DataObject obj5 = content.getObject("video");
            video = new MessageEmbed.VideoInfo(obj5.getString("url", null), obj5.getInt("width", -1), obj5.getInt("height", -1));
        }
        if (content.isNull("footer")) {
            footer = null;
        } else {
            DataObject obj6 = content.getObject("footer");
            footer = new MessageEmbed.Footer(obj6.getString("text", null), obj6.getString("icon_url", null), obj6.getString("proxy_icon_url", null));
        }
        if (content.isNull("image")) {
            image = null;
        } else {
            DataObject obj7 = content.getObject("image");
            image = new MessageEmbed.ImageInfo(obj7.getString("url", null), obj7.getString("proxy_url", null), obj7.getInt("width", -1), obj7.getInt("height", -1));
        }
        List<MessageEmbed.Field> fields = this.map(content, "fields", obj -> new MessageEmbed.Field(obj.getString("name", null), obj.getString("value", null), obj.getBoolean("inline"), false));
        return EntityBuilder.createMessageEmbed(url, title, description, type, timestamp, color, thumbnail, provider, author, video, footer, image, fields);
    }

    public static MessageEmbed createMessageEmbed(String url, String title, String description, EmbedType type, OffsetDateTime timestamp, int color, MessageEmbed.Thumbnail thumbnail, MessageEmbed.Provider siteProvider, MessageEmbed.AuthorInfo author, MessageEmbed.VideoInfo videoInfo, MessageEmbed.Footer footer, MessageEmbed.ImageInfo image, List<MessageEmbed.Field> fields) {
        return new MessageEmbed(url, title, description, type, timestamp, color, thumbnail, siteProvider, author, videoInfo, footer, image, fields);
    }

    @Nullable
    public PermissionOverride createPermissionOverride(DataObject override, AbstractChannelImpl<?, ?> chan) {
        String type = override.getString("type");
        long id = override.getLong("id");
        boolean role = type.equals("role");
        if (role && chan.getGuild().getRoleById(id) == null) {
            throw new NoSuchElementException("Attempted to create a PermissionOverride for a non-existent role! JSON: " + override);
        }
        if (!role && !type.equals("member")) {
            throw new IllegalArgumentException("Provided with an unknown PermissionOverride type! JSON: " + override);
        }
        if (!role && id != this.api.getSelfUser().getIdLong() && !this.api.isCacheFlagSet(CacheFlag.MEMBER_OVERRIDES)) {
            return null;
        }
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        PermissionOverrideImpl permOverride = (PermissionOverrideImpl)chan.getOverrideMap().get(id);
        if (permOverride == null) {
            permOverride = new PermissionOverrideImpl(chan, id, role);
            chan.getOverrideMap().put(id, permOverride);
        }
        return permOverride.setAllow(allow).setDeny(deny);
    }

    public WebhookImpl createWebhook(DataObject object) {
        long id = object.getLong("id");
        long guildId = object.getLong("guild_id");
        long channelId = object.getLong("channel_id");
        String token = object.getString("token", null);
        WebhookType type = WebhookType.fromKey(object.getInt("type", -1));
        TextChannel channel = this.getJDA().getTextChannelById(channelId);
        if (channel == null) {
            throw new NullPointerException(String.format("Tried to create Webhook for an un-cached TextChannel! WebhookId: %s ChannelId: %s GuildId: %s", id, channelId, guildId));
        }
        Object name = !object.isNull("name") ? object.get("name") : null;
        Object avatar = !object.isNull("avatar") ? object.get("avatar") : null;
        DataObject fakeUser = DataObject.empty().put("username", name).put("discriminator", "0000").put("id", id).put("avatar", avatar);
        UserImpl defaultUser = this.createFakeUser(fakeUser);
        Optional<DataObject> ownerJson = object.optObject("user");
        User owner = null;
        if (ownerJson.isPresent()) {
            DataObject json = ownerJson.get();
            long userId = json.getLong("id");
            owner = this.getJDA().getUserById(userId);
            if (owner == null) {
                json.put("id", userId);
                owner = this.createFakeUser(json);
            }
        }
        return new WebhookImpl(channel, id, type).setToken(token).setOwner(owner == null ? null : channel.getGuild().getMember(owner)).setUser(defaultUser);
    }

    public Invite createInvite(DataObject object) {
        OffsetDateTime timeCreated;
        boolean temporary;
        int uses;
        int maxUses;
        int maxAge;
        boolean expanded;
        InviteImpl.GroupImpl group;
        InviteImpl.ChannelImpl channel;
        InviteImpl.GuildImpl guild;
        Invite.InviteType type;
        String code = object.getString("code");
        UserImpl inviter = object.hasKey("inviter") ? this.createFakeUser(object.getObject("inviter")) : null;
        DataObject channelObject = object.getObject("channel");
        ChannelType channelType = ChannelType.fromId(channelObject.getInt("type"));
        if (channelType == ChannelType.GROUP) {
            type = Invite.InviteType.GROUP;
            guild = null;
            channel = null;
            String groupName = channelObject.getString("name", "");
            long groupId = channelObject.getLong("id");
            String groupIconId = channelObject.getString("icon", null);
            List<String> usernames = channelObject.isNull("recipients") ? null : this.map(channelObject, "recipients", json -> json.getString("username"));
            group = new InviteImpl.GroupImpl(groupIconId, groupName, groupId, usernames);
        } else if (channelType.isGuild()) {
            type = Invite.InviteType.GUILD;
            DataObject guildObject = object.getObject("guild");
            String guildIconId = guildObject.getString("icon", null);
            long guildId = guildObject.getLong("id");
            String guildName = guildObject.getString("name");
            String guildSplashId = guildObject.getString("splash", null);
            Guild.VerificationLevel guildVerificationLevel = Guild.VerificationLevel.fromKey(guildObject.getInt("verification_level", -1));
            int presenceCount = object.getInt("approximate_presence_count", -1);
            int memberCount = object.getInt("approximate_member_count", -1);
            Set<String> guildFeatures = guildObject.isNull("features") ? Collections.emptySet() : Collections.unmodifiableSet(StreamSupport.stream(guildObject.getArray("features").spliterator(), false).map(String::valueOf).collect(Collectors.toSet()));
            guild = new InviteImpl.GuildImpl(guildId, guildIconId, guildName, guildSplashId, guildVerificationLevel, presenceCount, memberCount, guildFeatures);
            String channelName = channelObject.getString("name");
            long channelId = channelObject.getLong("id");
            channel = new InviteImpl.ChannelImpl(channelId, channelName, channelType);
            group = null;
        } else {
            type = Invite.InviteType.UNKNOWN;
            guild = null;
            channel = null;
            group = null;
        }
        if (object.hasKey("max_uses")) {
            expanded = true;
            maxAge = object.getInt("max_age");
            maxUses = object.getInt("max_uses");
            uses = object.getInt("uses");
            temporary = object.getBoolean("temporary");
            timeCreated = OffsetDateTime.parse(object.getString("created_at"));
        } else {
            expanded = false;
            maxAge = -1;
            maxUses = -1;
            uses = -1;
            temporary = false;
            timeCreated = null;
        }
        return new InviteImpl(this.getJDA(), code, expanded, inviter, maxAge, maxUses, temporary, timeCreated, uses, channel, guild, group, type);
    }

    public ApplicationInfo createApplicationInfo(DataObject object) {
        String description = object.getString("description");
        boolean doesBotRequireCodeGrant = object.getBoolean("bot_require_code_grant");
        String iconId = object.getString("icon", null);
        long id = object.getLong("id");
        String name = object.getString("name");
        boolean isBotPublic = object.getBoolean("bot_public");
        UserImpl owner = this.createFakeUser(object.getObject("owner"));
        ApplicationTeam team = !object.isNull("team") ? this.createApplicationTeam(object.getObject("team")) : null;
        return new ApplicationInfoImpl(this.getJDA(), description, doesBotRequireCodeGrant, iconId, id, isBotPublic, name, owner, team);
    }

    public ApplicationTeam createApplicationTeam(DataObject object) {
        String iconId = object.getString("icon", null);
        long id = object.getUnsignedLong("id");
        long ownerId = object.getUnsignedLong("owner_user_id", 0L);
        List<TeamMember> members = this.map(object, "members", o -> {
            DataObject userJson = o.getObject("user");
            TeamMember.MembershipState state = TeamMember.MembershipState.fromKey(o.getInt("membership_state"));
            UserImpl user = this.createFakeUser(userJson);
            return new TeamMemberImpl(user, state, id);
        });
        return new ApplicationTeamImpl(iconId, members, id, ownerId);
    }

    public AuditLogEntry createAuditLogEntry(GuildImpl guild, DataObject entryJson, DataObject userJson, DataObject webhookJson) {
        Set<AuditLogChange> changesList;
        long targetId = entryJson.getLong("target_id", 0L);
        long id = entryJson.getLong("id");
        int typeKey = entryJson.getInt("action_type");
        DataArray changes = entryJson.isNull("changes") ? null : entryJson.getArray("changes");
        DataObject options = entryJson.isNull("options") ? null : entryJson.getObject("options");
        String reason = entryJson.getString("reason", null);
        UserImpl user = userJson == null ? null : this.createFakeUser(userJson);
        WebhookImpl webhook = webhookJson == null ? null : this.createWebhook(webhookJson);
        ActionType type = ActionType.from(typeKey);
        if (changes != null) {
            changesList = new HashSet(changes.length());
            for (int i = 0; i < changes.length(); ++i) {
                DataObject object = changes.getObject(i);
                AuditLogChange change = this.createAuditLogChange(object);
                changesList.add(change);
            }
        } else {
            changesList = Collections.emptySet();
        }
        CaseInsensitiveMap<String, AuditLogChange> changeMap = new CaseInsensitiveMap<String, AuditLogChange>(this.changeToMap(changesList));
        CaseInsensitiveMap<String, Object> optionMap = options != null ? new CaseInsensitiveMap<String, Object>(options.toMap()) : null;
        return new AuditLogEntry(type, typeKey, id, targetId, guild, user, webhook, reason, changeMap, optionMap);
    }

    public AuditLogChange createAuditLogChange(DataObject change) {
        String key = change.getString("key");
        Object oldValue = change.isNull("old_value") ? null : change.get("old_value");
        Object newValue = change.isNull("new_value") ? null : change.get("new_value");
        return new AuditLogChange(oldValue, newValue, key);
    }

    private Map<String, AuditLogChange> changeToMap(Set<AuditLogChange> changesList) {
        return changesList.stream().collect(Collectors.toMap(AuditLogChange::getKey, UnaryOperator.identity()));
    }

    private <T> List<T> map(DataObject jsonObject, String key, Function<DataObject, T> convert) {
        if (jsonObject.isNull(key)) {
            return Collections.emptyList();
        }
        DataArray arr = jsonObject.getArray(key);
        ArrayList<T> mappedObjects = new ArrayList<T>(arr.length());
        for (int i = 0; i < arr.length(); ++i) {
            DataObject obj = arr.getObject(i);
            T result = convert.apply(obj);
            if (result == null) continue;
            mappedObjects.add(result);
        }
        return mappedObjects;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("application_id");
        tmp.add("assets");
        tmp.add("details");
        tmp.add("flags");
        tmp.add("party");
        tmp.add("session_id");
        tmp.add("state");
        tmp.add("sync_id");
        richGameFields = Collections.unmodifiableSet(tmp);
    }
}

