/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import net.dv8tion.jda.internal.utils.Checks;

public final class Helpers {
    public static boolean isEmpty(CharSequence seq) {
        return seq == null || seq.length() == 0;
    }

    public static boolean containsWhitespace(CharSequence seq) {
        if (Helpers.isEmpty(seq)) {
            return false;
        }
        for (int i = 0; i < seq.length(); ++i) {
            if (!Character.isWhitespace(seq.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(CharSequence seq) {
        if (Helpers.isEmpty(seq)) {
            return true;
        }
        for (int i = 0; i < seq.length(); ++i) {
            if (Character.isWhitespace(seq.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int countMatches(CharSequence seq, char c) {
        if (Helpers.isEmpty(seq)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String truncate(String input, int maxWidth) {
        if (input == null) {
            return null;
        }
        Checks.notNegative(maxWidth, "maxWidth");
        if (input.length() <= maxWidth) {
            return input;
        }
        if (maxWidth == 0) {
            return "";
        }
        return input.substring(0, maxWidth);
    }

    public static String rightPad(String input, int size) {
        int pads = size - input.length();
        if (pads <= 0) {
            return input;
        }
        StringBuilder out = new StringBuilder(input);
        for (int i = pads; i > 0; --i) {
            out.append(' ');
        }
        return out.toString();
    }

    public static String leftPad(String input, int size) {
        int pads = size - input.length();
        if (pads <= 0) {
            return input;
        }
        StringBuilder out = new StringBuilder();
        for (int i = pads; i > 0; --i) {
            out.append(' ');
        }
        return out.append(input).toString();
    }

    public static boolean isNumeric(String input) {
        if (Helpers.isEmpty(input)) {
            return false;
        }
        for (char c : input.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(Collection<?> first, Collection<?> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null || first.size() != second.size()) {
            return false;
        }
        Iterator<?> itFirst = first.iterator();
        Iterator<?> itSecond = second.iterator();
        while (itFirst.hasNext()) {
            Object elementSecond;
            Object elementFirst = itFirst.next();
            if (Objects.equals(elementFirst, elementSecond = itSecond.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEqualsUnordered(Collection<?> first, Collection<?> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.size() == second.size() && second.containsAll(first);
    }

    public static <T extends Throwable> T appendCause(T throwable, Throwable cause) {
        Object t = throwable;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        t.initCause(cause);
        return throwable;
    }
}

