/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class SharedLinkSettingsRemoveExpirationDetails {
    protected final AccessLevel sharedContentAccessLevel;
    protected final String sharedContentLink;
    protected final Date previousValue;

    public SharedLinkSettingsRemoveExpirationDetails(AccessLevel sharedContentAccessLevel, String sharedContentLink, Date previousValue) {
        if (sharedContentAccessLevel == null) {
            throw new IllegalArgumentException("Required value for 'sharedContentAccessLevel' is null");
        }
        this.sharedContentAccessLevel = sharedContentAccessLevel;
        this.sharedContentLink = sharedContentLink;
        this.previousValue = LangUtil.truncateMillis(previousValue);
    }

    public SharedLinkSettingsRemoveExpirationDetails(AccessLevel sharedContentAccessLevel) {
        this(sharedContentAccessLevel, null, null);
    }

    public AccessLevel getSharedContentAccessLevel() {
        return this.sharedContentAccessLevel;
    }

    public String getSharedContentLink() {
        return this.sharedContentLink;
    }

    public Date getPreviousValue() {
        return this.previousValue;
    }

    public static Builder newBuilder(AccessLevel sharedContentAccessLevel) {
        return new Builder(sharedContentAccessLevel);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedContentAccessLevel, this.sharedContentLink, this.previousValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedLinkSettingsRemoveExpirationDetails other = (SharedLinkSettingsRemoveExpirationDetails)obj;
            return (this.sharedContentAccessLevel == other.sharedContentAccessLevel || this.sharedContentAccessLevel.equals((Object)other.sharedContentAccessLevel)) && (this.sharedContentLink == other.sharedContentLink || this.sharedContentLink != null && this.sharedContentLink.equals(other.sharedContentLink)) && (this.previousValue == other.previousValue || this.previousValue != null && this.previousValue.equals(other.previousValue));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedLinkSettingsRemoveExpirationDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedLinkSettingsRemoveExpirationDetails value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("shared_content_access_level");
            AccessLevel.Serializer.INSTANCE.serialize(value.sharedContentAccessLevel, g2);
            if (value.sharedContentLink != null) {
                g2.writeFieldName("shared_content_link");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.sharedContentLink, g2);
            }
            if (value.previousValue != null) {
                g2.writeFieldName("previous_value");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.previousValue, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public SharedLinkSettingsRemoveExpirationDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_previousValue;
            String f_sharedContentLink;
            AccessLevel f_sharedContentAccessLevel;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_sharedContentAccessLevel = null;
                f_sharedContentLink = null;
                f_previousValue = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("shared_content_access_level".equals(field)) {
                        f_sharedContentAccessLevel = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("shared_content_link".equals(field)) {
                        f_sharedContentLink = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("previous_value".equals(field)) {
                        f_previousValue = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_sharedContentAccessLevel == null) {
                    throw new JsonParseException(p, "Required field \"shared_content_access_level\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedLinkSettingsRemoveExpirationDetails value = new SharedLinkSettingsRemoveExpirationDetails(f_sharedContentAccessLevel, f_sharedContentLink, f_previousValue);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final AccessLevel sharedContentAccessLevel;
        protected String sharedContentLink;
        protected Date previousValue;

        protected Builder(AccessLevel sharedContentAccessLevel) {
            if (sharedContentAccessLevel == null) {
                throw new IllegalArgumentException("Required value for 'sharedContentAccessLevel' is null");
            }
            this.sharedContentAccessLevel = sharedContentAccessLevel;
            this.sharedContentLink = null;
            this.previousValue = null;
        }

        public Builder withSharedContentLink(String sharedContentLink) {
            this.sharedContentLink = sharedContentLink;
            return this;
        }

        public Builder withPreviousValue(Date previousValue) {
            this.previousValue = LangUtil.truncateMillis(previousValue);
            return this;
        }

        public SharedLinkSettingsRemoveExpirationDetails build() {
            return new SharedLinkSettingsRemoveExpirationDetails(this.sharedContentAccessLevel, this.sharedContentLink, this.previousValue);
        }
    }
}

