/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.GroupLogInfo;
import com.dropbox.core.v2.teamlog.UserLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ParticipantLogInfo {
    public static final ParticipantLogInfo OTHER = new ParticipantLogInfo().withTag(Tag.OTHER);
    private Tag _tag;
    private UserLogInfo userValue;
    private GroupLogInfo groupValue;

    private ParticipantLogInfo() {
    }

    private ParticipantLogInfo withTag(Tag _tag) {
        ParticipantLogInfo result = new ParticipantLogInfo();
        result._tag = _tag;
        return result;
    }

    private ParticipantLogInfo withTagAndUser(Tag _tag, UserLogInfo userValue) {
        ParticipantLogInfo result = new ParticipantLogInfo();
        result._tag = _tag;
        result.userValue = userValue;
        return result;
    }

    private ParticipantLogInfo withTagAndGroup(Tag _tag, GroupLogInfo groupValue) {
        ParticipantLogInfo result = new ParticipantLogInfo();
        result._tag = _tag;
        result.groupValue = groupValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUser() {
        return this._tag == Tag.USER;
    }

    public static ParticipantLogInfo user(UserLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ParticipantLogInfo().withTagAndUser(Tag.USER, value);
    }

    public UserLogInfo getUserValue() {
        if (this._tag != Tag.USER) {
            throw new IllegalStateException("Invalid tag: required Tag.USER, but was Tag." + this._tag.name());
        }
        return this.userValue;
    }

    public boolean isGroup() {
        return this._tag == Tag.GROUP;
    }

    public static ParticipantLogInfo group(GroupLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ParticipantLogInfo().withTagAndGroup(Tag.GROUP, value);
    }

    public GroupLogInfo getGroupValue() {
        if (this._tag != Tag.GROUP) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP, but was Tag." + this._tag.name());
        }
        return this.groupValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.userValue, this.groupValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ParticipantLogInfo) {
            ParticipantLogInfo other = (ParticipantLogInfo)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case USER: {
                    return this.userValue == other.userValue || this.userValue.equals(other.userValue);
                }
                case GROUP: {
                    return this.groupValue == other.groupValue || this.groupValue.equals(other.groupValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ParticipantLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ParticipantLogInfo value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case USER: {
                    g2.writeStartObject();
                    this.writeTag("user", g2);
                    g2.writeFieldName("user");
                    UserLogInfo.Serializer.INSTANCE.serialize(value.userValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case GROUP: {
                    g2.writeStartObject();
                    this.writeTag("group", g2);
                    GroupLogInfo.Serializer.INSTANCE.serialize(value.groupValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public ParticipantLogInfo deserialize(JsonParser p) throws IOException, JsonParseException {
            ParticipantLogInfo value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("user".equals(tag)) {
                UserLogInfo fieldValue = null;
                Serializer.expectField("user", p);
                fieldValue = (UserLogInfo)UserLogInfo.Serializer.INSTANCE.deserialize(p);
                value = ParticipantLogInfo.user(fieldValue);
            } else if ("group".equals(tag)) {
                GroupLogInfo fieldValue = null;
                fieldValue = GroupLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = ParticipantLogInfo.group(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        USER,
        GROUP,
        OTHER;

    }
}

