/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.OrganizationDetails;
import com.dropbox.core.v2.teamlog.TeamDetails;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class FedExtraDetails {
    public static final FedExtraDetails OTHER = new FedExtraDetails().withTag(Tag.OTHER);
    private Tag _tag;
    private TeamDetails teamValue;
    private OrganizationDetails organizationValue;

    private FedExtraDetails() {
    }

    private FedExtraDetails withTag(Tag _tag) {
        FedExtraDetails result = new FedExtraDetails();
        result._tag = _tag;
        return result;
    }

    private FedExtraDetails withTagAndTeam(Tag _tag, TeamDetails teamValue) {
        FedExtraDetails result = new FedExtraDetails();
        result._tag = _tag;
        result.teamValue = teamValue;
        return result;
    }

    private FedExtraDetails withTagAndOrganization(Tag _tag, OrganizationDetails organizationValue) {
        FedExtraDetails result = new FedExtraDetails();
        result._tag = _tag;
        result.organizationValue = organizationValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTeam() {
        return this._tag == Tag.TEAM;
    }

    public static FedExtraDetails team(TeamDetails value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FedExtraDetails().withTagAndTeam(Tag.TEAM, value);
    }

    public TeamDetails getTeamValue() {
        if (this._tag != Tag.TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM, but was Tag." + this._tag.name());
        }
        return this.teamValue;
    }

    public boolean isOrganization() {
        return this._tag == Tag.ORGANIZATION;
    }

    public static FedExtraDetails organization(OrganizationDetails value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FedExtraDetails().withTagAndOrganization(Tag.ORGANIZATION, value);
    }

    public OrganizationDetails getOrganizationValue() {
        if (this._tag != Tag.ORGANIZATION) {
            throw new IllegalStateException("Invalid tag: required Tag.ORGANIZATION, but was Tag." + this._tag.name());
        }
        return this.organizationValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.teamValue, this.organizationValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FedExtraDetails) {
            FedExtraDetails other = (FedExtraDetails)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEAM: {
                    return this.teamValue == other.teamValue || this.teamValue.equals(other.teamValue);
                }
                case ORGANIZATION: {
                    return this.organizationValue == other.organizationValue || this.organizationValue.equals(other.organizationValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<FedExtraDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FedExtraDetails value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEAM: {
                    g2.writeStartObject();
                    this.writeTag("team", g2);
                    TeamDetails.Serializer.INSTANCE.serialize(value.teamValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case ORGANIZATION: {
                    g2.writeStartObject();
                    this.writeTag("organization", g2);
                    OrganizationDetails.Serializer.INSTANCE.serialize(value.organizationValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public FedExtraDetails deserialize(JsonParser p) throws IOException, JsonParseException {
            FedExtraDetails value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("team".equals(tag)) {
                TeamDetails fieldValue = null;
                fieldValue = TeamDetails.Serializer.INSTANCE.deserialize(p, true);
                value = FedExtraDetails.team(fieldValue);
            } else if ("organization".equals(tag)) {
                OrganizationDetails fieldValue = null;
                fieldValue = OrganizationDetails.Serializer.INSTANCE.deserialize(p, true);
                value = FedExtraDetails.organization(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEAM,
        ORGANIZATION,
        OTHER;

    }
}

