/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.AppLogInfo;
import com.dropbox.core.v2.teamlog.ResellerLogInfo;
import com.dropbox.core.v2.teamlog.UserLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ActorLogInfo {
    public static final ActorLogInfo DROPBOX = new ActorLogInfo().withTag(Tag.DROPBOX);
    public static final ActorLogInfo ANONYMOUS = new ActorLogInfo().withTag(Tag.ANONYMOUS);
    public static final ActorLogInfo OTHER = new ActorLogInfo().withTag(Tag.OTHER);
    private Tag _tag;
    private UserLogInfo userValue;
    private UserLogInfo adminValue;
    private AppLogInfo appValue;
    private ResellerLogInfo resellerValue;

    private ActorLogInfo() {
    }

    private ActorLogInfo withTag(Tag _tag) {
        ActorLogInfo result = new ActorLogInfo();
        result._tag = _tag;
        return result;
    }

    private ActorLogInfo withTagAndUser(Tag _tag, UserLogInfo userValue) {
        ActorLogInfo result = new ActorLogInfo();
        result._tag = _tag;
        result.userValue = userValue;
        return result;
    }

    private ActorLogInfo withTagAndAdmin(Tag _tag, UserLogInfo adminValue) {
        ActorLogInfo result = new ActorLogInfo();
        result._tag = _tag;
        result.adminValue = adminValue;
        return result;
    }

    private ActorLogInfo withTagAndApp(Tag _tag, AppLogInfo appValue) {
        ActorLogInfo result = new ActorLogInfo();
        result._tag = _tag;
        result.appValue = appValue;
        return result;
    }

    private ActorLogInfo withTagAndReseller(Tag _tag, ResellerLogInfo resellerValue) {
        ActorLogInfo result = new ActorLogInfo();
        result._tag = _tag;
        result.resellerValue = resellerValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUser() {
        return this._tag == Tag.USER;
    }

    public static ActorLogInfo user(UserLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ActorLogInfo().withTagAndUser(Tag.USER, value);
    }

    public UserLogInfo getUserValue() {
        if (this._tag != Tag.USER) {
            throw new IllegalStateException("Invalid tag: required Tag.USER, but was Tag." + this._tag.name());
        }
        return this.userValue;
    }

    public boolean isAdmin() {
        return this._tag == Tag.ADMIN;
    }

    public static ActorLogInfo admin(UserLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ActorLogInfo().withTagAndAdmin(Tag.ADMIN, value);
    }

    public UserLogInfo getAdminValue() {
        if (this._tag != Tag.ADMIN) {
            throw new IllegalStateException("Invalid tag: required Tag.ADMIN, but was Tag." + this._tag.name());
        }
        return this.adminValue;
    }

    public boolean isApp() {
        return this._tag == Tag.APP;
    }

    public static ActorLogInfo app(AppLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ActorLogInfo().withTagAndApp(Tag.APP, value);
    }

    public AppLogInfo getAppValue() {
        if (this._tag != Tag.APP) {
            throw new IllegalStateException("Invalid tag: required Tag.APP, but was Tag." + this._tag.name());
        }
        return this.appValue;
    }

    public boolean isReseller() {
        return this._tag == Tag.RESELLER;
    }

    public static ActorLogInfo reseller(ResellerLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ActorLogInfo().withTagAndReseller(Tag.RESELLER, value);
    }

    public ResellerLogInfo getResellerValue() {
        if (this._tag != Tag.RESELLER) {
            throw new IllegalStateException("Invalid tag: required Tag.RESELLER, but was Tag." + this._tag.name());
        }
        return this.resellerValue;
    }

    public boolean isDropbox() {
        return this._tag == Tag.DROPBOX;
    }

    public boolean isAnonymous() {
        return this._tag == Tag.ANONYMOUS;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.userValue, this.adminValue, this.appValue, this.resellerValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActorLogInfo) {
            ActorLogInfo other = (ActorLogInfo)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case USER: {
                    return this.userValue == other.userValue || this.userValue.equals(other.userValue);
                }
                case ADMIN: {
                    return this.adminValue == other.adminValue || this.adminValue.equals(other.adminValue);
                }
                case APP: {
                    return this.appValue == other.appValue || this.appValue.equals(other.appValue);
                }
                case RESELLER: {
                    return this.resellerValue == other.resellerValue || this.resellerValue.equals(other.resellerValue);
                }
                case DROPBOX: {
                    return true;
                }
                case ANONYMOUS: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ActorLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ActorLogInfo value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case USER: {
                    g2.writeStartObject();
                    this.writeTag("user", g2);
                    g2.writeFieldName("user");
                    UserLogInfo.Serializer.INSTANCE.serialize(value.userValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case ADMIN: {
                    g2.writeStartObject();
                    this.writeTag("admin", g2);
                    g2.writeFieldName("admin");
                    UserLogInfo.Serializer.INSTANCE.serialize(value.adminValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case APP: {
                    g2.writeStartObject();
                    this.writeTag("app", g2);
                    g2.writeFieldName("app");
                    AppLogInfo.Serializer.INSTANCE.serialize(value.appValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case RESELLER: {
                    g2.writeStartObject();
                    this.writeTag("reseller", g2);
                    ResellerLogInfo.Serializer.INSTANCE.serialize(value.resellerValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case DROPBOX: {
                    g2.writeString("dropbox");
                    break;
                }
                case ANONYMOUS: {
                    g2.writeString("anonymous");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public ActorLogInfo deserialize(JsonParser p) throws IOException, JsonParseException {
            ActorLogInfo value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("user".equals(tag)) {
                UserLogInfo fieldValue = null;
                Serializer.expectField("user", p);
                fieldValue = (UserLogInfo)UserLogInfo.Serializer.INSTANCE.deserialize(p);
                value = ActorLogInfo.user(fieldValue);
            } else if ("admin".equals(tag)) {
                UserLogInfo fieldValue = null;
                Serializer.expectField("admin", p);
                fieldValue = (UserLogInfo)UserLogInfo.Serializer.INSTANCE.deserialize(p);
                value = ActorLogInfo.admin(fieldValue);
            } else if ("app".equals(tag)) {
                AppLogInfo fieldValue = null;
                Serializer.expectField("app", p);
                fieldValue = (AppLogInfo)AppLogInfo.Serializer.INSTANCE.deserialize(p);
                value = ActorLogInfo.app(fieldValue);
            } else if ("reseller".equals(tag)) {
                ResellerLogInfo fieldValue = null;
                fieldValue = ResellerLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = ActorLogInfo.reseller(fieldValue);
            } else {
                value = "dropbox".equals(tag) ? DROPBOX : ("anonymous".equals(tag) ? ANONYMOUS : OTHER);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        USER,
        ADMIN,
        APP,
        RESELLER,
        DROPBOX,
        ANONYMOUS,
        OTHER;

    }
}

