/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class UserSelectorArg {
    private Tag _tag;
    private String teamMemberIdValue;
    private String externalIdValue;
    private String emailValue;

    private UserSelectorArg() {
    }

    private UserSelectorArg withTag(Tag _tag) {
        UserSelectorArg result = new UserSelectorArg();
        result._tag = _tag;
        return result;
    }

    private UserSelectorArg withTagAndTeamMemberId(Tag _tag, String teamMemberIdValue) {
        UserSelectorArg result = new UserSelectorArg();
        result._tag = _tag;
        result.teamMemberIdValue = teamMemberIdValue;
        return result;
    }

    private UserSelectorArg withTagAndExternalId(Tag _tag, String externalIdValue) {
        UserSelectorArg result = new UserSelectorArg();
        result._tag = _tag;
        result.externalIdValue = externalIdValue;
        return result;
    }

    private UserSelectorArg withTagAndEmail(Tag _tag, String emailValue) {
        UserSelectorArg result = new UserSelectorArg();
        result._tag = _tag;
        result.emailValue = emailValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTeamMemberId() {
        return this._tag == Tag.TEAM_MEMBER_ID;
    }

    public static UserSelectorArg teamMemberId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserSelectorArg().withTagAndTeamMemberId(Tag.TEAM_MEMBER_ID, value);
    }

    public String getTeamMemberIdValue() {
        if (this._tag != Tag.TEAM_MEMBER_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM_MEMBER_ID, but was Tag." + this._tag.name());
        }
        return this.teamMemberIdValue;
    }

    public boolean isExternalId() {
        return this._tag == Tag.EXTERNAL_ID;
    }

    public static UserSelectorArg externalId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 64) {
            throw new IllegalArgumentException("String is longer than 64");
        }
        return new UserSelectorArg().withTagAndExternalId(Tag.EXTERNAL_ID, value);
    }

    public String getExternalIdValue() {
        if (this._tag != Tag.EXTERNAL_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.EXTERNAL_ID, but was Tag." + this._tag.name());
        }
        return this.externalIdValue;
    }

    public boolean isEmail() {
        return this._tag == Tag.EMAIL;
    }

    public static UserSelectorArg email(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new UserSelectorArg().withTagAndEmail(Tag.EMAIL, value);
    }

    public String getEmailValue() {
        if (this._tag != Tag.EMAIL) {
            throw new IllegalStateException("Invalid tag: required Tag.EMAIL, but was Tag." + this._tag.name());
        }
        return this.emailValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.teamMemberIdValue, this.externalIdValue, this.emailValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UserSelectorArg) {
            UserSelectorArg other = (UserSelectorArg)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEAM_MEMBER_ID: {
                    return this.teamMemberIdValue == other.teamMemberIdValue || this.teamMemberIdValue.equals(other.teamMemberIdValue);
                }
                case EXTERNAL_ID: {
                    return this.externalIdValue == other.externalIdValue || this.externalIdValue.equals(other.externalIdValue);
                }
                case EMAIL: {
                    return this.emailValue == other.emailValue || this.emailValue.equals(other.emailValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UserSelectorArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserSelectorArg value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEAM_MEMBER_ID: {
                    g2.writeStartObject();
                    this.writeTag("team_member_id", g2);
                    g2.writeFieldName("team_member_id");
                    StoneSerializers.string().serialize(value.teamMemberIdValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case EXTERNAL_ID: {
                    g2.writeStartObject();
                    this.writeTag("external_id", g2);
                    g2.writeFieldName("external_id");
                    StoneSerializers.string().serialize(value.externalIdValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case EMAIL: {
                    g2.writeStartObject();
                    this.writeTag("email", g2);
                    g2.writeFieldName("email");
                    StoneSerializers.string().serialize(value.emailValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public UserSelectorArg deserialize(JsonParser p) throws IOException, JsonParseException {
            UserSelectorArg value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("team_member_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("team_member_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = UserSelectorArg.teamMemberId(fieldValue);
            } else if ("external_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("external_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = UserSelectorArg.externalId(fieldValue);
            } else if ("email".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("email", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = UserSelectorArg.email(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEAM_MEMBER_ID,
        EXTERNAL_ID,
        EMAIL;

    }
}

