/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UserCustomQuotaResult {
    protected final UserSelectorArg user;
    protected final Long quotaGb;

    public UserCustomQuotaResult(UserSelectorArg user, Long quotaGb) {
        if (user == null) {
            throw new IllegalArgumentException("Required value for 'user' is null");
        }
        this.user = user;
        if (quotaGb != null && quotaGb < 15L) {
            throw new IllegalArgumentException("Number 'quotaGb' is smaller than 15L");
        }
        this.quotaGb = quotaGb;
    }

    public UserCustomQuotaResult(UserSelectorArg user) {
        this(user, null);
    }

    public UserSelectorArg getUser() {
        return this.user;
    }

    public Long getQuotaGb() {
        return this.quotaGb;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.user, this.quotaGb});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserCustomQuotaResult other = (UserCustomQuotaResult)obj;
            return (this.user == other.user || this.user.equals(other.user)) && (this.quotaGb == other.quotaGb || this.quotaGb != null && this.quotaGb.equals(other.quotaGb));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserCustomQuotaResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserCustomQuotaResult value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("user");
            UserSelectorArg.Serializer.INSTANCE.serialize(value.user, g2);
            if (value.quotaGb != null) {
                g2.writeFieldName("quota_gb");
                StoneSerializers.nullable(StoneSerializers.uInt32()).serialize(value.quotaGb, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public UserCustomQuotaResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_quotaGb;
            UserSelectorArg f_user;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_user = null;
                f_quotaGb = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("user".equals(field)) {
                        f_user = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("quota_gb".equals(field)) {
                        f_quotaGb = StoneSerializers.nullable(StoneSerializers.uInt32()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_user == null) {
                    throw new JsonParseException(p, "Required field \"user\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserCustomQuotaResult value = new UserCustomQuotaResult(f_user, f_quotaGb);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

