/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class GroupsSelector {
    private Tag _tag;
    private List<String> groupIdsValue;
    private List<String> groupExternalIdsValue;

    private GroupsSelector() {
    }

    private GroupsSelector withTag(Tag _tag) {
        GroupsSelector result = new GroupsSelector();
        result._tag = _tag;
        return result;
    }

    private GroupsSelector withTagAndGroupIds(Tag _tag, List<String> groupIdsValue) {
        GroupsSelector result = new GroupsSelector();
        result._tag = _tag;
        result.groupIdsValue = groupIdsValue;
        return result;
    }

    private GroupsSelector withTagAndGroupExternalIds(Tag _tag, List<String> groupExternalIdsValue) {
        GroupsSelector result = new GroupsSelector();
        result._tag = _tag;
        result.groupExternalIdsValue = groupExternalIdsValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isGroupIds() {
        return this._tag == Tag.GROUP_IDS;
    }

    public static GroupsSelector groupIds(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupsSelector().withTagAndGroupIds(Tag.GROUP_IDS, value);
    }

    public List<String> getGroupIdsValue() {
        if (this._tag != Tag.GROUP_IDS) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_IDS, but was Tag." + this._tag.name());
        }
        return this.groupIdsValue;
    }

    public boolean isGroupExternalIds() {
        return this._tag == Tag.GROUP_EXTERNAL_IDS;
    }

    public static GroupsSelector groupExternalIds(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupsSelector().withTagAndGroupExternalIds(Tag.GROUP_EXTERNAL_IDS, value);
    }

    public List<String> getGroupExternalIdsValue() {
        if (this._tag != Tag.GROUP_EXTERNAL_IDS) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_EXTERNAL_IDS, but was Tag." + this._tag.name());
        }
        return this.groupExternalIdsValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.groupIdsValue, this.groupExternalIdsValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GroupsSelector) {
            GroupsSelector other = (GroupsSelector)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case GROUP_IDS: {
                    return this.groupIdsValue == other.groupIdsValue || this.groupIdsValue.equals(other.groupIdsValue);
                }
                case GROUP_EXTERNAL_IDS: {
                    return this.groupExternalIdsValue == other.groupExternalIdsValue || this.groupExternalIdsValue.equals(other.groupExternalIdsValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GroupsSelector> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupsSelector value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case GROUP_IDS: {
                    g2.writeStartObject();
                    this.writeTag("group_ids", g2);
                    g2.writeFieldName("group_ids");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.groupIdsValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case GROUP_EXTERNAL_IDS: {
                    g2.writeStartObject();
                    this.writeTag("group_external_ids", g2);
                    g2.writeFieldName("group_external_ids");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.groupExternalIdsValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public GroupsSelector deserialize(JsonParser p) throws IOException, JsonParseException {
            GroupsSelector value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("group_ids".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("group_ids", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupsSelector.groupIds(fieldValue);
            } else if ("group_external_ids".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("group_external_ids", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupsSelector.groupExternalIds(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        GROUP_IDS,
        GROUP_EXTERNAL_IDS;

    }
}

