/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.MemberProfile;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ExcludedUsersListResult {
    protected final List<MemberProfile> users;
    protected final String cursor;
    protected final boolean hasMore;

    public ExcludedUsersListResult(List<MemberProfile> users, boolean hasMore, String cursor) {
        if (users == null) {
            throw new IllegalArgumentException("Required value for 'users' is null");
        }
        for (MemberProfile x : users) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'users' is null");
        }
        this.users = users;
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public ExcludedUsersListResult(List<MemberProfile> users, boolean hasMore) {
        this(users, hasMore, null);
    }

    public List<MemberProfile> getUsers() {
        return this.users;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.users, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ExcludedUsersListResult other = (ExcludedUsersListResult)obj;
            return (this.users == other.users || this.users.equals(other.users)) && this.hasMore == other.hasMore && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ExcludedUsersListResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ExcludedUsersListResult value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("users");
            StoneSerializers.list(MemberProfile.Serializer.INSTANCE).serialize(value.users, g2);
            g2.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g2);
            if (value.cursor != null) {
                g2.writeFieldName("cursor");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.cursor, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ExcludedUsersListResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_cursor;
            Boolean f_hasMore;
            List<MemberProfile> f_users;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_users = null;
                f_hasMore = null;
                f_cursor = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("users".equals(field)) {
                        f_users = StoneSerializers.list(MemberProfile.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_users == null) {
                    throw new JsonParseException(p, "Required field \"users\" missing.");
                }
                if (f_hasMore == null) {
                    throw new JsonParseException(p, "Required field \"has_more\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ExcludedUsersListResult value = new ExcludedUsersListResult(f_users, f_hasMore, f_cursor);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

