/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.SharedFolderAccessError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class TransferFolderError {
    public static final TransferFolderError INVALID_DROPBOX_ID = new TransferFolderError().withTag(Tag.INVALID_DROPBOX_ID);
    public static final TransferFolderError NEW_OWNER_NOT_A_MEMBER = new TransferFolderError().withTag(Tag.NEW_OWNER_NOT_A_MEMBER);
    public static final TransferFolderError NEW_OWNER_UNMOUNTED = new TransferFolderError().withTag(Tag.NEW_OWNER_UNMOUNTED);
    public static final TransferFolderError NEW_OWNER_EMAIL_UNVERIFIED = new TransferFolderError().withTag(Tag.NEW_OWNER_EMAIL_UNVERIFIED);
    public static final TransferFolderError TEAM_FOLDER = new TransferFolderError().withTag(Tag.TEAM_FOLDER);
    public static final TransferFolderError NO_PERMISSION = new TransferFolderError().withTag(Tag.NO_PERMISSION);
    public static final TransferFolderError OTHER = new TransferFolderError().withTag(Tag.OTHER);
    private Tag _tag;
    private SharedFolderAccessError accessErrorValue;

    private TransferFolderError() {
    }

    private TransferFolderError withTag(Tag _tag) {
        TransferFolderError result = new TransferFolderError();
        result._tag = _tag;
        return result;
    }

    private TransferFolderError withTagAndAccessError(Tag _tag, SharedFolderAccessError accessErrorValue) {
        TransferFolderError result = new TransferFolderError();
        result._tag = _tag;
        result.accessErrorValue = accessErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static TransferFolderError accessError(SharedFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TransferFolderError().withTagAndAccessError(Tag.ACCESS_ERROR, value);
    }

    public SharedFolderAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isInvalidDropboxId() {
        return this._tag == Tag.INVALID_DROPBOX_ID;
    }

    public boolean isNewOwnerNotAMember() {
        return this._tag == Tag.NEW_OWNER_NOT_A_MEMBER;
    }

    public boolean isNewOwnerUnmounted() {
        return this._tag == Tag.NEW_OWNER_UNMOUNTED;
    }

    public boolean isNewOwnerEmailUnverified() {
        return this._tag == Tag.NEW_OWNER_EMAIL_UNVERIFIED;
    }

    public boolean isTeamFolder() {
        return this._tag == Tag.TEAM_FOLDER;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.accessErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TransferFolderError) {
            TransferFolderError other = (TransferFolderError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case INVALID_DROPBOX_ID: {
                    return true;
                }
                case NEW_OWNER_NOT_A_MEMBER: {
                    return true;
                }
                case NEW_OWNER_UNMOUNTED: {
                    return true;
                }
                case NEW_OWNER_EMAIL_UNVERIFIED: {
                    return true;
                }
                case TEAM_FOLDER: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TransferFolderError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TransferFolderError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ACCESS_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("access_error", g2);
                    g2.writeFieldName("access_error");
                    SharedFolderAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case INVALID_DROPBOX_ID: {
                    g2.writeString("invalid_dropbox_id");
                    break;
                }
                case NEW_OWNER_NOT_A_MEMBER: {
                    g2.writeString("new_owner_not_a_member");
                    break;
                }
                case NEW_OWNER_UNMOUNTED: {
                    g2.writeString("new_owner_unmounted");
                    break;
                }
                case NEW_OWNER_EMAIL_UNVERIFIED: {
                    g2.writeString("new_owner_email_unverified");
                    break;
                }
                case TEAM_FOLDER: {
                    g2.writeString("team_folder");
                    break;
                }
                case NO_PERMISSION: {
                    g2.writeString("no_permission");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public TransferFolderError deserialize(JsonParser p) throws IOException, JsonParseException {
            TransferFolderError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("access_error".equals(tag)) {
                SharedFolderAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharedFolderAccessError.Serializer.INSTANCE.deserialize(p);
                value = TransferFolderError.accessError(fieldValue);
            } else {
                value = "invalid_dropbox_id".equals(tag) ? INVALID_DROPBOX_ID : ("new_owner_not_a_member".equals(tag) ? NEW_OWNER_NOT_A_MEMBER : ("new_owner_unmounted".equals(tag) ? NEW_OWNER_UNMOUNTED : ("new_owner_email_unverified".equals(tag) ? NEW_OWNER_EMAIL_UNVERIFIED : ("team_folder".equals(tag) ? TEAM_FOLDER : ("no_permission".equals(tag) ? NO_PERMISSION : OTHER)))));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        INVALID_DROPBOX_ID,
        NEW_OWNER_NOT_A_MEMBER,
        NEW_OWNER_UNMOUNTED,
        NEW_OWNER_EMAIL_UNVERIFIED,
        TEAM_FOLDER,
        NO_PERMISSION,
        OTHER;

    }
}

