/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class GetSharedLinkMetadataArg {
    protected final String url;
    protected final String path;
    protected final String linkPassword;

    public GetSharedLinkMetadataArg(String url, String path, String linkPassword) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (path != null && !Pattern.matches("/(.|[\\r\\n])*", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.linkPassword = linkPassword;
    }

    public GetSharedLinkMetadataArg(String url) {
        this(url, null, null);
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getLinkPassword() {
        return this.linkPassword;
    }

    public static Builder newBuilder(String url) {
        return new Builder(url);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.path, this.linkPassword});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetSharedLinkMetadataArg other = (GetSharedLinkMetadataArg)obj;
            return (this.url == other.url || this.url.equals(other.url)) && (this.path == other.path || this.path != null && this.path.equals(other.path)) && (this.linkPassword == other.linkPassword || this.linkPassword != null && this.linkPassword.equals(other.linkPassword));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GetSharedLinkMetadataArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetSharedLinkMetadataArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g2);
            if (value.path != null) {
                g2.writeFieldName("path");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.path, g2);
            }
            if (value.linkPassword != null) {
                g2.writeFieldName("link_password");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.linkPassword, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public GetSharedLinkMetadataArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_linkPassword;
            String f_path;
            String f_url;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_url = null;
                f_path = null;
                f_linkPassword = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("link_password".equals(field)) {
                        f_linkPassword = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GetSharedLinkMetadataArg value = new GetSharedLinkMetadataArg(f_url, f_path, f_linkPassword);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String url;
        protected String path;
        protected String linkPassword;

        protected Builder(String url) {
            if (url == null) {
                throw new IllegalArgumentException("Required value for 'url' is null");
            }
            this.url = url;
            this.path = null;
            this.linkPassword = null;
        }

        public Builder withPath(String path) {
            if (path != null && !Pattern.matches("/(.|[\\r\\n])*", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            return this;
        }

        public Builder withLinkPassword(String linkPassword) {
            this.linkPassword = linkPassword;
            return this;
        }

        public GetSharedLinkMetadataArg build() {
            return new GetSharedLinkMetadataArg(this.url, this.path, this.linkPassword);
        }
    }
}

