/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.ImportFormat;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class PaperDocCreateArgs {
    protected final String parentFolderId;
    protected final ImportFormat importFormat;

    public PaperDocCreateArgs(ImportFormat importFormat, String parentFolderId) {
        this.parentFolderId = parentFolderId;
        if (importFormat == null) {
            throw new IllegalArgumentException("Required value for 'importFormat' is null");
        }
        this.importFormat = importFormat;
    }

    public PaperDocCreateArgs(ImportFormat importFormat) {
        this(importFormat, null);
    }

    public ImportFormat getImportFormat() {
        return this.importFormat;
    }

    public String getParentFolderId() {
        return this.parentFolderId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.parentFolderId, this.importFormat});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperDocCreateArgs other = (PaperDocCreateArgs)obj;
            return (this.importFormat == other.importFormat || this.importFormat.equals((Object)other.importFormat)) && (this.parentFolderId == other.parentFolderId || this.parentFolderId != null && this.parentFolderId.equals(other.parentFolderId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperDocCreateArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDocCreateArgs value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("import_format");
            ImportFormat.Serializer.INSTANCE.serialize(value.importFormat, g2);
            if (value.parentFolderId != null) {
                g2.writeFieldName("parent_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentFolderId, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public PaperDocCreateArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_parentFolderId;
            ImportFormat f_importFormat;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_importFormat = null;
                f_parentFolderId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("import_format".equals(field)) {
                        f_importFormat = ImportFormat.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("parent_folder_id".equals(field)) {
                        f_parentFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_importFormat == null) {
                    throw new JsonParseException(p, "Required field \"import_format\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperDocCreateArgs value = new PaperDocCreateArgs(f_importFormat, f_parentFolderId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

