/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.RefPaperDoc;
import com.dropbox.core.v2.paper.UserOnPaperDocFilter;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class ListUsersOnPaperDocArgs
extends RefPaperDoc {
    protected final int limit;
    protected final UserOnPaperDocFilter filterBy;

    public ListUsersOnPaperDocArgs(String docId, int limit, UserOnPaperDocFilter filterBy) {
        super(docId);
        if (limit < 1) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1");
        }
        if (limit > 1000) {
            throw new IllegalArgumentException("Number 'limit' is larger than 1000");
        }
        this.limit = limit;
        if (filterBy == null) {
            throw new IllegalArgumentException("Required value for 'filterBy' is null");
        }
        this.filterBy = filterBy;
    }

    public ListUsersOnPaperDocArgs(String docId) {
        this(docId, 1000, UserOnPaperDocFilter.SHARED);
    }

    @Override
    public String getDocId() {
        return this.docId;
    }

    public int getLimit() {
        return this.limit;
    }

    public UserOnPaperDocFilter getFilterBy() {
        return this.filterBy;
    }

    public static Builder newBuilder(String docId) {
        return new Builder(docId);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.limit, this.filterBy});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListUsersOnPaperDocArgs other = (ListUsersOnPaperDocArgs)obj;
            return !(this.docId != other.docId && !this.docId.equals(other.docId) || this.limit != other.limit || this.filterBy != other.filterBy && !this.filterBy.equals((Object)other.filterBy));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListUsersOnPaperDocArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListUsersOnPaperDocArgs value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("doc_id");
            StoneSerializers.string().serialize(value.docId, g2);
            g2.writeFieldName("limit");
            StoneSerializers.int32().serialize((Integer)value.limit, g2);
            g2.writeFieldName("filter_by");
            UserOnPaperDocFilter.Serializer.INSTANCE.serialize(value.filterBy, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ListUsersOnPaperDocArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            UserOnPaperDocFilter f_filterBy;
            Integer f_limit;
            String f_docId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_docId = null;
                f_limit = 1000;
                f_filterBy = UserOnPaperDocFilter.SHARED;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("doc_id".equals(field)) {
                        f_docId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.int32().deserialize(p);
                        continue;
                    }
                    if ("filter_by".equals(field)) {
                        f_filterBy = UserOnPaperDocFilter.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_docId == null) {
                    throw new JsonParseException(p, "Required field \"doc_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListUsersOnPaperDocArgs value = new ListUsersOnPaperDocArgs(f_docId, f_limit, f_filterBy);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String docId;
        protected int limit;
        protected UserOnPaperDocFilter filterBy;

        protected Builder(String docId) {
            if (docId == null) {
                throw new IllegalArgumentException("Required value for 'docId' is null");
            }
            this.docId = docId;
            this.limit = 1000;
            this.filterBy = UserOnPaperDocFilter.SHARED;
        }

        public Builder withLimit(Integer limit) {
            if (limit < 1) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1");
            }
            if (limit > 1000) {
                throw new IllegalArgumentException("Number 'limit' is larger than 1000");
            }
            this.limit = limit != null ? limit : 1000;
            return this;
        }

        public Builder withFilterBy(UserOnPaperDocFilter filterBy) {
            this.filterBy = filterBy != null ? filterBy : UserOnPaperDocFilter.SHARED;
            return this;
        }

        public ListUsersOnPaperDocArgs build() {
            return new ListUsersOnPaperDocArgs(this.docId, this.limit, this.filterBy);
        }
    }
}

