/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ThumbnailV2Error {
    public static final ThumbnailV2Error UNSUPPORTED_EXTENSION = new ThumbnailV2Error().withTag(Tag.UNSUPPORTED_EXTENSION);
    public static final ThumbnailV2Error UNSUPPORTED_IMAGE = new ThumbnailV2Error().withTag(Tag.UNSUPPORTED_IMAGE);
    public static final ThumbnailV2Error CONVERSION_ERROR = new ThumbnailV2Error().withTag(Tag.CONVERSION_ERROR);
    public static final ThumbnailV2Error ACCESS_DENIED = new ThumbnailV2Error().withTag(Tag.ACCESS_DENIED);
    public static final ThumbnailV2Error NOT_FOUND = new ThumbnailV2Error().withTag(Tag.NOT_FOUND);
    public static final ThumbnailV2Error OTHER = new ThumbnailV2Error().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathValue;

    private ThumbnailV2Error() {
    }

    private ThumbnailV2Error withTag(Tag _tag) {
        ThumbnailV2Error result = new ThumbnailV2Error();
        result._tag = _tag;
        return result;
    }

    private ThumbnailV2Error withTagAndPath(Tag _tag, LookupError pathValue) {
        ThumbnailV2Error result = new ThumbnailV2Error();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static ThumbnailV2Error path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ThumbnailV2Error().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isUnsupportedExtension() {
        return this._tag == Tag.UNSUPPORTED_EXTENSION;
    }

    public boolean isUnsupportedImage() {
        return this._tag == Tag.UNSUPPORTED_IMAGE;
    }

    public boolean isConversionError() {
        return this._tag == Tag.CONVERSION_ERROR;
    }

    public boolean isAccessDenied() {
        return this._tag == Tag.ACCESS_DENIED;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ThumbnailV2Error) {
            ThumbnailV2Error other = (ThumbnailV2Error)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case UNSUPPORTED_EXTENSION: {
                    return true;
                }
                case UNSUPPORTED_IMAGE: {
                    return true;
                }
                case CONVERSION_ERROR: {
                    return true;
                }
                case ACCESS_DENIED: {
                    return true;
                }
                case NOT_FOUND: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ThumbnailV2Error> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ThumbnailV2Error value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g2.writeStartObject();
                    this.writeTag("path", g2);
                    g2.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case UNSUPPORTED_EXTENSION: {
                    g2.writeString("unsupported_extension");
                    break;
                }
                case UNSUPPORTED_IMAGE: {
                    g2.writeString("unsupported_image");
                    break;
                }
                case CONVERSION_ERROR: {
                    g2.writeString("conversion_error");
                    break;
                }
                case ACCESS_DENIED: {
                    g2.writeString("access_denied");
                    break;
                }
                case NOT_FOUND: {
                    g2.writeString("not_found");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public ThumbnailV2Error deserialize(JsonParser p) throws IOException, JsonParseException {
            ThumbnailV2Error value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = ThumbnailV2Error.path(fieldValue);
            } else {
                value = "unsupported_extension".equals(tag) ? UNSUPPORTED_EXTENSION : ("unsupported_image".equals(tag) ? UNSUPPORTED_IMAGE : ("conversion_error".equals(tag) ? CONVERSION_ERROR : ("access_denied".equals(tag) ? ACCESS_DENIED : ("not_found".equals(tag) ? NOT_FOUND : OTHER))));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        UNSUPPORTED_EXTENSION,
        UNSUPPORTED_IMAGE,
        CONVERSION_ERROR,
        ACCESS_DENIED,
        NOT_FOUND,
        OTHER;

    }
}

