/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.RelocationBatchV2Result;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class RelocationBatchV2JobStatus {
    public static final RelocationBatchV2JobStatus IN_PROGRESS = new RelocationBatchV2JobStatus().withTag(Tag.IN_PROGRESS);
    private Tag _tag;
    private RelocationBatchV2Result completeValue;

    private RelocationBatchV2JobStatus() {
    }

    private RelocationBatchV2JobStatus withTag(Tag _tag) {
        RelocationBatchV2JobStatus result = new RelocationBatchV2JobStatus();
        result._tag = _tag;
        return result;
    }

    private RelocationBatchV2JobStatus withTagAndComplete(Tag _tag, RelocationBatchV2Result completeValue) {
        RelocationBatchV2JobStatus result = new RelocationBatchV2JobStatus();
        result._tag = _tag;
        result.completeValue = completeValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static RelocationBatchV2JobStatus complete(RelocationBatchV2Result value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationBatchV2JobStatus().withTagAndComplete(Tag.COMPLETE, value);
    }

    public RelocationBatchV2Result getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.completeValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RelocationBatchV2JobStatus) {
            RelocationBatchV2JobStatus other = (RelocationBatchV2JobStatus)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<RelocationBatchV2JobStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RelocationBatchV2JobStatus value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IN_PROGRESS: {
                    g2.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g2.writeStartObject();
                    this.writeTag("complete", g2);
                    RelocationBatchV2Result.Serializer.INSTANCE.serialize(value.completeValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public RelocationBatchV2JobStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            RelocationBatchV2JobStatus value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("in_progress".equals(tag)) {
                value = IN_PROGRESS;
            } else if ("complete".equals(tag)) {
                RelocationBatchV2Result fieldValue = null;
                fieldValue = RelocationBatchV2Result.Serializer.INSTANCE.deserialize(p, true);
                value = RelocationBatchV2JobStatus.complete(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE;

    }
}

