/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.RelocationError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class RelocationBatchErrorEntry {
    public static final RelocationBatchErrorEntry INTERNAL_ERROR = new RelocationBatchErrorEntry().withTag(Tag.INTERNAL_ERROR);
    public static final RelocationBatchErrorEntry TOO_MANY_WRITE_OPERATIONS = new RelocationBatchErrorEntry().withTag(Tag.TOO_MANY_WRITE_OPERATIONS);
    public static final RelocationBatchErrorEntry OTHER = new RelocationBatchErrorEntry().withTag(Tag.OTHER);
    private Tag _tag;
    private RelocationError relocationErrorValue;

    private RelocationBatchErrorEntry() {
    }

    private RelocationBatchErrorEntry withTag(Tag _tag) {
        RelocationBatchErrorEntry result = new RelocationBatchErrorEntry();
        result._tag = _tag;
        return result;
    }

    private RelocationBatchErrorEntry withTagAndRelocationError(Tag _tag, RelocationError relocationErrorValue) {
        RelocationBatchErrorEntry result = new RelocationBatchErrorEntry();
        result._tag = _tag;
        result.relocationErrorValue = relocationErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isRelocationError() {
        return this._tag == Tag.RELOCATION_ERROR;
    }

    public static RelocationBatchErrorEntry relocationError(RelocationError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationBatchErrorEntry().withTagAndRelocationError(Tag.RELOCATION_ERROR, value);
    }

    public RelocationError getRelocationErrorValue() {
        if (this._tag != Tag.RELOCATION_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.RELOCATION_ERROR, but was Tag." + this._tag.name());
        }
        return this.relocationErrorValue;
    }

    public boolean isInternalError() {
        return this._tag == Tag.INTERNAL_ERROR;
    }

    public boolean isTooManyWriteOperations() {
        return this._tag == Tag.TOO_MANY_WRITE_OPERATIONS;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.relocationErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RelocationBatchErrorEntry) {
            RelocationBatchErrorEntry other = (RelocationBatchErrorEntry)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case RELOCATION_ERROR: {
                    return this.relocationErrorValue == other.relocationErrorValue || this.relocationErrorValue.equals(other.relocationErrorValue);
                }
                case INTERNAL_ERROR: {
                    return true;
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<RelocationBatchErrorEntry> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RelocationBatchErrorEntry value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case RELOCATION_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("relocation_error", g2);
                    g2.writeFieldName("relocation_error");
                    RelocationError.Serializer.INSTANCE.serialize(value.relocationErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case INTERNAL_ERROR: {
                    g2.writeString("internal_error");
                    break;
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    g2.writeString("too_many_write_operations");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public RelocationBatchErrorEntry deserialize(JsonParser p) throws IOException, JsonParseException {
            RelocationBatchErrorEntry value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("relocation_error".equals(tag)) {
                RelocationError fieldValue = null;
                Serializer.expectField("relocation_error", p);
                fieldValue = RelocationError.Serializer.INSTANCE.deserialize(p);
                value = RelocationBatchErrorEntry.relocationError(fieldValue);
            } else {
                value = "internal_error".equals(tag) ? INTERNAL_ERROR : ("too_many_write_operations".equals(tag) ? TOO_MANY_WRITE_OPERATIONS : OTHER);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        RELOCATION_ERROR,
        INTERNAL_ERROR,
        TOO_MANY_WRITE_OPERATIONS,
        OTHER;

    }
}

