/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.FileLock;
import com.dropbox.core.v2.files.Metadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class LockFileResult {
    protected final Metadata metadata;
    protected final FileLock lock;

    public LockFileResult(Metadata metadata, FileLock lock) {
        if (metadata == null) {
            throw new IllegalArgumentException("Required value for 'metadata' is null");
        }
        this.metadata = metadata;
        if (lock == null) {
            throw new IllegalArgumentException("Required value for 'lock' is null");
        }
        this.lock = lock;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public FileLock getLock() {
        return this.lock;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.metadata, this.lock});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LockFileResult other = (LockFileResult)obj;
            return !(this.metadata != other.metadata && !this.metadata.equals(other.metadata) || this.lock != other.lock && !this.lock.equals(other.lock));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LockFileResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LockFileResult value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("metadata");
            Metadata.Serializer.INSTANCE.serialize(value.metadata, g2);
            g2.writeFieldName("lock");
            FileLock.Serializer.INSTANCE.serialize(value.lock, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public LockFileResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileLock f_lock;
            Metadata f_metadata;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_metadata = null;
                f_lock = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("metadata".equals(field)) {
                        f_metadata = (Metadata)Metadata.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("lock".equals(field)) {
                        f_lock = (FileLock)FileLock.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_metadata == null) {
                    throw new JsonParseException(p, "Required field \"metadata\" missing.");
                }
                if (f_lock == null) {
                    throw new JsonParseException(p, "Required field \"lock\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LockFileResult value = new LockFileResult(f_metadata, f_lock);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

