/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class GpsCoordinates {
    protected final double latitude;
    protected final double longitude;

    public GpsCoordinates(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.latitude, this.longitude});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GpsCoordinates other = (GpsCoordinates)obj;
            return this.latitude == other.latitude && this.longitude == other.longitude;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GpsCoordinates> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GpsCoordinates value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("latitude");
            StoneSerializers.float64().serialize((Double)value.latitude, g2);
            g2.writeFieldName("longitude");
            StoneSerializers.float64().serialize((Double)value.longitude, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public GpsCoordinates deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Double f_longitude;
            Double f_latitude;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_latitude = null;
                f_longitude = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("latitude".equals(field)) {
                        f_latitude = StoneSerializers.float64().deserialize(p);
                        continue;
                    }
                    if ("longitude".equals(field)) {
                        f_longitude = StoneSerializers.float64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_latitude == null) {
                    throw new JsonParseException(p, "Required field \"latitude\" missing.");
                }
                if (f_longitude == null) {
                    throw new JsonParseException(p, "Required field \"longitude\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GpsCoordinates value = new GpsCoordinates(f_latitude, f_longitude);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

