/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.SharingInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class FolderSharingInfo
extends SharingInfo {
    protected final String parentSharedFolderId;
    protected final String sharedFolderId;
    protected final boolean traverseOnly;
    protected final boolean noAccess;

    public FolderSharingInfo(boolean readOnly, String parentSharedFolderId, String sharedFolderId, boolean traverseOnly, boolean noAccess) {
        super(readOnly);
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
        if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        this.traverseOnly = traverseOnly;
        this.noAccess = noAccess;
    }

    public FolderSharingInfo(boolean readOnly) {
        this(readOnly, null, null, false, false);
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public boolean getTraverseOnly() {
        return this.traverseOnly;
    }

    public boolean getNoAccess() {
        return this.noAccess;
    }

    public static Builder newBuilder(boolean readOnly) {
        return new Builder(readOnly);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.parentSharedFolderId, this.sharedFolderId, this.traverseOnly, this.noAccess});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderSharingInfo other = (FolderSharingInfo)obj;
            return this.readOnly == other.readOnly && (this.parentSharedFolderId == other.parentSharedFolderId || this.parentSharedFolderId != null && this.parentSharedFolderId.equals(other.parentSharedFolderId)) && (this.sharedFolderId == other.sharedFolderId || this.sharedFolderId != null && this.sharedFolderId.equals(other.sharedFolderId)) && this.traverseOnly == other.traverseOnly && this.noAccess == other.noAccess;
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FolderSharingInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FolderSharingInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("read_only");
            StoneSerializers.boolean_().serialize((Boolean)value.readOnly, g2);
            if (value.parentSharedFolderId != null) {
                g2.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g2);
            }
            if (value.sharedFolderId != null) {
                g2.writeFieldName("shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.sharedFolderId, g2);
            }
            g2.writeFieldName("traverse_only");
            StoneSerializers.boolean_().serialize((Boolean)value.traverseOnly, g2);
            g2.writeFieldName("no_access");
            StoneSerializers.boolean_().serialize((Boolean)value.noAccess, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public FolderSharingInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_noAccess;
            Boolean f_traverseOnly;
            String f_sharedFolderId;
            String f_parentSharedFolderId;
            Boolean f_readOnly;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_readOnly = null;
                f_parentSharedFolderId = null;
                f_sharedFolderId = null;
                f_traverseOnly = false;
                f_noAccess = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("read_only".equals(field)) {
                        f_readOnly = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("shared_folder_id".equals(field)) {
                        f_sharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("traverse_only".equals(field)) {
                        f_traverseOnly = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("no_access".equals(field)) {
                        f_noAccess = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_readOnly == null) {
                    throw new JsonParseException(p, "Required field \"read_only\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FolderSharingInfo value = new FolderSharingInfo(f_readOnly, f_parentSharedFolderId, f_sharedFolderId, f_traverseOnly, f_noAccess);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final boolean readOnly;
        protected String parentSharedFolderId;
        protected String sharedFolderId;
        protected boolean traverseOnly;
        protected boolean noAccess;

        protected Builder(boolean readOnly) {
            this.readOnly = readOnly;
            this.parentSharedFolderId = null;
            this.sharedFolderId = null;
            this.traverseOnly = false;
            this.noAccess = false;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Builder withSharedFolderId(String sharedFolderId) {
            if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            return this;
        }

        public Builder withTraverseOnly(Boolean traverseOnly) {
            this.traverseOnly = traverseOnly != null ? traverseOnly : false;
            return this;
        }

        public Builder withNoAccess(Boolean noAccess) {
            this.noAccess = noAccess != null ? noAccess : false;
            return this;
        }

        public FolderSharingInfo build() {
            return new FolderSharingInfo(this.readOnly, this.parentSharedFolderId, this.sharedFolderId, this.traverseOnly, this.noAccess);
        }
    }
}

