/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.DeleteBatchResultData;
import com.dropbox.core.v2.files.DeleteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class DeleteBatchResultEntry {
    private Tag _tag;
    private DeleteBatchResultData successValue;
    private DeleteError failureValue;

    private DeleteBatchResultEntry() {
    }

    private DeleteBatchResultEntry withTag(Tag _tag) {
        DeleteBatchResultEntry result = new DeleteBatchResultEntry();
        result._tag = _tag;
        return result;
    }

    private DeleteBatchResultEntry withTagAndSuccess(Tag _tag, DeleteBatchResultData successValue) {
        DeleteBatchResultEntry result = new DeleteBatchResultEntry();
        result._tag = _tag;
        result.successValue = successValue;
        return result;
    }

    private DeleteBatchResultEntry withTagAndFailure(Tag _tag, DeleteError failureValue) {
        DeleteBatchResultEntry result = new DeleteBatchResultEntry();
        result._tag = _tag;
        result.failureValue = failureValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static DeleteBatchResultEntry success(DeleteBatchResultData value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new DeleteBatchResultEntry().withTagAndSuccess(Tag.SUCCESS, value);
    }

    public DeleteBatchResultData getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isFailure() {
        return this._tag == Tag.FAILURE;
    }

    public static DeleteBatchResultEntry failure(DeleteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new DeleteBatchResultEntry().withTagAndFailure(Tag.FAILURE, value);
    }

    public DeleteError getFailureValue() {
        if (this._tag != Tag.FAILURE) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILURE, but was Tag." + this._tag.name());
        }
        return this.failureValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.successValue, this.failureValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DeleteBatchResultEntry) {
            DeleteBatchResultEntry other = (DeleteBatchResultEntry)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case FAILURE: {
                    return this.failureValue == other.failureValue || this.failureValue.equals(other.failureValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<DeleteBatchResultEntry> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteBatchResultEntry value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SUCCESS: {
                    g2.writeStartObject();
                    this.writeTag("success", g2);
                    DeleteBatchResultData.Serializer.INSTANCE.serialize(value.successValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case FAILURE: {
                    g2.writeStartObject();
                    this.writeTag("failure", g2);
                    g2.writeFieldName("failure");
                    DeleteError.Serializer.INSTANCE.serialize(value.failureValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public DeleteBatchResultEntry deserialize(JsonParser p) throws IOException, JsonParseException {
            DeleteBatchResultEntry value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("success".equals(tag)) {
                DeleteBatchResultData fieldValue = null;
                fieldValue = DeleteBatchResultData.Serializer.INSTANCE.deserialize(p, true);
                value = DeleteBatchResultEntry.success(fieldValue);
            } else if ("failure".equals(tag)) {
                DeleteError fieldValue = null;
                Serializer.expectField("failure", p);
                fieldValue = DeleteError.Serializer.INSTANCE.deserialize(p);
                value = DeleteBatchResultEntry.failure(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SUCCESS,
        FAILURE;

    }
}

