/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.fileproperties.LookUpPropertiesError;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class AlphaGetMetadataError {
    private Tag _tag;
    private LookupError pathValue;
    private LookUpPropertiesError propertiesErrorValue;

    private AlphaGetMetadataError() {
    }

    private AlphaGetMetadataError withTag(Tag _tag) {
        AlphaGetMetadataError result = new AlphaGetMetadataError();
        result._tag = _tag;
        return result;
    }

    private AlphaGetMetadataError withTagAndPath(Tag _tag, LookupError pathValue) {
        AlphaGetMetadataError result = new AlphaGetMetadataError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    private AlphaGetMetadataError withTagAndPropertiesError(Tag _tag, LookUpPropertiesError propertiesErrorValue) {
        AlphaGetMetadataError result = new AlphaGetMetadataError();
        result._tag = _tag;
        result.propertiesErrorValue = propertiesErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static AlphaGetMetadataError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AlphaGetMetadataError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isPropertiesError() {
        return this._tag == Tag.PROPERTIES_ERROR;
    }

    public static AlphaGetMetadataError propertiesError(LookUpPropertiesError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AlphaGetMetadataError().withTagAndPropertiesError(Tag.PROPERTIES_ERROR, value);
    }

    public LookUpPropertiesError getPropertiesErrorValue() {
        if (this._tag != Tag.PROPERTIES_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.PROPERTIES_ERROR, but was Tag." + this._tag.name());
        }
        return this.propertiesErrorValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue, this.propertiesErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AlphaGetMetadataError) {
            AlphaGetMetadataError other = (AlphaGetMetadataError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case PROPERTIES_ERROR: {
                    return this.propertiesErrorValue == other.propertiesErrorValue || this.propertiesErrorValue.equals((Object)other.propertiesErrorValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<AlphaGetMetadataError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AlphaGetMetadataError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g2.writeStartObject();
                    this.writeTag("path", g2);
                    g2.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case PROPERTIES_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("properties_error", g2);
                    g2.writeFieldName("properties_error");
                    LookUpPropertiesError.Serializer.INSTANCE.serialize(value.propertiesErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public AlphaGetMetadataError deserialize(JsonParser p) throws IOException, JsonParseException {
            AlphaGetMetadataError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = AlphaGetMetadataError.path(fieldValue);
            } else if ("properties_error".equals(tag)) {
                LookUpPropertiesError fieldValue = null;
                Serializer.expectField("properties_error", p);
                fieldValue = LookUpPropertiesError.Serializer.INSTANCE.deserialize(p);
                value = AlphaGetMetadataError.propertiesError(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        PROPERTIES_ERROR;

    }
}

