/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public final class TemplateFilter {
    public static final TemplateFilter OTHER = new TemplateFilter().withTag(Tag.OTHER);
    public static final TemplateFilter FILTER_NONE = new TemplateFilter().withTag(Tag.FILTER_NONE);
    private Tag _tag;
    private List<String> filterSomeValue;

    private TemplateFilter() {
    }

    private TemplateFilter withTag(Tag _tag) {
        TemplateFilter result = new TemplateFilter();
        result._tag = _tag;
        return result;
    }

    private TemplateFilter withTagAndFilterSome(Tag _tag, List<String> filterSomeValue) {
        TemplateFilter result = new TemplateFilter();
        result._tag = _tag;
        result.filterSomeValue = filterSomeValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isFilterSome() {
        return this._tag == Tag.FILTER_SOME;
    }

    public static TemplateFilter filterSome(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.size() < 1) {
            throw new IllegalArgumentException("List has fewer than 1 items");
        }
        for (String x : value) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list is null");
            }
            if (x.length() < 1) {
                throw new IllegalArgumentException("Stringan item in list is shorter than 1");
            }
            if (Pattern.matches("(/|ptid:).*", x)) continue;
            throw new IllegalArgumentException("Stringan item in list does not match pattern");
        }
        return new TemplateFilter().withTagAndFilterSome(Tag.FILTER_SOME, value);
    }

    public List<String> getFilterSomeValue() {
        if (this._tag != Tag.FILTER_SOME) {
            throw new IllegalStateException("Invalid tag: required Tag.FILTER_SOME, but was Tag." + this._tag.name());
        }
        return this.filterSomeValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isFilterNone() {
        return this._tag == Tag.FILTER_NONE;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.filterSomeValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TemplateFilter) {
            TemplateFilter other = (TemplateFilter)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case FILTER_SOME: {
                    return this.filterSomeValue == other.filterSomeValue || this.filterSomeValue.equals(other.filterSomeValue);
                }
                case OTHER: {
                    return true;
                }
                case FILTER_NONE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TemplateFilter> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TemplateFilter value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case FILTER_SOME: {
                    g2.writeStartObject();
                    this.writeTag("filter_some", g2);
                    g2.writeFieldName("filter_some");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.filterSomeValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                case FILTER_NONE: {
                    g2.writeString("filter_none");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public TemplateFilter deserialize(JsonParser p) throws IOException, JsonParseException {
            TemplateFilter value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("filter_some".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("filter_some", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = TemplateFilter.filterSome(fieldValue);
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("filter_none".equals(tag)) {
                value = FILTER_NONE;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        FILTER_SOME,
        OTHER,
        FILTER_NONE;

    }
}

