/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class TemplateError {
    public static final TemplateError RESTRICTED_CONTENT = new TemplateError().withTag(Tag.RESTRICTED_CONTENT);
    public static final TemplateError OTHER = new TemplateError().withTag(Tag.OTHER);
    private Tag _tag;
    private String templateNotFoundValue;

    private TemplateError() {
    }

    private TemplateError withTag(Tag _tag) {
        TemplateError result = new TemplateError();
        result._tag = _tag;
        return result;
    }

    private TemplateError withTagAndTemplateNotFound(Tag _tag, String templateNotFoundValue) {
        TemplateError result = new TemplateError();
        result._tag = _tag;
        result.templateNotFoundValue = templateNotFoundValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTemplateNotFound() {
        return this._tag == Tag.TEMPLATE_NOT_FOUND;
    }

    public static TemplateError templateNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        if (!Pattern.matches("(/|ptid:).*", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new TemplateError().withTagAndTemplateNotFound(Tag.TEMPLATE_NOT_FOUND, value);
    }

    public String getTemplateNotFoundValue() {
        if (this._tag != Tag.TEMPLATE_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.TEMPLATE_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.templateNotFoundValue;
    }

    public boolean isRestrictedContent() {
        return this._tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.templateNotFoundValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TemplateError) {
            TemplateError other = (TemplateError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEMPLATE_NOT_FOUND: {
                    return this.templateNotFoundValue == other.templateNotFoundValue || this.templateNotFoundValue.equals(other.templateNotFoundValue);
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<TemplateError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(TemplateError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEMPLATE_NOT_FOUND: {
                    g2.writeStartObject();
                    this.writeTag("template_not_found", g2);
                    g2.writeFieldName("template_not_found");
                    StoneSerializers.string().serialize(value.templateNotFoundValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g2.writeString("restricted_content");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public TemplateError deserialize(JsonParser p) throws IOException, JsonParseException {
            TemplateError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("template_not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("template_not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = TemplateError.templateNotFound(fieldValue);
            } else {
                value = "restricted_content".equals(tag) ? RESTRICTED_CONTENT : OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEMPLATE_NOT_FOUND,
        RESTRICTED_CONTENT,
        OTHER;

    }
}

