/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.common;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.common.RootInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TeamRootInfo
extends RootInfo {
    protected final String homePath;

    public TeamRootInfo(String rootNamespaceId, String homeNamespaceId, String homePath) {
        super(rootNamespaceId, homeNamespaceId);
        if (homePath == null) {
            throw new IllegalArgumentException("Required value for 'homePath' is null");
        }
        this.homePath = homePath;
    }

    @Override
    public String getRootNamespaceId() {
        return this.rootNamespaceId;
    }

    @Override
    public String getHomeNamespaceId() {
        return this.homeNamespaceId;
    }

    public String getHomePath() {
        return this.homePath;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.homePath});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamRootInfo other = (TeamRootInfo)obj;
            return !(this.rootNamespaceId != other.rootNamespaceId && !this.rootNamespaceId.equals(other.rootNamespaceId) || this.homeNamespaceId != other.homeNamespaceId && !this.homeNamespaceId.equals(other.homeNamespaceId) || this.homePath != other.homePath && !this.homePath.equals(other.homePath));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamRootInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamRootInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            this.writeTag("team", g2);
            g2.writeFieldName("root_namespace_id");
            StoneSerializers.string().serialize(value.rootNamespaceId, g2);
            g2.writeFieldName("home_namespace_id");
            StoneSerializers.string().serialize(value.homeNamespaceId, g2);
            g2.writeFieldName("home_path");
            StoneSerializers.string().serialize(value.homePath, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public TeamRootInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_homePath;
            String f_homeNamespaceId;
            String f_rootNamespaceId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("team".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_rootNamespaceId = null;
                f_homeNamespaceId = null;
                f_homePath = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("root_namespace_id".equals(field)) {
                        f_rootNamespaceId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("home_namespace_id".equals(field)) {
                        f_homeNamespaceId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("home_path".equals(field)) {
                        f_homePath = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_rootNamespaceId == null) {
                    throw new JsonParseException(p, "Required field \"root_namespace_id\" missing.");
                }
                if (f_homeNamespaceId == null) {
                    throw new JsonParseException(p, "Required field \"home_namespace_id\" missing.");
                }
                if (f_homePath == null) {
                    throw new JsonParseException(p, "Required field \"home_path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamRootInfo value = new TeamRootInfo(f_rootNamespaceId, f_homeNamespaceId, f_homePath);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

