/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.clouddocs.UserInfo;
import com.dropbox.core.v2.clouddocs.UserPermissions;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class GetMetadataResult {
    protected final String fileId;
    protected final String title;
    protected final String mimeType;
    protected final String version;
    protected final String providerVersion;
    protected final UserInfo user;
    protected final boolean isDeleted;
    protected final UserPermissions userPermissions;

    public GetMetadataResult(String fileId, String title, String mimeType, String version, String providerVersion, UserInfo user, boolean isDeleted, UserPermissions userPermissions) {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        this.fileId = fileId;
        if (title == null) {
            throw new IllegalArgumentException("Required value for 'title' is null");
        }
        this.title = title;
        if (mimeType == null) {
            throw new IllegalArgumentException("Required value for 'mimeType' is null");
        }
        this.mimeType = mimeType;
        if (version == null) {
            throw new IllegalArgumentException("Required value for 'version' is null");
        }
        this.version = version;
        if (providerVersion == null) {
            throw new IllegalArgumentException("Required value for 'providerVersion' is null");
        }
        this.providerVersion = providerVersion;
        this.user = user;
        this.isDeleted = isDeleted;
        this.userPermissions = userPermissions;
    }

    public GetMetadataResult() {
        this("\"\"", "\"\"", "\"\"", "\"\"", "\"\"", null, false, null);
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProviderVersion() {
        return this.providerVersion;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public UserPermissions getUserPermissions() {
        return this.userPermissions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileId, this.title, this.mimeType, this.version, this.providerVersion, this.user, this.isDeleted, this.userPermissions});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetMetadataResult other = (GetMetadataResult)obj;
            return !(this.fileId != other.fileId && !this.fileId.equals(other.fileId) || this.title != other.title && !this.title.equals(other.title) || this.mimeType != other.mimeType && !this.mimeType.equals(other.mimeType) || this.version != other.version && !this.version.equals(other.version) || this.providerVersion != other.providerVersion && !this.providerVersion.equals(other.providerVersion) || this.user != other.user && (this.user == null || !this.user.equals(other.user)) || this.isDeleted != other.isDeleted || this.userPermissions != other.userPermissions && (this.userPermissions == null || !this.userPermissions.equals(other.userPermissions)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GetMetadataResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetMetadataResult value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("file_id");
            StoneSerializers.string().serialize(value.fileId, g2);
            g2.writeFieldName("title");
            StoneSerializers.string().serialize(value.title, g2);
            g2.writeFieldName("mime_type");
            StoneSerializers.string().serialize(value.mimeType, g2);
            g2.writeFieldName("version");
            StoneSerializers.string().serialize(value.version, g2);
            g2.writeFieldName("provider_version");
            StoneSerializers.string().serialize(value.providerVersion, g2);
            if (value.user != null) {
                g2.writeFieldName("user");
                StoneSerializers.nullableStruct(UserInfo.Serializer.INSTANCE).serialize(value.user, g2);
            }
            g2.writeFieldName("is_deleted");
            StoneSerializers.boolean_().serialize((Boolean)value.isDeleted, g2);
            if (value.userPermissions != null) {
                g2.writeFieldName("user_permissions");
                StoneSerializers.nullableStruct(UserPermissions.Serializer.INSTANCE).serialize(value.userPermissions, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public GetMetadataResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            UserPermissions f_userPermissions;
            Boolean f_isDeleted;
            UserInfo f_user;
            String f_providerVersion;
            String f_version;
            String f_mimeType;
            String f_title;
            String f_fileId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileId = "\"\"";
                f_title = "\"\"";
                f_mimeType = "\"\"";
                f_version = "\"\"";
                f_providerVersion = "\"\"";
                f_user = null;
                f_isDeleted = false;
                f_userPermissions = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("title".equals(field)) {
                        f_title = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("mime_type".equals(field)) {
                        f_mimeType = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("version".equals(field)) {
                        f_version = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("provider_version".equals(field)) {
                        f_providerVersion = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("user".equals(field)) {
                        f_user = StoneSerializers.nullableStruct(UserInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("is_deleted".equals(field)) {
                        f_isDeleted = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("user_permissions".equals(field)) {
                        f_userPermissions = StoneSerializers.nullableStruct(UserPermissions.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GetMetadataResult value = new GetMetadataResult(f_fileId, f_title, f_mimeType, f_version, f_providerVersion, f_user, f_isDeleted, f_userPermissions);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String fileId = "\"\"";
        protected String title = "\"\"";
        protected String mimeType = "\"\"";
        protected String version = "\"\"";
        protected String providerVersion = "\"\"";
        protected UserInfo user = null;
        protected boolean isDeleted = false;
        protected UserPermissions userPermissions = null;

        protected Builder() {
        }

        public Builder withFileId(String fileId) {
            this.fileId = fileId != null ? fileId : "\"\"";
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title != null ? title : "\"\"";
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType != null ? mimeType : "\"\"";
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version != null ? version : "\"\"";
            return this;
        }

        public Builder withProviderVersion(String providerVersion) {
            this.providerVersion = providerVersion != null ? providerVersion : "\"\"";
            return this;
        }

        public Builder withUser(UserInfo user) {
            this.user = user;
            return this;
        }

        public Builder withIsDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted != null ? isDeleted : false;
            return this;
        }

        public Builder withUserPermissions(UserPermissions userPermissions) {
            this.userPermissions = userPermissions;
            return this;
        }

        public GetMetadataResult build() {
            return new GetMetadataResult(this.fileId, this.title, this.mimeType, this.version, this.providerVersion, this.user, this.isDeleted, this.userPermissions);
        }
    }
}

