/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import okio.Okio;

final class OkHttpUtil {
    OkHttpUtil() {
    }

    public static void assertNotSameThreadExecutor(ExecutorService executor) {
        Thread executed;
        Thread current = Thread.currentThread();
        try {
            executed = executor.submit(new Callable<Thread>(){

                @Override
                public Thread call() {
                    return Thread.currentThread();
                }
            }).get(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ex) {
            current.interrupt();
            throw new IllegalArgumentException("Unable to verify OkHttp dispatcher executor.", ex);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to verify OkHttp dispatcher executor.", ex);
        }
        if (current.equals(executed)) {
            throw new IllegalArgumentException("OkHttp dispatcher uses same-thread executor. This is not supported by the SDK and may result in dead-locks. Please configure your Dispatcher to use an ExecutorService that runs tasks on separate threads.");
        }
    }

    public static final class PipedStream
    implements Closeable {
        private static final int BUFFER_SIZE = 0x500000;
        private final PipedInputStream in = new PipedInputStream(0x500000);
        private final PipedOutputStream out;

        public PipedStream() {
            try {
                this.out = new PipedOutputStream(this.in);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to create piped stream for async upload request.");
            }
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        @Override
        public void close() {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.writeAll(Okio.source(this.in));
        }
    }
}

