/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util;

import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.entities.Emoji;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.Button;
import net.dv8tion.jda.api.interactions.components.ButtonInteraction;

public class Paginator {
    private final List<Message> pages = new ArrayList<Message>();
    private final long messageId;
    private final long userId;
    private int index = 0;

    public Paginator(Message message) {
        this.messageId = message.getIdLong();
        this.userId = message.getAuthor().getIdLong();
    }

    public String getId() {
        return this.messageId + ":" + this.userId;
    }

    private boolean isEnd() {
        return this.index == this.pages.size() - 1;
    }

    private boolean isStart() {
        return this.index == 0;
    }

    private Message getNext() {
        return this.isEnd() ? this.pages.get(this.index) : this.pages.get(++this.index);
    }

    private Message getPrev() {
        return this.isStart() ? this.pages.get(0) : this.pages.get(--this.index);
    }

    public Message getCurrent() {
        return this.pages.get(this.index);
    }

    public Paginator addPage(Message page) {
        this.pages.add(page);
        return this;
    }

    public void onButtonClick(ButtonInteraction interaction) {
        String operation;
        if (interaction.getUser().getIdLong() != this.userId) {
            return;
        }
        String[] id = interaction.getComponentId().split(":");
        if (Long.parseUnsignedLong(id[0]) != this.messageId) {
            return;
        }
        switch (operation = id[2]) {
            case "next": {
                interaction.getHook().editOriginal(this.getNext()).setActionRows(this.getButtons()).queue();
                break;
            }
            case "prev": {
                interaction.getHook().editOriginal(this.getPrev()).setActionRows(this.getButtons()).queue();
                break;
            }
            case "delete": {
                interaction.getHook().deleteOriginal().queue();
            }
        }
    }

    private Button getNextButton() {
        return Button.secondary(this.getId() + ":next", Emoji.fromUnicode("\u27a1\ufe0f"));
    }

    private Button getPrevButton() {
        return Button.secondary(this.getId() + ":prev", Emoji.fromUnicode("\u2b05\ufe0f"));
    }

    private Button getDeleteButton() {
        return Button.danger(this.getId() + ":delete", Emoji.fromUnicode("\ud83d\udeae"));
    }

    public ActionRow getButtons() {
        return ActionRow.of(this.getPrevButton().withDisabled(this.isStart()), this.getNextButton().withDisabled(this.isEnd()), this.getDeleteButton());
    }
}

