/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.commands.ButtonListener;
import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.commands.ReactionListenerRegistry;
import com.almightyalpaca.discord.jdabutler.commands.commands.AnnouncementCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.BuildGradleCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.ChangelogCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.DocsCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.EvalCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.GradleCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.GradleProjectCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.GuildCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.HelpCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.MavenCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.MavenProjectCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.NotifyCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.PingCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.ShutdownCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.UpdateCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.UptimeCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.VersionsCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.moderation.SlowmodeCommand;
import com.almightyalpaca.discord.jdabutler.commands.commands.moderation.SoftbanCommand;
import com.almightyalpaca.discord.jdabutler.util.MiscUtils;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.events.ShutdownEvent;
import net.dv8tion.jda.api.events.interaction.ButtonClickEvent;
import net.dv8tion.jda.api.events.message.guild.GuildMessageDeleteEvent;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.jetbrains.annotations.NotNull;

public class Dispatcher
extends ListenerAdapter {
    private final Set<Command> commands = ConcurrentHashMap.newKeySet();
    private final ExecutorService pool = Executors.newCachedThreadPool(MiscUtils.newThreadFactory("command-runner", false));
    private final ReactionListenerRegistry reactListReg = new ReactionListenerRegistry();
    private final ButtonListener buttonListener = new ButtonListener();

    public Dispatcher() {
        this.registerCommand(new BuildGradleCommand());
        this.registerCommand(new ChangelogCommand());
        this.registerCommand(new DocsCommand(this.reactListReg, this.buttonListener));
        this.registerCommand(new EvalCommand());
        this.registerCommand(new GradleCommand());
        this.registerCommand(new GradleProjectCommand());
        this.registerCommand(new GuildCommand());
        this.registerCommand(new HelpCommand());
        this.registerCommand(new MavenCommand());
        this.registerCommand(new MavenProjectCommand());
        this.registerCommand(new NotifyCommand());
        this.registerCommand(new PingCommand());
        this.registerCommand(new ShutdownCommand());
        this.registerCommand(new UptimeCommand());
        this.registerCommand(new VersionsCommand());
        this.registerCommand(new AnnouncementCommand());
        this.registerCommand(new SoftbanCommand());
        this.registerCommand(new SlowmodeCommand());
        this.registerCommand(new UpdateCommand());
    }

    public Set<Command> getCommands() {
        return Collections.unmodifiableSet(new HashSet<Command>(this.commands));
    }

    @Override
    public void onButtonClick(@NotNull ButtonClickEvent event) {
        this.buttonListener.onEvent(event);
    }

    @Override
    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        TextChannel channel;
        if (event.getAuthor().isBot()) {
            return;
        }
        String prefix = Bot.config.getString("prefix");
        String message = event.getMessage().getContentRaw();
        if (Bot.isStealth) {
            if (message.startsWith(prefix) && message.startsWith("fake", prefix.length())) {
                message = prefix + message.substring(prefix.length() + 4);
            } else {
                return;
            }
        }
        if ((channel = event.getChannel()).getGuild().getIdLong() == 81384788765712384L && channel.getIdLong() != 381889648827301889L && (channel.getParent() == null || channel.getParent().getIdLong() != 356505966201798656L)) {
            return;
        }
        if (message.toLowerCase().startsWith(prefix.toLowerCase())) {
            for (Command c : this.getCommands()) {
                if (message.toLowerCase().startsWith(prefix.toLowerCase() + c.getName().toLowerCase() + ' ') || message.equalsIgnoreCase(prefix + c.getName())) {
                    this.executeCommand(c, c.getName(), prefix, message, event);
                    return;
                }
                for (String alias : c.getAliases()) {
                    if (!message.toLowerCase().startsWith(prefix.toLowerCase() + alias.toLowerCase() + ' ') && !message.equalsIgnoreCase(prefix + alias)) continue;
                    this.executeCommand(c, alias, prefix, message, event);
                    return;
                }
            }
        }
    }

    @Override
    public void onGuildMessageDelete(GuildMessageDeleteEvent event) {
        Command.removeResponses(event.getChannel(), event.getMessageIdLong(), this.reactListReg);
    }

    @Override
    public void onMessageReactionAdd(@Nonnull MessageReactionAddEvent event) {
        this.reactListReg.handle(event);
    }

    @Override
    public void onShutdown(@Nonnull ShutdownEvent event) {
        MoreExecutors.shutdownAndAwaitTermination(this.pool, 10L, TimeUnit.SECONDS);
    }

    public boolean registerCommand(Command command) {
        if (command.getName().contains(" ")) {
            throw new IllegalArgumentException("Name must not have spaces!");
        }
        if (this.commands.stream().map(Command::getName).anyMatch(c -> command.getName().equalsIgnoreCase((String)c))) {
            return false;
        }
        this.commands.add(command);
        return true;
    }

    private void executeCommand(Command c, String alias, String prefix, String message, GuildMessageReceivedEvent event) {
        this.pool.submit(() -> {
            try {
                String content = this.removePrefix(alias, prefix, message);
                Bot.LOG.info("Dispatching command '" + c.getName().toLowerCase() + "' with: " + content);
                c.dispatch(event.getAuthor(), event.getChannel(), event.getMessage(), content, event);
            }
            catch (Exception e) {
                event.getChannel().sendMessage("**There was an error processing your command!**").queue(msg -> Command.linkMessage(event.getMessageIdLong(), msg.getIdLong()));
                Bot.LOG.error("Error processing command {}", (Object)c.getName(), (Object)e);
            }
        });
    }

    private String removePrefix(String commandName, String prefix, String content) {
        if ((content = content.substring(commandName.length() + prefix.length())).startsWith(" ")) {
            content = content.substring(1);
        }
        return content;
    }
}

