/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.util.MarkdownTable;
import com.overzealous.remark.util.MarkdownTableCell;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;

public class Table
extends AbstractNodeHandler {
    private int maxRowCells;
    private boolean hasHeader;
    private static final Pattern STYLE_ALIGNMENT_PATTERN = Pattern.compile("text-align:\\s*([a-z]+)", 2);

    @Override
    public void handleNode(NodeHandler parent, Element node, DocumentConverter converter) {
        MarkdownTable table = new MarkdownTable();
        this.hasHeader = false;
        this.maxRowCells = 0;
        this.processTable(table, node, converter);
        if (!this.hasHeader) {
            this.insertEmptyRow(table.addHeaderRow(), this.maxRowCells);
        }
        Options.Tables opts = converter.options.getTables();
        converter.output.startBlock();
        table.renderTable(converter.output, opts.isColspanEnabled(), opts.isRenderedAsCode());
        converter.output.endBlock();
    }

    private void processTable(MarkdownTable table, Element node, DocumentConverter converter) {
        for (Element child : node.children()) {
            String childTagName = child.tagName();
            if (childTagName.equals("thead")) {
                this.hasHeader = true;
                for (Element headerRow : child.children()) {
                    this.processRow(table.addHeaderRow(), headerRow, converter);
                }
                continue;
            }
            if (childTagName.equals("tbody") || childTagName.equals("tfoot")) {
                this.processTable(table, child, converter);
                continue;
            }
            if (!childTagName.equals("tr") || child.children().isEmpty()) continue;
            if (((Element)child.children().get(0)).tagName().equals("th")) {
                if (this.hasHeader) {
                    this.processRow(table.addBodyRow(), child, converter);
                    continue;
                }
                this.hasHeader = true;
                this.processRow(table.addHeaderRow(), child, converter);
                continue;
            }
            this.updateMaxRowCells(child);
            this.processRow(table.addBodyRow(), child, converter);
        }
    }

    private void processRow(List<MarkdownTableCell> row, Element tableRow, DocumentConverter converter) {
        for (Element cell : tableRow.children()) {
            String contents = converter.getInlineContent(this, cell, true);
            row.add(new MarkdownTableCell(contents, this.getAlignment(cell), this.getColspan(cell)));
        }
    }

    private void insertEmptyRow(List<MarkdownTableCell> row, int numberOfCells) {
        for (int i = 0; i < numberOfCells; ++i) {
            row.add(new MarkdownTableCell("", MarkdownTable.Alignment.LEFT));
        }
    }

    private MarkdownTable.Alignment getAlignment(Element cell) {
        Matcher m3;
        MarkdownTable.Alignment alignment = MarkdownTable.Alignment.LEFT;
        String alignmentString = null;
        if (cell.hasAttr("align")) {
            alignmentString = cell.attr("align").toLowerCase();
        } else if (cell.hasAttr("style") && (m3 = STYLE_ALIGNMENT_PATTERN.matcher(cell.attr("style"))).find()) {
            alignmentString = m3.group(1).toLowerCase();
        }
        if (alignmentString != null) {
            if (alignmentString.equals("center")) {
                alignment = MarkdownTable.Alignment.CENTER;
            } else if (alignmentString.equals("right")) {
                alignment = MarkdownTable.Alignment.RIGHT;
            }
        }
        return alignment;
    }

    private int getColspan(Element cell) {
        int colspan = 1;
        if (cell.hasAttr("colspan")) {
            try {
                colspan = Integer.parseInt(cell.attr("colspan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return colspan;
    }

    private void updateMaxRowCells(Element row) {
        int currentRowCells = row.children().size();
        if (currentRowCells > this.maxRowCells) {
            this.maxRowCells = currentRowCells;
        }
    }
}

