/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.NonTeamMemberLogInfo;
import com.dropbox.core.v2.teamlog.TeamMemberLogInfo;
import com.dropbox.core.v2.teamlog.TrustedNonTeamMemberLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UserLogInfo {
    protected final String accountId;
    protected final String displayName;
    protected final String email;

    public UserLogInfo(String accountId, String displayName, String email) {
        if (accountId != null) {
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
        }
        this.accountId = accountId;
        this.displayName = displayName;
        if (email != null && email.length() > 255) {
            throw new IllegalArgumentException("String 'email' is longer than 255");
        }
        this.email = email;
    }

    public UserLogInfo() {
        this(null, null, null);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accountId, this.displayName, this.email});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserLogInfo other = (UserLogInfo)obj;
            return (this.accountId == other.accountId || this.accountId != null && this.accountId.equals(other.accountId)) && (this.displayName == other.displayName || this.displayName != null && this.displayName.equals(other.displayName)) && (this.email == other.email || this.email != null && this.email.equals(other.email));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserLogInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof TeamMemberLogInfo) {
                TeamMemberLogInfo.Serializer.INSTANCE.serialize((TeamMemberLogInfo)value, g2, collapse);
                return;
            }
            if (value instanceof TrustedNonTeamMemberLogInfo) {
                TrustedNonTeamMemberLogInfo.Serializer.INSTANCE.serialize((TrustedNonTeamMemberLogInfo)value, g2, collapse);
                return;
            }
            if (value instanceof NonTeamMemberLogInfo) {
                NonTeamMemberLogInfo.Serializer.INSTANCE.serialize((NonTeamMemberLogInfo)value, g2, collapse);
                return;
            }
            if (!collapse) {
                g2.writeStartObject();
            }
            if (value.accountId != null) {
                g2.writeFieldName("account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.accountId, g2);
            }
            if (value.displayName != null) {
                g2.writeFieldName("display_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.displayName, g2);
            }
            if (value.email != null) {
                g2.writeFieldName("email");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.email, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public UserLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            UserLogInfo value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                String f_accountId = null;
                String f_displayName = null;
                String f_email = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                value = new UserLogInfo(f_accountId, f_displayName, f_email);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("team_member".equals(tag)) {
                value = TeamMemberLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("trusted_non_team_member".equals(tag)) {
                value = TrustedNonTeamMemberLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("non_team_member".equals(tag)) {
                value = NonTeamMemberLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String accountId = null;
        protected String displayName = null;
        protected String email = null;

        protected Builder() {
        }

        public Builder withAccountId(String accountId) {
            if (accountId != null) {
                if (accountId.length() < 40) {
                    throw new IllegalArgumentException("String 'accountId' is shorter than 40");
                }
                if (accountId.length() > 40) {
                    throw new IllegalArgumentException("String 'accountId' is longer than 40");
                }
            }
            this.accountId = accountId;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withEmail(String email) {
            if (email != null && email.length() > 255) {
                throw new IllegalArgumentException("String 'email' is longer than 255");
            }
            this.email = email;
            return this;
        }

        public UserLogInfo build() {
            return new UserLogInfo(this.accountId, this.displayName, this.email);
        }
    }
}

