/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.GroupFullInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class GroupMembersChangeResult {
    protected final GroupFullInfo groupInfo;
    protected final String asyncJobId;

    public GroupMembersChangeResult(GroupFullInfo groupInfo, String asyncJobId) {
        if (groupInfo == null) {
            throw new IllegalArgumentException("Required value for 'groupInfo' is null");
        }
        this.groupInfo = groupInfo;
        if (asyncJobId == null) {
            throw new IllegalArgumentException("Required value for 'asyncJobId' is null");
        }
        if (asyncJobId.length() < 1) {
            throw new IllegalArgumentException("String 'asyncJobId' is shorter than 1");
        }
        this.asyncJobId = asyncJobId;
    }

    public GroupFullInfo getGroupInfo() {
        return this.groupInfo;
    }

    public String getAsyncJobId() {
        return this.asyncJobId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groupInfo, this.asyncJobId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupMembersChangeResult other = (GroupMembersChangeResult)obj;
            return !(this.groupInfo != other.groupInfo && !this.groupInfo.equals(other.groupInfo) || this.asyncJobId != other.asyncJobId && !this.asyncJobId.equals(other.asyncJobId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupMembersChangeResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupMembersChangeResult value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("group_info");
            GroupFullInfo.Serializer.INSTANCE.serialize(value.groupInfo, g2);
            g2.writeFieldName("async_job_id");
            StoneSerializers.string().serialize(value.asyncJobId, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public GroupMembersChangeResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_asyncJobId;
            GroupFullInfo f_groupInfo;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_groupInfo = null;
                f_asyncJobId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group_info".equals(field)) {
                        f_groupInfo = (GroupFullInfo)GroupFullInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("async_job_id".equals(field)) {
                        f_asyncJobId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_groupInfo == null) {
                    throw new JsonParseException(p, "Required field \"group_info\" missing.");
                }
                if (f_asyncJobId == null) {
                    throw new JsonParseException(p, "Required field \"async_job_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupMembersChangeResult value = new GroupMembersChangeResult(f_groupInfo, f_asyncJobId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

