/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.files.MoveIntoVaultError;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class RelocationError {
    public static final RelocationError CANT_COPY_SHARED_FOLDER = new RelocationError().withTag(Tag.CANT_COPY_SHARED_FOLDER);
    public static final RelocationError CANT_NEST_SHARED_FOLDER = new RelocationError().withTag(Tag.CANT_NEST_SHARED_FOLDER);
    public static final RelocationError CANT_MOVE_FOLDER_INTO_ITSELF = new RelocationError().withTag(Tag.CANT_MOVE_FOLDER_INTO_ITSELF);
    public static final RelocationError TOO_MANY_FILES = new RelocationError().withTag(Tag.TOO_MANY_FILES);
    public static final RelocationError DUPLICATED_OR_NESTED_PATHS = new RelocationError().withTag(Tag.DUPLICATED_OR_NESTED_PATHS);
    public static final RelocationError CANT_TRANSFER_OWNERSHIP = new RelocationError().withTag(Tag.CANT_TRANSFER_OWNERSHIP);
    public static final RelocationError INSUFFICIENT_QUOTA = new RelocationError().withTag(Tag.INSUFFICIENT_QUOTA);
    public static final RelocationError INTERNAL_ERROR = new RelocationError().withTag(Tag.INTERNAL_ERROR);
    public static final RelocationError CANT_MOVE_SHARED_FOLDER = new RelocationError().withTag(Tag.CANT_MOVE_SHARED_FOLDER);
    public static final RelocationError OTHER = new RelocationError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError fromLookupValue;
    private WriteError fromWriteValue;
    private WriteError toValue;
    private MoveIntoVaultError cantMoveIntoVaultValue;

    private RelocationError() {
    }

    private RelocationError withTag(Tag _tag) {
        RelocationError result = new RelocationError();
        result._tag = _tag;
        return result;
    }

    private RelocationError withTagAndFromLookup(Tag _tag, LookupError fromLookupValue) {
        RelocationError result = new RelocationError();
        result._tag = _tag;
        result.fromLookupValue = fromLookupValue;
        return result;
    }

    private RelocationError withTagAndFromWrite(Tag _tag, WriteError fromWriteValue) {
        RelocationError result = new RelocationError();
        result._tag = _tag;
        result.fromWriteValue = fromWriteValue;
        return result;
    }

    private RelocationError withTagAndTo(Tag _tag, WriteError toValue) {
        RelocationError result = new RelocationError();
        result._tag = _tag;
        result.toValue = toValue;
        return result;
    }

    private RelocationError withTagAndCantMoveIntoVault(Tag _tag, MoveIntoVaultError cantMoveIntoVaultValue) {
        RelocationError result = new RelocationError();
        result._tag = _tag;
        result.cantMoveIntoVaultValue = cantMoveIntoVaultValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isFromLookup() {
        return this._tag == Tag.FROM_LOOKUP;
    }

    public static RelocationError fromLookup(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationError().withTagAndFromLookup(Tag.FROM_LOOKUP, value);
    }

    public LookupError getFromLookupValue() {
        if (this._tag != Tag.FROM_LOOKUP) {
            throw new IllegalStateException("Invalid tag: required Tag.FROM_LOOKUP, but was Tag." + this._tag.name());
        }
        return this.fromLookupValue;
    }

    public boolean isFromWrite() {
        return this._tag == Tag.FROM_WRITE;
    }

    public static RelocationError fromWrite(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationError().withTagAndFromWrite(Tag.FROM_WRITE, value);
    }

    public WriteError getFromWriteValue() {
        if (this._tag != Tag.FROM_WRITE) {
            throw new IllegalStateException("Invalid tag: required Tag.FROM_WRITE, but was Tag." + this._tag.name());
        }
        return this.fromWriteValue;
    }

    public boolean isTo() {
        return this._tag == Tag.TO;
    }

    public static RelocationError to(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationError().withTagAndTo(Tag.TO, value);
    }

    public WriteError getToValue() {
        if (this._tag != Tag.TO) {
            throw new IllegalStateException("Invalid tag: required Tag.TO, but was Tag." + this._tag.name());
        }
        return this.toValue;
    }

    public boolean isCantCopySharedFolder() {
        return this._tag == Tag.CANT_COPY_SHARED_FOLDER;
    }

    public boolean isCantNestSharedFolder() {
        return this._tag == Tag.CANT_NEST_SHARED_FOLDER;
    }

    public boolean isCantMoveFolderIntoItself() {
        return this._tag == Tag.CANT_MOVE_FOLDER_INTO_ITSELF;
    }

    public boolean isTooManyFiles() {
        return this._tag == Tag.TOO_MANY_FILES;
    }

    public boolean isDuplicatedOrNestedPaths() {
        return this._tag == Tag.DUPLICATED_OR_NESTED_PATHS;
    }

    public boolean isCantTransferOwnership() {
        return this._tag == Tag.CANT_TRANSFER_OWNERSHIP;
    }

    public boolean isInsufficientQuota() {
        return this._tag == Tag.INSUFFICIENT_QUOTA;
    }

    public boolean isInternalError() {
        return this._tag == Tag.INTERNAL_ERROR;
    }

    public boolean isCantMoveSharedFolder() {
        return this._tag == Tag.CANT_MOVE_SHARED_FOLDER;
    }

    public boolean isCantMoveIntoVault() {
        return this._tag == Tag.CANT_MOVE_INTO_VAULT;
    }

    public static RelocationError cantMoveIntoVault(MoveIntoVaultError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationError().withTagAndCantMoveIntoVault(Tag.CANT_MOVE_INTO_VAULT, value);
    }

    public MoveIntoVaultError getCantMoveIntoVaultValue() {
        if (this._tag != Tag.CANT_MOVE_INTO_VAULT) {
            throw new IllegalStateException("Invalid tag: required Tag.CANT_MOVE_INTO_VAULT, but was Tag." + this._tag.name());
        }
        return this.cantMoveIntoVaultValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.fromLookupValue, this.fromWriteValue, this.toValue, this.cantMoveIntoVaultValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RelocationError) {
            RelocationError other = (RelocationError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case FROM_LOOKUP: {
                    return this.fromLookupValue == other.fromLookupValue || this.fromLookupValue.equals(other.fromLookupValue);
                }
                case FROM_WRITE: {
                    return this.fromWriteValue == other.fromWriteValue || this.fromWriteValue.equals(other.fromWriteValue);
                }
                case TO: {
                    return this.toValue == other.toValue || this.toValue.equals(other.toValue);
                }
                case CANT_COPY_SHARED_FOLDER: {
                    return true;
                }
                case CANT_NEST_SHARED_FOLDER: {
                    return true;
                }
                case CANT_MOVE_FOLDER_INTO_ITSELF: {
                    return true;
                }
                case TOO_MANY_FILES: {
                    return true;
                }
                case DUPLICATED_OR_NESTED_PATHS: {
                    return true;
                }
                case CANT_TRANSFER_OWNERSHIP: {
                    return true;
                }
                case INSUFFICIENT_QUOTA: {
                    return true;
                }
                case INTERNAL_ERROR: {
                    return true;
                }
                case CANT_MOVE_SHARED_FOLDER: {
                    return true;
                }
                case CANT_MOVE_INTO_VAULT: {
                    return this.cantMoveIntoVaultValue == other.cantMoveIntoVaultValue || this.cantMoveIntoVaultValue.equals((Object)other.cantMoveIntoVaultValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<RelocationError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RelocationError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case FROM_LOOKUP: {
                    g2.writeStartObject();
                    this.writeTag("from_lookup", g2);
                    g2.writeFieldName("from_lookup");
                    LookupError.Serializer.INSTANCE.serialize(value.fromLookupValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case FROM_WRITE: {
                    g2.writeStartObject();
                    this.writeTag("from_write", g2);
                    g2.writeFieldName("from_write");
                    WriteError.Serializer.INSTANCE.serialize(value.fromWriteValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case TO: {
                    g2.writeStartObject();
                    this.writeTag("to", g2);
                    g2.writeFieldName("to");
                    WriteError.Serializer.INSTANCE.serialize(value.toValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case CANT_COPY_SHARED_FOLDER: {
                    g2.writeString("cant_copy_shared_folder");
                    break;
                }
                case CANT_NEST_SHARED_FOLDER: {
                    g2.writeString("cant_nest_shared_folder");
                    break;
                }
                case CANT_MOVE_FOLDER_INTO_ITSELF: {
                    g2.writeString("cant_move_folder_into_itself");
                    break;
                }
                case TOO_MANY_FILES: {
                    g2.writeString("too_many_files");
                    break;
                }
                case DUPLICATED_OR_NESTED_PATHS: {
                    g2.writeString("duplicated_or_nested_paths");
                    break;
                }
                case CANT_TRANSFER_OWNERSHIP: {
                    g2.writeString("cant_transfer_ownership");
                    break;
                }
                case INSUFFICIENT_QUOTA: {
                    g2.writeString("insufficient_quota");
                    break;
                }
                case INTERNAL_ERROR: {
                    g2.writeString("internal_error");
                    break;
                }
                case CANT_MOVE_SHARED_FOLDER: {
                    g2.writeString("cant_move_shared_folder");
                    break;
                }
                case CANT_MOVE_INTO_VAULT: {
                    g2.writeStartObject();
                    this.writeTag("cant_move_into_vault", g2);
                    g2.writeFieldName("cant_move_into_vault");
                    MoveIntoVaultError.Serializer.INSTANCE.serialize(value.cantMoveIntoVaultValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public RelocationError deserialize(JsonParser p) throws IOException, JsonParseException {
            RelocationError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("from_lookup".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("from_lookup", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = RelocationError.fromLookup(fieldValue);
            } else if ("from_write".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("from_write", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = RelocationError.fromWrite(fieldValue);
            } else if ("to".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("to", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = RelocationError.to(fieldValue);
            } else if ("cant_copy_shared_folder".equals(tag)) {
                value = CANT_COPY_SHARED_FOLDER;
            } else if ("cant_nest_shared_folder".equals(tag)) {
                value = CANT_NEST_SHARED_FOLDER;
            } else if ("cant_move_folder_into_itself".equals(tag)) {
                value = CANT_MOVE_FOLDER_INTO_ITSELF;
            } else if ("too_many_files".equals(tag)) {
                value = TOO_MANY_FILES;
            } else if ("duplicated_or_nested_paths".equals(tag)) {
                value = DUPLICATED_OR_NESTED_PATHS;
            } else if ("cant_transfer_ownership".equals(tag)) {
                value = CANT_TRANSFER_OWNERSHIP;
            } else if ("insufficient_quota".equals(tag)) {
                value = INSUFFICIENT_QUOTA;
            } else if ("internal_error".equals(tag)) {
                value = INTERNAL_ERROR;
            } else if ("cant_move_shared_folder".equals(tag)) {
                value = CANT_MOVE_SHARED_FOLDER;
            } else if ("cant_move_into_vault".equals(tag)) {
                MoveIntoVaultError fieldValue = null;
                Serializer.expectField("cant_move_into_vault", p);
                fieldValue = MoveIntoVaultError.Serializer.INSTANCE.deserialize(p);
                value = RelocationError.cantMoveIntoVault(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        FROM_LOOKUP,
        FROM_WRITE,
        TO,
        CANT_COPY_SHARED_FOLDER,
        CANT_NEST_SHARED_FOLDER,
        CANT_MOVE_FOLDER_INTO_ITSELF,
        TOO_MANY_FILES,
        DUPLICATED_OR_NESTED_PATHS,
        CANT_TRANSFER_OWNERSHIP,
        INSUFFICIENT_QUOTA,
        INTERNAL_ERROR,
        CANT_MOVE_SHARED_FOLDER,
        CANT_MOVE_INTO_VAULT,
        OTHER;

    }
}

