/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.Metadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class MetadataV2 {
    public static final MetadataV2 OTHER = new MetadataV2().withTag(Tag.OTHER);
    private Tag _tag;
    private Metadata metadataValue;

    private MetadataV2() {
    }

    private MetadataV2 withTag(Tag _tag) {
        MetadataV2 result = new MetadataV2();
        result._tag = _tag;
        return result;
    }

    private MetadataV2 withTagAndMetadata(Tag _tag, Metadata metadataValue) {
        MetadataV2 result = new MetadataV2();
        result._tag = _tag;
        result.metadataValue = metadataValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMetadata() {
        return this._tag == Tag.METADATA;
    }

    public static MetadataV2 metadata(Metadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MetadataV2().withTagAndMetadata(Tag.METADATA, value);
    }

    public Metadata getMetadataValue() {
        if (this._tag != Tag.METADATA) {
            throw new IllegalStateException("Invalid tag: required Tag.METADATA, but was Tag." + this._tag.name());
        }
        return this.metadataValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.metadataValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MetadataV2) {
            MetadataV2 other = (MetadataV2)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case METADATA: {
                    return this.metadataValue == other.metadataValue || this.metadataValue.equals(other.metadataValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MetadataV2> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MetadataV2 value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case METADATA: {
                    g2.writeStartObject();
                    this.writeTag("metadata", g2);
                    g2.writeFieldName("metadata");
                    Metadata.Serializer.INSTANCE.serialize(value.metadataValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public MetadataV2 deserialize(JsonParser p) throws IOException, JsonParseException {
            MetadataV2 value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("metadata".equals(tag)) {
                Metadata fieldValue = null;
                Serializer.expectField("metadata", p);
                fieldValue = (Metadata)Metadata.Serializer.INSTANCE.deserialize(p);
                value = MetadataV2.metadata(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        METADATA,
        OTHER;

    }
}

