/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class GroupSelector {
    private Tag _tag;
    private String groupIdValue;
    private String groupExternalIdValue;

    private GroupSelector() {
    }

    private GroupSelector withTag(Tag _tag) {
        GroupSelector result = new GroupSelector();
        result._tag = _tag;
        return result;
    }

    private GroupSelector withTagAndGroupId(Tag _tag, String groupIdValue) {
        GroupSelector result = new GroupSelector();
        result._tag = _tag;
        result.groupIdValue = groupIdValue;
        return result;
    }

    private GroupSelector withTagAndGroupExternalId(Tag _tag, String groupExternalIdValue) {
        GroupSelector result = new GroupSelector();
        result._tag = _tag;
        result.groupExternalIdValue = groupExternalIdValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isGroupId() {
        return this._tag == Tag.GROUP_ID;
    }

    public static GroupSelector groupId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GroupSelector().withTagAndGroupId(Tag.GROUP_ID, value);
    }

    public String getGroupIdValue() {
        if (this._tag != Tag.GROUP_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_ID, but was Tag." + this._tag.name());
        }
        return this.groupIdValue;
    }

    public boolean isGroupExternalId() {
        return this._tag == Tag.GROUP_EXTERNAL_ID;
    }

    public static GroupSelector groupExternalId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GroupSelector().withTagAndGroupExternalId(Tag.GROUP_EXTERNAL_ID, value);
    }

    public String getGroupExternalIdValue() {
        if (this._tag != Tag.GROUP_EXTERNAL_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_EXTERNAL_ID, but was Tag." + this._tag.name());
        }
        return this.groupExternalIdValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.groupIdValue, this.groupExternalIdValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GroupSelector) {
            GroupSelector other = (GroupSelector)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case GROUP_ID: {
                    return this.groupIdValue == other.groupIdValue || this.groupIdValue.equals(other.groupIdValue);
                }
                case GROUP_EXTERNAL_ID: {
                    return this.groupExternalIdValue == other.groupExternalIdValue || this.groupExternalIdValue.equals(other.groupExternalIdValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GroupSelector> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupSelector value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case GROUP_ID: {
                    g2.writeStartObject();
                    this.writeTag("group_id", g2);
                    g2.writeFieldName("group_id");
                    StoneSerializers.string().serialize(value.groupIdValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case GROUP_EXTERNAL_ID: {
                    g2.writeStartObject();
                    this.writeTag("group_external_id", g2);
                    g2.writeFieldName("group_external_id");
                    StoneSerializers.string().serialize(value.groupExternalIdValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public GroupSelector deserialize(JsonParser p) throws IOException, JsonParseException {
            GroupSelector value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("group_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("group_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = GroupSelector.groupId(fieldValue);
            } else if ("group_external_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("group_external_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = GroupSelector.groupExternalId(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        GROUP_ID,
        GROUP_EXTERNAL_ID;

    }
}

