/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.LinkPermissions;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import com.dropbox.core.v2.sharing.TeamMemberInfo;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;

public class FileLinkMetadata
extends SharedLinkMetadata {
    protected final Date clientModified;
    protected final Date serverModified;
    protected final String rev;
    protected final long size;

    public FileLinkMetadata(String url, String name, LinkPermissions linkPermissions, Date clientModified, Date serverModified, String rev, long size, String id, Date expires, String pathLower, TeamMemberInfo teamMemberInfo, Team contentOwnerTeamInfo) {
        super(url, name, linkPermissions, id, expires, pathLower, teamMemberInfo, contentOwnerTeamInfo);
        if (clientModified == null) {
            throw new IllegalArgumentException("Required value for 'clientModified' is null");
        }
        this.clientModified = LangUtil.truncateMillis(clientModified);
        if (serverModified == null) {
            throw new IllegalArgumentException("Required value for 'serverModified' is null");
        }
        this.serverModified = LangUtil.truncateMillis(serverModified);
        if (rev == null) {
            throw new IllegalArgumentException("Required value for 'rev' is null");
        }
        if (rev.length() < 9) {
            throw new IllegalArgumentException("String 'rev' is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", rev)) {
            throw new IllegalArgumentException("String 'rev' does not match pattern");
        }
        this.rev = rev;
        this.size = size;
    }

    public FileLinkMetadata(String url, String name, LinkPermissions linkPermissions, Date clientModified, Date serverModified, String rev, long size) {
        this(url, name, linkPermissions, clientModified, serverModified, rev, size, null, null, null, null, null);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LinkPermissions getLinkPermissions() {
        return this.linkPermissions;
    }

    public Date getClientModified() {
        return this.clientModified;
    }

    public Date getServerModified() {
        return this.serverModified;
    }

    public String getRev() {
        return this.rev;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getExpires() {
        return this.expires;
    }

    @Override
    public String getPathLower() {
        return this.pathLower;
    }

    @Override
    public TeamMemberInfo getTeamMemberInfo() {
        return this.teamMemberInfo;
    }

    @Override
    public Team getContentOwnerTeamInfo() {
        return this.contentOwnerTeamInfo;
    }

    public static Builder newBuilder(String url, String name, LinkPermissions linkPermissions, Date clientModified, Date serverModified, String rev, long size) {
        return new Builder(url, name, linkPermissions, clientModified, serverModified, rev, size);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.clientModified, this.serverModified, this.rev, this.size});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileLinkMetadata other = (FileLinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.name != other.name && !this.name.equals(other.name) || this.linkPermissions != other.linkPermissions && !this.linkPermissions.equals(other.linkPermissions) || this.clientModified != other.clientModified && !this.clientModified.equals(other.clientModified) || this.serverModified != other.serverModified && !this.serverModified.equals(other.serverModified) || this.rev != other.rev && !this.rev.equals(other.rev) || this.size != other.size || this.id != other.id && (this.id == null || !this.id.equals(other.id)) || this.expires != other.expires && (this.expires == null || !this.expires.equals(other.expires)) || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.teamMemberInfo != other.teamMemberInfo && (this.teamMemberInfo == null || !this.teamMemberInfo.equals(other.teamMemberInfo)) || this.contentOwnerTeamInfo != other.contentOwnerTeamInfo && (this.contentOwnerTeamInfo == null || !this.contentOwnerTeamInfo.equals(other.contentOwnerTeamInfo)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileLinkMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileLinkMetadata value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            this.writeTag("file", g2);
            g2.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g2);
            g2.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g2);
            g2.writeFieldName("link_permissions");
            LinkPermissions.Serializer.INSTANCE.serialize(value.linkPermissions, g2);
            g2.writeFieldName("client_modified");
            StoneSerializers.timestamp().serialize(value.clientModified, g2);
            g2.writeFieldName("server_modified");
            StoneSerializers.timestamp().serialize(value.serverModified, g2);
            g2.writeFieldName("rev");
            StoneSerializers.string().serialize(value.rev, g2);
            g2.writeFieldName("size");
            StoneSerializers.uInt64().serialize((Long)value.size, g2);
            if (value.id != null) {
                g2.writeFieldName("id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.id, g2);
            }
            if (value.expires != null) {
                g2.writeFieldName("expires");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expires, g2);
            }
            if (value.pathLower != null) {
                g2.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g2);
            }
            if (value.teamMemberInfo != null) {
                g2.writeFieldName("team_member_info");
                StoneSerializers.nullableStruct(TeamMemberInfo.Serializer.INSTANCE).serialize(value.teamMemberInfo, g2);
            }
            if (value.contentOwnerTeamInfo != null) {
                g2.writeFieldName("content_owner_team_info");
                StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).serialize(value.contentOwnerTeamInfo, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public FileLinkMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Team f_contentOwnerTeamInfo;
            TeamMemberInfo f_teamMemberInfo;
            String f_pathLower;
            Date f_expires;
            String f_id;
            Long f_size;
            String f_rev;
            Date f_serverModified;
            Date f_clientModified;
            LinkPermissions f_linkPermissions;
            String f_name;
            String f_url;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("file".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_url = null;
                f_name = null;
                f_linkPermissions = null;
                f_clientModified = null;
                f_serverModified = null;
                f_rev = null;
                f_size = null;
                f_id = null;
                f_expires = null;
                f_pathLower = null;
                f_teamMemberInfo = null;
                f_contentOwnerTeamInfo = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("link_permissions".equals(field)) {
                        f_linkPermissions = (LinkPermissions)LinkPermissions.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("client_modified".equals(field)) {
                        f_clientModified = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("server_modified".equals(field)) {
                        f_serverModified = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("rev".equals(field)) {
                        f_rev = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("size".equals(field)) {
                        f_size = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("expires".equals(field)) {
                        f_expires = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("team_member_info".equals(field)) {
                        f_teamMemberInfo = StoneSerializers.nullableStruct(TeamMemberInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("content_owner_team_info".equals(field)) {
                        f_contentOwnerTeamInfo = StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_linkPermissions == null) {
                    throw new JsonParseException(p, "Required field \"link_permissions\" missing.");
                }
                if (f_clientModified == null) {
                    throw new JsonParseException(p, "Required field \"client_modified\" missing.");
                }
                if (f_serverModified == null) {
                    throw new JsonParseException(p, "Required field \"server_modified\" missing.");
                }
                if (f_rev == null) {
                    throw new JsonParseException(p, "Required field \"rev\" missing.");
                }
                if (f_size == null) {
                    throw new JsonParseException(p, "Required field \"size\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileLinkMetadata value = new FileLinkMetadata(f_url, f_name, f_linkPermissions, f_clientModified, f_serverModified, f_rev, f_size, f_id, f_expires, f_pathLower, f_teamMemberInfo, f_contentOwnerTeamInfo);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends SharedLinkMetadata.Builder {
        protected final Date clientModified;
        protected final Date serverModified;
        protected final String rev;
        protected final long size;

        protected Builder(String url, String name, LinkPermissions linkPermissions, Date clientModified, Date serverModified, String rev, long size) {
            super(url, name, linkPermissions);
            if (clientModified == null) {
                throw new IllegalArgumentException("Required value for 'clientModified' is null");
            }
            this.clientModified = LangUtil.truncateMillis(clientModified);
            if (serverModified == null) {
                throw new IllegalArgumentException("Required value for 'serverModified' is null");
            }
            this.serverModified = LangUtil.truncateMillis(serverModified);
            if (rev == null) {
                throw new IllegalArgumentException("Required value for 'rev' is null");
            }
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
            this.rev = rev;
            this.size = size;
        }

        @Override
        public Builder withId(String id) {
            super.withId(id);
            return this;
        }

        @Override
        public Builder withExpires(Date expires) {
            super.withExpires(expires);
            return this;
        }

        @Override
        public Builder withPathLower(String pathLower) {
            super.withPathLower(pathLower);
            return this;
        }

        @Override
        public Builder withTeamMemberInfo(TeamMemberInfo teamMemberInfo) {
            super.withTeamMemberInfo(teamMemberInfo);
            return this;
        }

        @Override
        public Builder withContentOwnerTeamInfo(Team contentOwnerTeamInfo) {
            super.withContentOwnerTeamInfo(contentOwnerTeamInfo);
            return this;
        }

        @Override
        public FileLinkMetadata build() {
            return new FileLinkMetadata(this.url, this.name, this.linkPermissions, this.clientModified, this.serverModified, this.rev, this.size, this.id, this.expires, this.pathLower, this.teamMemberInfo, this.contentOwnerTeamInfo);
        }
    }
}

